/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.refactoring.api.WhereUsedQueryConstants;
import org.netbeans.modules.cnd.refactoring.elements.CsmRefactoringElementImpl;
import org.netbeans.modules.cnd.refactoring.plugins.CsmRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.spi.CsmWhereUsedExtraObjectsProvider;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class CsmWhereUsedQueryPlugin
extends CsmRefactoringPlugin {
    private final WhereUsedQuery refactoring;
    private final CsmObject startReferenceObject;

    public CsmWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
        this.startReferenceObject = (CsmObject)refactoring.getRefactoringSource().lookup(CsmObject.class);
    }

    public Problem prepare(RefactoringElementsBag elements) {
        CsmObject referencedObject;
        CsmUID referencedObjectUID = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        CsmObject csmObject = referencedObject = referencedObjectUID == null ? null : (CsmObject)referencedObjectUID.getObject();
        if (referencedObject == null) {
            return null;
        }
        Collection<RefactoringElementImplementation> res = this.doPrepareElements(referencedObject, elements);
        elements.addAll((AbstractRefactoring)this.refactoring, res);
        this.fireProgressListenerStop();
        return null;
    }

    Collection<RefactoringElementImplementation> doPrepareElements(CsmObject referencedObject, RefactoringElementsBag bagToAdd) {
        Collection<RefactoringElementImplementation> res = null;
        if ((referencedObject = CsmRefactoringUtils.convertToCsmObjectIfNeeded(referencedObject)) == null) {
            return Collections.emptyList();
        }
        long time = System.currentTimeMillis();
        if (this.isFindUsages()) {
            if (CsmKindUtilities.isFile((CsmObject)referencedObject)) {
                this.fireProgressListenerStart(1, 2);
                res = this.processIncludeQuery((CsmFile)referencedObject);
            } else if (Boolean.getBoolean("cnd.model.global.index")) {
                Collection<CsmObject> referencedObjects = this.getObjectsForFindUsages(referencedObject);
                this.fireProgressListenerStart(1, referencedObjects.size() + 2);
                res = this.processObjectUsagesQuery(referencedObjects);
            } else {
                Collection<CsmObject> referencedObjects = this.getObjectsForFindUsages(referencedObject);
                CsmFile startFile = CsmRefactoringUtils.getCsmFile(this.startReferenceObject);
                HashSet<CsmFile> files = new HashSet<CsmFile>();
                for (CsmObject csmObject : referencedObjects) {
                    files.addAll(this.getRelevantFiles(startFile, csmObject, (AbstractRefactoring)this.refactoring));
                }
                LOG.log(Level.FINE, "preparing files took {0}ms", System.currentTimeMillis() - time);
                this.fireProgressListenerStart(1, files.size() + 2);
                res = this.processObjectUsagesQuery(referencedObjects, files, bagToAdd);
            }
        } else if (this.isFindDirectSubclassesOnly() || this.isFindSubclasses()) {
            assert (CsmKindUtilities.isClass((CsmObject)referencedObject)) : "must be class";
            this.fireProgressListenerStart(1, 2);
            res = this.processSubclassesQuery((CsmClass)referencedObject);
        } else if (this.isFindOverridingMethods()) {
            assert (CsmKindUtilities.isMethod((CsmObject)referencedObject)) : "must be method";
            this.fireProgressListenerStart(1, 2);
            res = this.processOverridenMethodsQuery((CsmMethod)referencedObject);
        }
        LOG.log(Level.FINE, "preparing FindUsages elements took {0}ms", System.currentTimeMillis() - time);
        this.fireProgressListenerStep();
        return res;
    }

    @Override
    public Problem preCheck() {
        CsmUID uid = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        Problem invalidContext = new Problem(true, NbBundle.getMessage(CsmWhereUsedQueryPlugin.class, (String)"MSG_InvalidObjectNothingToFind"));
        if (uid == null) {
            CsmFile startFile = CsmRefactoringUtils.getCsmFile(this.startReferenceObject);
            if (startFile == null || !startFile.isValid()) {
                return invalidContext;
            }
            return super.preCheck();
        }
        CsmObject referencedObject = (CsmObject)uid.getObject();
        if (!CsmBaseUtilities.isValid((CsmObject)referencedObject)) {
            return invalidContext;
        }
        return super.preCheck();
    }

    @Override
    public Problem fastCheckParameters() {
        CsmUID uid = (CsmUID)this.refactoring.getRefactoringSource().lookup(CsmUID.class);
        if (uid != null && CsmKindUtilities.isMethod((CsmObject)((CsmObject)uid.getObject()))) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return super.fastCheckParameters();
    }

    public static Collection<RefactoringElementImplementation> getWhereUsed(CsmReference ref, Map<Object, Boolean> params) {
        CsmObject targetObject = ref.getReferencedObject();
        Lookup lkp = Lookups.singleton((Object)ref);
        WhereUsedQuery query = new WhereUsedQuery(lkp);
        Collection<CsmProject> prjs = CsmRefactoringUtils.getRelatedCsmProjects(targetObject, ref.getContainingFile().getProject());
        CsmProject[] ar = prjs.toArray(new CsmProject[prjs.size()]);
        query.getContext().add((Object)ar);
        for (Map.Entry<Object, Boolean> entry : params.entrySet()) {
            query.putValue(entry.getKey(), (Object)entry.getValue());
        }
        CsmWhereUsedQueryPlugin whereUsedPlugin = new CsmWhereUsedQueryPlugin(query);
        Collection<RefactoringElementImplementation> elements = whereUsedPlugin.doPrepareElements(targetObject, null);
        return elements;
    }

    private Problem checkParametersForMethod(boolean overriders, boolean usages) {
        if (!usages && !overriders) {
            return new Problem(true, NbBundle.getMessage(CsmWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    private Collection<CsmObject> getObjectsForFindUsages(CsmObject startObject) {
        LinkedHashSet<CsmObject> out = new LinkedHashSet<CsmObject>();
        if (this.isFindUsages()) {
            Collection<CsmObject> allObjects = this.collectAllObjects(startObject);
            for (CsmObject referencedObject : allObjects) {
                if (CsmKindUtilities.isMethod((CsmObject)referencedObject)) {
                    CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject));
                    if (CsmVirtualInfoQuery.getDefault().isVirtual(method)) {
                        out.addAll(CsmVirtualInfoQuery.getDefault().getOverriddenMethods(method, this.isSearchFromBaseClass()));
                    }
                } else if (CsmKindUtilities.isClass((CsmObject)referencedObject)) {
                    out.addAll(CsmRefactoringUtils.getConstructors((CsmClass)referencedObject));
                }
                out.add(referencedObject);
            }
        }
        return out;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS);
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    private Collection<RefactoringElementImplementation> processObjectUsagesQuery(Collection<CsmObject> csmObjects) {
        assert (this.isFindUsages()) : "must be find usages mode";
        final boolean onlyUsages = !this.isFindOverridingMethods();
        final CsmReferenceRepository xRef = CsmReferenceRepository.getDefault();
        final ConcurrentLinkedQueue<RefactoringElementImplementation> elements = new ConcurrentLinkedQueue<RefactoringElementImplementation>();
        final Set kinds = CsmReferenceKind.ALL;
        final CsmReferenceRepository.Interrupter interrupter = new CsmReferenceRepository.Interrupter(){

            public boolean cancelled() {
                return CsmWhereUsedQueryPlugin.this.isCancelled();
            }
        };
        RequestProcessor rp = new RequestProcessor("FindUsagesQuery", CndUtils.getNumberCndWorkerThreads() + 1);
        final CountDownLatch waitFinished = new CountDownLatch(csmObjects.size());
        for (final CsmObject curObj : csmObjects) {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block11: {
                        try {
                            if (CsmWhereUsedQueryPlugin.this.isCancelled()) break block11;
                            String oldName = Thread.currentThread().getName();
                            try {
                                Thread.currentThread().setName("FindUsagesQuery: Analyzing " + curObj);
                                Collection refs = xRef.getReferences(curObj, (CsmProject)null, kinds, interrupter);
                                for (CsmReference csmReference : refs) {
                                    boolean accept = true;
                                    if (onlyUsages) {
                                        boolean bl = accept = !CsmReferenceResolver.getDefault().isKindOf(csmReference, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
                                    }
                                    if (!accept) continue;
                                    elements.add(CsmRefactoringElementImpl.create(csmReference, true));
                                }
                            }
                            finally {
                                Thread.currentThread().setName(oldName);
                            }
                            CsmWhereUsedQueryPlugin csmWhereUsedQueryPlugin = CsmWhereUsedQueryPlugin.this;
                            synchronized (csmWhereUsedQueryPlugin) {
                                CsmWhereUsedQueryPlugin.this.fireProgressListenerStep();
                            }
                        }
                        finally {
                            waitFinished.countDown();
                        }
                    }
                }
            };
            rp.post(task);
        }
        try {
            waitFinished.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RefactoringElementImplementation> processObjectUsagesQuery(Collection<CsmObject> csmObjects, Collection<CsmFile> files, RefactoringElementsBag bagToAdd) {
        assert (this.isFindUsages()) : "must be find usages mode";
        boolean onlyUsages = !this.isFindOverridingMethods();
        CsmReferenceRepository xRef = CsmReferenceRepository.getDefault();
        Set kinds = CsmReferenceKind.ALL;
        CsmObject[] objs = csmObjects.toArray(new CsmObject[csmObjects.size()]);
        CsmReferenceRepository.Interrupter interrupter = new CsmReferenceRepository.Interrupter(){

            public boolean cancelled() {
                return CsmWhereUsedQueryPlugin.this.isCancelled();
            }
        };
        RequestProcessor rp = new RequestProcessor("FindUsagesQuery", CndUtils.getNumberCndWorkerThreads() + 1);
        long time = System.currentTimeMillis();
        ArrayList<CsmFile> sortedFiles = new ArrayList<CsmFile>(files);
        Collections.sort(sortedFiles, new Comparator<CsmFile>(){

            @Override
            public int compare(CsmFile o1, CsmFile o2) {
                CsmProject prj1 = o1.getProject();
                CsmProject prj2 = o2.getProject();
                if (prj1 == null || prj2 == null || prj1.equals(prj2)) {
                    return CharSequences.comparator().compare(o1.getName(), o2.getName());
                }
                return CharSequences.comparator().compare(prj1.getName(), prj2.getName());
            }
        });
        LOG.log(Level.FINE, "creation of sorted {0} files took {1}ms", new Object[]{sortedFiles.size(), System.currentTimeMillis() - time});
        ArrayList<OneFileWorker> work = new ArrayList<OneFileWorker>(sortedFiles.size());
        for (CsmFile file : sortedFiles) {
            OneFileWorker task = new OneFileWorker(interrupter, file, onlyUsages, xRef, kinds, objs);
            work.add(task);
            rp.post((Runnable)task);
        }
        ArrayList<RefactoringElementImplementation> elements = new ArrayList<RefactoringElementImplementation>(work.size() * 2);
        int indexNonEmpty = 0;
        int total = 0;
        for (OneFileWorker workUnit : work) {
            OneFileWorker oneFileWorker;
            if (this.isCancelled()) break;
            Collection exposedElements = workUnit.exposedElements;
            while (exposedElements == null && !this.isCancelled()) {
                oneFileWorker = workUnit;
                synchronized (oneFileWorker) {
                    exposedElements = workUnit.exposedElements;
                    if (exposedElements == null) {
                        try {
                            workUnit.wait();
                        }
                        catch (InterruptedException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }
            assert (exposedElements != null || this.isCancelled());
            if (exposedElements == null || exposedElements.isEmpty()) continue;
            if (bagToAdd == null) {
                elements.addAll(exposedElements);
            } else {
                oneFileWorker = bagToAdd;
                synchronized (oneFileWorker) {
                    bagToAdd.addAll((AbstractRefactoring)this.refactoring, exposedElements);
                }
            }
            LOG.log(Level.FINEST, "[{0}/{1}] {2}", new Object[]{++indexNonEmpty, total += exposedElements.size(), workUnit.file.getAbsolutePath()});
        }
        return elements;
    }

    private Collection<RefactoringElementImplementation> processOverridenMethodsQuery(CsmMethod startMethod) {
        assert (this.isFindOverridingMethods()) : "must be search for overriden methods";
        LinkedHashSet<RefactoringElementImplementation> elements = new LinkedHashSet<RefactoringElementImplementation>(1024);
        Collection<CsmObject> allObjects = this.collectAllObjects((CsmObject)startMethod);
        HashSet<CsmMethod> allMethods = new HashSet<CsmMethod>();
        for (CsmObject obj : allObjects) {
            CsmMethod method;
            if (!CsmKindUtilities.isMethod((CsmObject)obj) || (method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)obj))) == null) continue;
            allMethods.add(method);
        }
        for (CsmMethod csmMethod : allMethods) {
            Collection overrides = CsmVirtualInfoQuery.getDefault().getOverriddenMethods(csmMethod, this.isSearchFromBaseClass());
            overrides.add(csmMethod);
            for (CsmMethod method : overrides) {
                CsmFunctionDefinition def;
                CsmReference declRef = CsmReferenceSupport.createObjectReference((CsmOffsetable)method);
                elements.add(CsmRefactoringElementImpl.create(declRef, false));
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)method) || (def = method.getDefinition()) == null) continue;
                CsmReference defRef = CsmReferenceSupport.createObjectReference((CsmOffsetable)def);
                elements.add(CsmRefactoringElementImpl.create(defRef, false));
            }
        }
        return elements;
    }

    @Override
    protected final ModificationResult processFiles(Collection<CsmFile> files, AtomicReference<Problem> outProblem) {
        return null;
    }

    private Collection<RefactoringElementImplementation> processIncludeQuery(CsmFile startFile) {
        assert (this.isFindUsages()) : "must be find usages";
        LinkedHashSet<RefactoringElementImplementation> elements = new LinkedHashSet<RefactoringElementImplementation>(1024);
        Collection<CsmObject> allObjects = this.collectAllObjects((CsmObject)startFile);
        HashSet<CsmFile> allFiles = new HashSet<CsmFile>();
        for (CsmObject obj : allObjects) {
            if (!CsmKindUtilities.isFile((CsmObject)obj)) continue;
            allFiles.add((CsmFile)obj);
        }
        for (CsmFile csmFile : allFiles) {
            Collection refs = CsmIncludeHierarchyResolver.getDefault().getIncludes(csmFile);
            CsmProject[] prjs = (CsmProject[])this.refactoring.getContext().lookup(CsmProject[].class);
            if (prjs != null && prjs.length != 0) {
                block2: for (CsmReference csmReference : refs) {
                    for (CsmProject prj : prjs) {
                        if (!csmReference.getContainingFile().getProject().equals(prj)) continue;
                        elements.add(CsmRefactoringElementImpl.create(csmReference, false));
                        continue block2;
                    }
                }
                continue;
            }
            for (CsmReference csmReference : refs) {
                elements.add(CsmRefactoringElementImpl.create(csmReference, false));
            }
        }
        return elements;
    }

    private Collection<RefactoringElementImplementation> processSubclassesQuery(CsmClass startClass) {
        assert (this.isFindDirectSubclassesOnly() || this.isFindSubclasses()) : "must be search of subclasses";
        LinkedHashSet<RefactoringElementImplementation> elements = new LinkedHashSet<RefactoringElementImplementation>(1024);
        boolean directSubtypesOnly = this.isFindDirectSubclassesOnly();
        Collection<CsmObject> allObjects = this.collectAllObjects((CsmObject)startClass);
        for (CsmObject obj : allObjects) {
            if (!CsmKindUtilities.isClass((CsmObject)obj)) continue;
            CsmClass referencedClass = (CsmClass)obj;
            Collection refs = CsmTypeHierarchyResolver.getDefault().getSubTypes(referencedClass, directSubtypesOnly);
            for (CsmReference csmReference : refs) {
                elements.add(CsmRefactoringElementImpl.create(csmReference, false));
            }
        }
        return elements;
    }

    private Collection<CsmObject> collectAllObjects(CsmObject primaryObject) {
        HashSet<CsmObject> allObjects = new HashSet<CsmObject>();
        if (primaryObject != null) {
            allObjects.add(primaryObject);
            for (CsmWhereUsedExtraObjectsProvider provider : Lookup.getDefault().lookupAll(CsmWhereUsedExtraObjectsProvider.class)) {
                allObjects.addAll(provider.getExtraObjects(primaryObject));
            }
            allObjects.addAll(this.getEqualObjects(primaryObject));
        }
        return allObjects;
    }

    private final class OneFileWorker
    implements Runnable {
        final CsmReferenceRepository.Interrupter interrupter;
        private final CsmFile file;
        private volatile Collection<RefactoringElementImplementation> exposedElements = null;
        private final boolean onlyUsages;
        private final CsmReferenceRepository xRef;
        private final Set<CsmReferenceKind> kinds;
        private final CsmObject[] objs;

        public OneFileWorker(CsmReferenceRepository.Interrupter interrupter, CsmFile file, boolean onlyUsages, CsmReferenceRepository xRef, Set<CsmReferenceKind> kinds, CsmObject[] objs) {
            this.interrupter = interrupter;
            this.file = file;
            this.onlyUsages = onlyUsages;
            this.xRef = xRef;
            this.kinds = kinds;
            this.objs = objs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                List fileElems = Collections.emptyList();
                try {
                    if (CsmWhereUsedQueryPlugin.this.isCancelled()) break block17;
                    String oldName = Thread.currentThread().getName();
                    try {
                        Thread.currentThread().setName("FindUsagesQuery: Analyzing " + this.file.getAbsolutePath());
                        Collection refs = this.xRef.getReferences(this.objs, this.file, this.kinds, this.interrupter);
                        fileElems = new ArrayList(refs.size());
                        for (CsmReference csmReference : refs) {
                            boolean accept = true;
                            if (this.onlyUsages) {
                                boolean bl = accept = !CsmReferenceResolver.getDefault().isKindOf(csmReference, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
                            }
                            if (!accept) continue;
                            fileElems.add(CsmRefactoringElementImpl.create(csmReference, true));
                        }
                    }
                    finally {
                        Thread.currentThread().setName(oldName);
                    }
                    CsmWhereUsedQueryPlugin csmWhereUsedQueryPlugin = CsmWhereUsedQueryPlugin.this;
                    synchronized (csmWhereUsedQueryPlugin) {
                        CsmWhereUsedQueryPlugin.this.fireProgressListenerStep();
                    }
                }
                finally {
                    OneFileWorker oneFileWorker = this;
                    synchronized (oneFileWorker) {
                        this.exposedElements = fileElems;
                        this.notifyAll();
                    }
                }
            }
        }
    }
}

