/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.plugins;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.spi.CsmRenameExtraObjectsProvider;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ModificationResult;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CsmRenameRefactoringPlugin
extends CsmModificationRefactoringPlugin {
    private final RenameRefactoring refactoring;
    private Collection<CsmObject> referencedObjects;

    public CsmRenameRefactoringPlugin(RenameRefactoring rename) {
        super((AbstractRefactoring)rename);
        this.refactoring = rename;
    }

    @Override
    public Problem fastCheckParameters() {
        Problem fastCheckProblem = null;
        String newName = this.refactoring.getNewName();
        CsmObject refObj = this.getStartReferenceObject();
        String oldName = CsmRefactoringUtils.getSimpleText(refObj);
        if (oldName.equals(newName)) {
            fastCheckProblem = CsmRenameRefactoringPlugin.createProblem(fastCheckProblem, true, CsmRenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return fastCheckProblem;
        }
        String errorFmtStr = null;
        if (CsmKindUtilities.isFile((CsmObject)refObj)) {
            if (!this.checkFileName(newName)) {
                errorFmtStr = CsmRenameRefactoringPlugin.getString("ERR_InvalidFileName");
            }
        } else if (!CndLexerUtilities.isCppIdentifier((CharSequence)newName)) {
            errorFmtStr = CsmRenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
        }
        if (errorFmtStr != null) {
            String msg = new MessageFormat(errorFmtStr).format(new Object[]{newName});
            fastCheckProblem = CsmRenameRefactoringPlugin.createProblem(fastCheckProblem, true, msg);
            return fastCheckProblem;
        }
        return fastCheckProblem;
    }

    private boolean checkFileName(String str) {
        return !str.contains("\\") && !str.contains("/");
    }

    @Override
    public Problem preCheck() {
        Problem preCheckProblem = null;
        this.fireProgressListenerStart(1, 5);
        if (this.referencedObjects == null) {
            this.initReferencedObjects();
            this.fireProgressListenerStep();
        }
        if ((preCheckProblem = this.isResovledElement(this.getStartReferenceObject())) != null) {
            return preCheckProblem;
        }
        CsmObject directReferencedObject = CsmRefactoringUtils.getReferencedElement(this.getStartReferenceObject());
        preCheckProblem = this.checkIfModificationPossible(preCheckProblem, directReferencedObject);
        this.fireProgressListenerStop();
        return preCheckProblem;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(CsmRenameRefactoringPlugin.class, (String)key);
    }

    private void initReferencedObjects() {
        CsmObject primaryObject = CsmRefactoringUtils.getReferencedElement(this.getStartReferenceObject());
        if (primaryObject != null) {
            HashSet<CsmObject> objects = new HashSet<CsmObject>();
            objects.add(primaryObject);
            for (CsmRenameExtraObjectsProvider provider : Lookup.getDefault().lookupAll(CsmRenameExtraObjectsProvider.class)) {
                objects.addAll(provider.getExtraObjects(primaryObject));
            }
            this.referencedObjects = new LinkedHashSet<CsmObject>();
            HashSet<? extends CsmObject> allObjects = new HashSet<CsmObject>();
            for (CsmObject csmObject : objects) {
                allObjects.addAll(this.getEqualObjects(csmObject));
            }
            for (CsmObject csmObject : allObjects) {
                if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                    this.referencedObjects.addAll(this.getRenamingClassObjects((CsmClass)csmObject));
                    continue;
                }
                if (CsmKindUtilities.isConstructor((CsmObject)csmObject) || CsmKindUtilities.isDestructor((CsmObject)csmObject)) {
                    CsmFunction fun = (CsmFunction)csmObject;
                    CsmClass cls = CsmBaseUtilities.getFunctionClass((CsmFunction)fun);
                    if (cls == null) continue;
                    this.referencedObjects.addAll(this.getRenamingClassObjects(cls));
                    continue;
                }
                if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
                    CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)csmObject));
                    this.referencedObjects.add((CsmObject)method);
                    if (!CsmVirtualInfoQuery.getDefault().isVirtual(method)) continue;
                    this.referencedObjects.addAll(CsmVirtualInfoQuery.getDefault().getOverriddenMethods(method, true));
                    assert (!this.referencedObjects.isEmpty()) : "must be at least start object " + method;
                    continue;
                }
                if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
                    CsmFile file = (CsmFile)csmObject;
                    FileObject fileObject = file.getFileObject();
                    try {
                        DataObject dob = DataObject.find((FileObject)fileObject);
                        if (dob == null) continue;
                        CsmFile[] csmFiles = CsmUtilities.getCsmFiles((DataObject)dob, (boolean)true, (boolean)false);
                        this.referencedObjects.addAll(Arrays.asList(csmFiles));
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                this.referencedObjects.add(csmObject);
            }
        }
    }

    @Override
    protected Collection<CsmFile> getRefactoredFiles() {
        Collection<CsmObject> objs = this.getRefactoredObjects();
        if (objs == null || objs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<CsmFile> files = new HashSet<CsmFile>();
        CsmFile startFile = this.getStartCsmFile();
        for (CsmObject obj : objs) {
            Collection<CsmProject> prjs = CsmRefactoringUtils.getRelatedCsmProjects(obj, null);
            CsmProject[] ar = prjs.toArray(new CsmProject[prjs.size()]);
            this.refactoring.getContext().add((Object)ar);
            files.addAll(this.getRelevantFiles(startFile, obj, (AbstractRefactoring)this.refactoring));
        }
        return files;
    }

    private CsmFile getStartCsmFile() {
        CsmFile startFile = CsmRefactoringUtils.getCsmFile(this.getStartReferenceObject());
        if (startFile == null && this.getEditorContext() != null) {
            startFile = this.getEditorContext().getFile();
        }
        return startFile;
    }

    private Collection<CsmObject> getRefactoredObjects() {
        return this.referencedObjects == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.referencedObjects);
    }

    private Collection<? extends CsmObject> getRenamingClassObjects(CsmClass clazz) {
        ArrayList<Object> out = new ArrayList<Object>(5);
        if (clazz != null) {
            out.add(clazz);
            for (CsmMember member : clazz.getMembers()) {
                if (CsmKindUtilities.isConstructor((CsmObject)member)) {
                    out.add(member);
                    continue;
                }
                if (!CsmKindUtilities.isDestructor((CsmObject)member)) continue;
                out.add(member);
            }
        }
        return out;
    }

    @Override
    protected final void processFile(CsmFile csmFile, ModificationResult mr, AtomicReference<Problem> outProblem) {
        Collection<CsmObject> refObjects = this.getRefactoredObjects();
        assert (refObjects != null && refObjects.size() > 0) : "method must be called for resolved element";
        FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
        LinkedHashSet<CsmReference> refs = new LinkedHashSet<CsmReference>();
        for (CsmObject obj : refObjects) {
            if (CsmKindUtilities.isFile((CsmObject)obj)) {
                CsmFile includedFile = (CsmFile)obj;
                Collection includes = csmFile.getIncludes();
                for (CsmInclude csmInclude : includes) {
                    if (!includedFile.equals(csmInclude.getIncludeFile())) continue;
                    refs.add(CsmReferenceSupport.createObjectReference((CsmObject)includedFile, (CsmOffsetable)csmInclude));
                }
                continue;
            }
            Collection curRefs = CsmReferenceRepository.getDefault().getReferences(obj, csmFile, CsmReferenceKind.ALL, null);
            refs.addAll(curRefs);
        }
        Collection<CsmReference> extraRefs = this.getExtraRenameModificationsInFile(refObjects, csmFile, CsmReferenceKind.ALL);
        refs.addAll(extraRefs);
        if (!refs.isEmpty()) {
            ArrayList<CsmReference> sortedRefs = new ArrayList<CsmReference>(refs);
            Collections.sort(sortedRefs, new Comparator<CsmReference>(){

                @Override
                public int compare(CsmReference o1, CsmReference o2) {
                    return o1.getStartOffset() - o2.getStartOffset();
                }
            });
            CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
            this.processRefactoredReferences(sortedRefs, fo, ces, mr);
        }
    }

    private void processRefactoredReferences(List<CsmReference> sortedRefs, FileObject fo, CloneableEditorSupport ces, ModificationResult mr) {
        String newName = this.refactoring.getNewName();
        for (CsmReference ref : sortedRefs) {
            String oldText = ((Object)ref.getText()).toString();
            String newText = CsmRefactoringUtils.getReplaceText(ref, newName, (AbstractRefactoring)this.refactoring);
            if (newText == null) continue;
            String descr = CsmRefactoringUtils.getReplaceDescription(ref, (AbstractRefactoring)this.refactoring);
            ModificationResult.Difference diff = CsmRefactoringUtils.rename(ref.getStartOffset(), ref.getEndOffset(), ces, oldText, newText, descr);
            assert (diff != null);
            mr.addDifference(fo, diff);
        }
    }

    private Collection<CsmReference> getExtraRenameModificationsInFile(Collection<? extends CsmObject> objs, CsmFile csmFile, Set<CsmReferenceKind> kinds) {
        HashSet<CsmReference> out = new HashSet<CsmReference>();
        for (CsmRenameExtraObjectsProvider prov : Lookup.getDefault().lookupAll(CsmRenameExtraObjectsProvider.class)) {
            out.addAll(prov.getExtraFileReferences(objs, csmFile, kinds));
        }
        return out;
    }
}

