/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceFieldPanel;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceKind;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceMethodPanel;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceVariablePanel;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class IntroduceHint {
    private AtomicBoolean cancel = new AtomicBoolean();
    private static final Set<CppTokenId> WHITESPACES = EnumSet.of(CppTokenId.WHITESPACE, new CppTokenId[]{CppTokenId.NEW_LINE, CppTokenId.ESCAPED_LINE, CppTokenId.ESCAPED_WHITESPACE, CppTokenId.BLOCK_COMMENT, CppTokenId.LINE_COMMENT, CppTokenId.DOXYGEN_COMMENT, CppTokenId.DOXYGEN_LINE_COMMENT});

    static int[] ignoreWhitespaces(CsmContext info, int start, int end) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)info.getDocument(), (int)start, (boolean)true, (boolean)false);
        if (ts == null) {
            return new int[]{start, end};
        }
        ts.move(start);
        if (ts.moveNext()) {
            boolean wasMoveNext = true;
            while (WHITESPACES.contains(ts.token().id()) && (wasMoveNext = ts.moveNext())) {
            }
            if (wasMoveNext && ts.offset() > start) {
                start = ts.offset();
            }
        }
        ts.move(end);
        while (ts.movePrevious() && WHITESPACES.contains(ts.token().id()) && ts.offset() < end) {
            end = ts.offset();
        }
        return new int[]{start, end};
    }

    static CsmObject validateSelection(CsmContext info, int start, int end) {
        return null;
    }

    static CsmObject validateSelectionForIntroduceMethod(CsmContext ci, int start, int end, int[] statementsSpan) {
        int[] span = IntroduceHint.ignoreWhitespaces(ci, Math.min(start, end), Math.max(start, end));
        if ((start = span[0]) >= (end = span[1])) {
            return null;
        }
        return null;
    }

    public void cancel() {
        this.cancel.set(true);
    }

    static List<ErrorDescription> computeError(CsmContext info, Map<IntroduceKind, Fix> fixesMap, Map<IntroduceKind, String> errorMessage, AtomicBoolean cancel) {
        LinkedList<ErrorDescription> hints = new LinkedList<ErrorDescription>();
        String guessedName = Utilities.guessName(info);
        IntroduceFix variable = new IntroduceFix(info, guessedName, 1, IntroduceKind.CREATE_VARIABLE);
        IntroduceFix constant = new IntroduceFix(info, guessedName, 1, IntroduceKind.CREATE_CONSTANT);
        Object field = null;
        IntroduceExpressionBasedMethodFix methodFix = null;
        LinkedList<CsmType> paramTypes = new LinkedList<CsmType>();
        LinkedList<String> paramNames = new LinkedList<String>();
        HashSet<CsmType> exceptionHandles = new HashSet<CsmType>();
        methodFix = new IntroduceExpressionBasedMethodFix(info, null, paramTypes, paramNames, exceptionHandles);
        if (fixesMap != null) {
            fixesMap.put(IntroduceKind.CREATE_VARIABLE, variable);
            fixesMap.put(IntroduceKind.CREATE_CONSTANT, constant);
            fixesMap.put(IntroduceKind.CREATE_FIELD, (Fix)field);
            fixesMap.put(IntroduceKind.CREATE_METHOD, methodFix);
        }
        return hints;
    }

    private static final class IntroduceExpressionBasedMethodFix
    implements Fix {
        private final CsmContext context;
        private final CsmExpressionStatement expression;
        private final List<CsmType> parameterTypes;
        private final List<String> parameterNames;

        public IntroduceExpressionBasedMethodFix(CsmContext context, CsmExpressionStatement expression, List<CsmType> parameterTypes, List<String> parameterNames, Set<CsmType> thrownTypes) {
            this.context = context;
            this.expression = expression;
            this.parameterTypes = parameterTypes;
            this.parameterNames = parameterNames;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
        }

        public String toString() {
            return "[IntroduceExpressionBasedMethodFix]";
        }

        public ChangeInfo implement() throws Exception {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceMethodPanel panel = new IntroduceMethodPanel("");
            panel.setOkButton(btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            String name = panel.getMethodName();
            CsmVisibility access = panel.getAccess();
            return null;
        }
    }

    private static final class IntroduceMethodFix
    implements Fix {
        private CsmFile csmFile;
        private CsmScope parentBlock;
        private List<CsmType> parameterTypes;
        private List<String> parameterNames;
        private List<CsmType> additionalLocalTypes;
        private List<String> additionalLocalNames;
        private CsmType returnType;
        private String returnName;
        private boolean declareVariableForReturnValue;
        private Set<CsmType> thrownTypes;
        private List<CsmObject> exists;
        private boolean exitsFromAllBranches;
        private int from;
        private int to;

        public IntroduceMethodFix(CsmFile csmFile, CsmScope parentBlock, List<CsmType> parameterTypes, List<String> parameterNames, List<CsmType> additionalLocalTypes, List<String> additionalLocalNames, CsmType returnType, String returnName, boolean declareVariableForReturnValue, Set<CsmType> thrownTypes, List<CsmObject> exists, boolean exitsFromAllBranches, int from, int to) {
            this.csmFile = csmFile;
            this.parentBlock = parentBlock;
            this.parameterTypes = parameterTypes;
            this.parameterNames = parameterNames;
            this.additionalLocalTypes = additionalLocalTypes;
            this.additionalLocalNames = additionalLocalNames;
            this.returnType = returnType;
            this.returnName = returnName;
            this.declareVariableForReturnValue = declareVariableForReturnValue;
            this.thrownTypes = thrownTypes;
            this.exists = exists;
            this.exitsFromAllBranches = exitsFromAllBranches;
            this.from = from;
            this.to = to;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceMethod");
        }

        public String toDebugString() {
            return "[IntroduceMethod:" + this.from + ":" + this.to + "]";
        }

        public ChangeInfo implement() throws Exception {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceMethodPanel panel = new IntroduceMethodPanel("");
            panel.setOkButton(btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceMethod");
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            return null;
        }
    }

    private static final class IntroduceFieldFix
    implements Fix {
        private String guessedName;
        private CsmObject handle;
        private CsmFile csmFile;
        private int numDuplicates;
        private int[] initilizeIn;
        private boolean statik;
        private boolean allowFinalInCurrentMethod;

        public IntroduceFieldFix(CsmObject handle, CsmFile csmFile, String guessedName, int numDuplicates, int[] initilizeIn, boolean statik, boolean allowFinalInCurrentMethod) {
            this.handle = handle;
            this.csmFile = csmFile;
            this.guessedName = guessedName;
            this.numDuplicates = numDuplicates;
            this.initilizeIn = initilizeIn;
            this.statik = statik;
            this.allowFinalInCurrentMethod = allowFinalInCurrentMethod;
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)"FIX_IntroduceField");
        }

        public String toString() {
            return "[IntroduceField:" + this.guessedName + ":" + this.numDuplicates + ":" + this.statik + ":" + this.allowFinalInCurrentMethod + ":" + Arrays.toString(this.initilizeIn) + "]";
        }

        public ChangeInfo implement() throws IOException, BadLocationException {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            btnOk.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_OK"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            btnCancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceHint.class, (String)"AD_IntrHint_Cancel"));
            IntroduceFieldPanel panel = new IntroduceFieldPanel(this.guessedName, this.initilizeIn, this.numDuplicates, this.allowFinalInCurrentMethod, btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)"CAP_IntroduceField");
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            return null;
        }
    }

    private static final class IntroduceFix
    implements Fix {
        private final String guessedName;
        private final CsmContext handle;
        private final int numDuplicates;
        private final IntroduceKind kind;

        public IntroduceFix(CsmContext handle, String guessedName, int numDuplicates, IntroduceKind kind) {
            this.handle = handle;
            this.guessedName = guessedName;
            this.numDuplicates = numDuplicates;
            this.kind = kind;
        }

        public String toString() {
            return "[IntroduceFix:" + this.guessedName + ":" + this.numDuplicates + ":" + (Object)((Object)this.kind) + "]";
        }

        public String getKeyExt() {
            switch (this.kind) {
                case CREATE_CONSTANT: {
                    return "IntroduceConstant";
                }
                case CREATE_VARIABLE: {
                    return "IntroduceVariable";
                }
            }
            throw new IllegalStateException();
        }

        public String getText() {
            return NbBundle.getMessage(IntroduceHint.class, (String)("FIX_" + this.getKeyExt()));
        }

        public ChangeInfo implement() throws IOException, BadLocationException {
            JButton btnOk = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Ok"));
            JButton btnCancel = new JButton(NbBundle.getMessage(IntroduceHint.class, (String)"LBL_Cancel"));
            IntroduceVariablePanel panel = new IntroduceVariablePanel(this.numDuplicates, this.guessedName, this.kind == IntroduceKind.CREATE_CONSTANT, btnOk);
            String caption = NbBundle.getMessage(IntroduceHint.class, (String)("CAP_" + this.getKeyExt()));
            DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{btnOk, btnCancel}, (Object)btnOk, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != btnOk) {
                return null;
            }
            return null;
        }
    }
}

