/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.codegen.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.modelutil.ui.CheckTreeView;
import org.netbeans.modules.cnd.modelutil.ui.ElementNode;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ElementSelectorPanel
extends JPanel
implements ExplorerManager.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final CheckTreeView elementView;
    private final JCheckBox inline = new JCheckBox();
    private boolean inlineMethod;

    public ElementSelectorPanel(ElementNode.Description elementDescription, boolean singleSelection, boolean supportInline) {
        this.setLayout(new BorderLayout());
        this.elementView = new CheckTreeView();
        this.elementView.setRootVisible(false);
        this.add((Component)this.elementView, "Center");
        if (supportInline) {
            Mnemonics.setLocalizedText((AbstractButton)this.inline, (String)NbBundle.getMessage(ElementSelectorPanel.class, (String)"LBL_inline_implementation"));
            this.inlineMethod = NbPreferences.forModule(DeclarationGenerator.class).getBoolean("insert_code_inline_method", true);
            this.inline.setSelected(this.inlineMethod);
            this.inline.setEnabled(false);
            this.add((Component)this.inline, "South");
        } else {
            this.inlineMethod = false;
        }
        this.setRootElement(elementDescription, singleSelection);
        Node root = this.manager.getRootContext();
        Node[] children = root.getChildren().getNodes();
        if (null != children && children.length > 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{children[0]});
            }
            catch (PropertyVetoException ex) {
                // empty catch block
            }
        }
    }

    public boolean isMethodInline() {
        this.inlineMethod = this.inline.isSelected();
        NbPreferences.forModule(DeclarationGenerator.class).putBoolean("insert_code_inline_method", this.inlineMethod);
        return this.inlineMethod;
    }

    public List<CsmDeclaration> getTreeSelectedElements() {
        ArrayList<CsmDeclaration> handles = new ArrayList<CsmDeclaration>();
        for (Node node : this.manager.getSelectedNodes()) {
            if (!(node instanceof ElementNode)) continue;
            ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
            handles.add(description.getElementHandle());
        }
        return handles;
    }

    public List<CsmDeclaration> getSelectedElements() {
        ArrayList<CsmDeclaration> handles = new ArrayList<CsmDeclaration>();
        Node n = this.manager.getRootContext();
        ElementNode.Description description = (ElementNode.Description)n.getLookup().lookup(ElementNode.Description.class);
        this.getSelectedHandles(description, handles);
        return handles;
    }

    public final void setRootElement(ElementNode.Description elementDescription, boolean singleSelection) {
        Node n;
        if (elementDescription != null) {
            ElementNode en = new ElementNode(elementDescription);
            en.setSingleSelection(singleSelection);
            n = en;
        } else {
            n = Node.EMPTY;
        }
        this.manager.setRootContext(n);
    }

    public void doInitialExpansion(int howMuch) {
        Node root = this.getExplorerManager().getRootContext();
        Node[] subNodes = root.getChildren().getNodes(true);
        if (subNodes == null) {
            return;
        }
        Node toSelect = null;
        int row = 0;
        boolean oldScroll = this.elementView.getScrollsOnExpand();
        this.elementView.setScrollsOnExpand(false);
        for (int i = 0; subNodes != null && i < (howMuch == -1 || howMuch > subNodes.length ? subNodes.length : howMuch); ++i) {
            this.elementView.expandRow(++row);
            Node[] ssn = subNodes[i].getChildren().getNodes(true);
            row += ssn.length;
            if (toSelect != null || ssn.length <= 0) continue;
            toSelect = this.getSelectedNode(ssn);
        }
        this.elementView.setScrollsOnExpand(oldScroll);
        try {
            if (toSelect != null) {
                this.getExplorerManager().setSelectedNodes(new Node[]{toSelect});
            }
        }
        catch (PropertyVetoException ex) {
            // empty catch block
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void getSelectedHandles(ElementNode.Description description, ArrayList<CsmDeclaration> target) {
        if (description == null) {
            return;
        }
        List subs = description.getSubs();
        if (subs == null) {
            return;
        }
        for (ElementNode.Description d : subs) {
            if (d.isSelectable() && d.isSelected()) {
                target.add(d.getElementHandle());
                continue;
            }
            this.getSelectedHandles(d, target);
        }
    }

    private Node getSelectedNode(Node[] children) {
        assert (children.length > 0) : "array must have elements";
        for (Node node : children) {
            ElementNode.Description descr = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
            if (descr == null || !descr.isSelected()) continue;
            return node;
        }
        return children[0];
    }
}

