/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api;

import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class ChangeParametersRefactoring
extends AbstractRefactoring {
    private ParameterInfo[] paramTable;
    private CsmVisibility visibility;
    private boolean useDefaultValueInFunctionDeclaration;

    public ChangeParametersRefactoring(CsmObject method, CsmContext editorContext) {
        super(ChangeParametersRefactoring.createLookup(method, editorContext));
    }

    private static Lookup createLookup(CsmObject method, CsmContext editorContext) {
        assert (method != null || editorContext != null) : "must be non null object to refactor";
        if (editorContext == null) {
            return Lookups.fixed((Object[])new Object[]{method});
        }
        if (method == null) {
            return Lookups.fixed((Object[])new Object[]{editorContext});
        }
        return Lookups.fixed((Object[])new Object[]{method, editorContext});
    }

    public ParameterInfo[] getParameterInfo() {
        return this.paramTable;
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isUseDefaultValueOnlyInFunctionDeclaration() {
        return this.useDefaultValueInFunctionDeclaration;
    }

    public void setParameterInfo(ParameterInfo[] paramTable) {
        this.paramTable = paramTable;
    }

    public void setVisibility(CsmVisibility visibility) {
        this.visibility = visibility;
    }

    public void setUseDefaultValueOnlyInFunctionDeclaration(boolean onlyInDef) {
        this.useDefaultValueInFunctionDeclaration = onlyInDef;
    }

    public static final class ParameterInfo {
        int origIndex;
        CharSequence name;
        CharSequence type;
        CharSequence defaultVal;

        public ParameterInfo(int origIndex, CharSequence name, CharSequence type, CharSequence defaultVal) {
            this.origIndex = origIndex;
            this.name = this.trim(name);
            this.type = this.trim(type);
            this.defaultVal = origIndex == -1 ? this.trim(defaultVal) : null;
        }

        private CharSequence trim(CharSequence cs) {
            CharSequence out = cs;
            if (cs != null && (out = ((Object)cs).toString().trim()).length() == cs.length()) {
                out = cs;
            }
            return out;
        }

        public ParameterInfo(int origIndex) {
            this(origIndex, null, null, null);
        }

        public int getOriginalIndex() {
            return this.origIndex;
        }

        public CharSequence getName() {
            return this.name;
        }

        public CharSequence getType() {
            return this.type;
        }

        public CharSequence getDefaultValue() {
            return this.defaultVal;
        }
    }
}

