/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.wizards.HibernateConfigurationWizardPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HibernateMappingWizardPanel
extends JPanel
implements AncestorListener {
    private Project project;
    List<FileObject> configFileObjects;
    List<String> databaseTables;
    private HibernateEnvironment env;
    private JButton browseButton;
    private JComboBox cmbDatabaseTable;
    private JComboBox cmbResource;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField txtClassName;

    public HibernateMappingWizardPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.env = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        String[] configFiles = this.getConfigFilesFromProject(project);
        this.cmbResource.setModel(new DefaultComboBoxModel<String>(configFiles));
        this.addAncestorListener(this);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateMappingWizardPanel.this.browseButtonActionPerformed(evt);
            }
        });
    }

    public void fillDatabaseTable() {
        if (this.cmbResource.getItemCount() == 0) {
            this.cmbDatabaseTable.setModel(new DefaultComboBoxModel<String>(new String[0]));
        } else if (this.cmbResource.getSelectedIndex() != -1) {
            try {
                this.databaseTables = this.env.getAllDatabaseTablesOnEventThread(this.configFileObjects.get(this.cmbResource.getSelectedIndex()));
                this.databaseTables.add(0, "");
                this.cmbDatabaseTable.setModel(new DefaultComboBoxModel<Object>(this.databaseTables.toArray()));
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DatabaseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle handle = TypeElementFinder.find(null, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
                    }

                    public boolean accept(ElementHandle<TypeElement> typeHandle) {
                        return true;
                    }
                });
                if (handle != null) {
                    HibernateMappingWizardPanel.this.txtClassName.setText(handle.getQualifiedName());
                }
            }
        });
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(HibernateConfigurationWizardPanel.class, (String)"LBL_HibernateMappingPanel_Name");
    }

    public String getClassName() {
        if (this.txtClassName.getText() != null) {
            return this.txtClassName.getText().trim();
        }
        return null;
    }

    public FileObject getConfigurationFile() {
        if (this.cmbResource.getSelectedIndex() != -1) {
            return this.configFileObjects.get(this.cmbResource.getSelectedIndex());
        }
        return null;
    }

    public String getDatabaseTable() {
        if (this.cmbDatabaseTable.getSelectedIndex() != -1) {
            return this.cmbDatabaseTable.getSelectedItem().toString().trim();
        }
        return null;
    }

    public String[] getConfigFilesFromProject(Project project) {
        ArrayList<String> configFiles = new ArrayList<String>();
        this.configFileObjects = this.env.getAllHibernateConfigFileObjects();
        for (FileObject fo : this.configFileObjects) {
            configFiles.add(fo.getNameExt());
        }
        return configFiles.toArray(new String[0]);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtClassName = new JTextField();
        this.browseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.cmbResource = new JComboBox();
        this.jLabel3 = new JLabel();
        this.cmbDatabaseTable = new JComboBox();
        this.setName(NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"LBL_HibernateMappingPanel_Name"));
        this.jLabel1.setLabelFor(this.txtClassName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.jLabel1.text"));
        this.txtClassName.setColumns(30);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.browseButton.text"));
        this.jLabel2.setLabelFor(this.cmbResource);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.jLabel2.text"));
        this.cmbResource.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbResource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HibernateMappingWizardPanel.this.cmbResourceActionPerformed(evt);
            }
        });
        this.jLabel3.setLabelFor(this.cmbDatabaseTable);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(HibernateMappingWizardPanel.class, (String)"HibernateMappingWizardPanel.jLabel3.text"));
        this.cmbDatabaseTable.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(27, 27, 27).addComponent(this.txtClassName, -1, 402, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbDatabaseTable, 0, 431, Short.MAX_VALUE).addComponent(this.cmbResource, 0, 431, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.browseButton).addComponent(this.txtClassName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.cmbResource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbDatabaseTable, -2, -1, -2).addComponent(this.jLabel3)).addContainerGap(16, Short.MAX_VALUE)));
    }

    private void cmbResourceActionPerformed(ActionEvent evt) {
        this.fillDatabaseTable();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HibernateMappingWizardPanel.this.fillDatabaseTable();
                    }
                });
            }
        });
        this.removeAncestorListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }
}

