/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.util;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class CustomJDBCConnectionProvider
implements ConnectionProvider {
    private Connection connection = null;
    private Properties connectionProperties = null;
    private Logger logger = Logger.getLogger(CustomJDBCConnectionProvider.class.getName());

    public void configure(Properties properties) throws HibernateException {
        this.connectionProperties = properties;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.logger.info("Connection already established.. returing");
            return this.connection;
        }
        try {
            String driverClassName = this.connectionProperties.getProperty("hibernate.connection.driver_class");
            String driverURL = this.connectionProperties.getProperty("hibernate.connection.url");
            String username = this.connectionProperties.getProperty("hibernate.connection.username");
            String password = this.connectionProperties.getProperty("hibernate.connection.password");
            if (driverClassName == null) {
                driverClassName = this.connectionProperties.getProperty("connection.driver_class");
            }
            if (driverURL == null) {
                driverURL = this.connectionProperties.getProperty("connection.url");
            }
            if (username == null) {
                username = this.connectionProperties.getProperty("connection.username");
            }
            if (password == null) {
                password = this.connectionProperties.getProperty("connection.password");
            }
            if (username == null) {
                username = "";
            }
            if (password == null) {
                password = "";
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(driverClassName);
            Driver driver = (Driver)clazz.newInstance();
            this.logger.info("Loaded JDBC driver ");
            Properties info = new Properties();
            info.setProperty("user", username);
            info.setProperty("password", password);
            this.connection = driver.connect(driverURL, info);
            this.logger.info("Got connection.. returning");
            info = null;
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.INFO, "DB Driver class not found during connection creation.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.INFO, "Cannot instantiate driver class.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.INFO, "Illegal access during connection creation.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        catch (SQLException e) {
            this.logger.log(Level.INFO, "DB connection error.", e);
            NotifyDescriptor.Exception ne = new NotifyDescriptor.Exception((Throwable)e);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)ne);
        }
        return this.connection;
    }

    public void closeConnection(Connection arg0) throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void close() throws HibernateException {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean supportsAggressiveRelease() {
        return true;
    }
}

