/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class WebServer {
    private static int PORT = 8383;
    private static final Logger LOGGER = Logger.getLogger(WebServer.class.getName());
    private WeakHashMap<Project, Pair> deployedApps = new WeakHashMap();
    private boolean init = false;
    private Server server;
    private static WebServer webServer;

    private WebServer() {
    }

    public static synchronized WebServer getWebserver() {
        if (webServer == null) {
            webServer = new WebServer();
        }
        return webServer;
    }

    private synchronized void checkStartedServer() {
        if (!this.init) {
            this.init = true;
            this.startServer();
        }
    }

    public void start(Project p, FileObject siteRoot, String webContextRoot) {
        assert (webContextRoot != null && webContextRoot.startsWith("/")) : "webContextRoot must start with slash character";
        this.checkStartedServer();
        this.deployedApps.remove(p);
        this.deployedApps.put(p, new Pair(webContextRoot, siteRoot));
    }

    public void stop(Project p) {
        this.deployedApps.remove(p);
    }

    public int getPort() {
        this.checkStartedServer();
        return this.server.getPort();
    }

    public URL toServer(FileObject projectFile) {
        Project p = FileOwnerQuery.getOwner((FileObject)projectFile);
        if (p != null) {
            Pair pair = this.deployedApps.get(p);
            if (pair != null) {
                String path = pair.webContextRoot + (pair.webContextRoot.equals("/") ? "" : "/") + FileUtil.getRelativePath((FileObject)pair.siteRoot, (FileObject)projectFile);
                return WebUtils.stringToUrl("http://localhost:" + this.getPort() + path);
            }
        } else {
            for (Map.Entry<Project, Pair> entry : this.deployedApps.entrySet()) {
                Pair pair = entry.getValue();
                String relPath = FileUtil.getRelativePath((FileObject)pair.siteRoot, (FileObject)projectFile);
                if (relPath == null) continue;
                String path = pair.webContextRoot + (pair.webContextRoot.equals("/") ? "" : "/") + relPath;
                return WebUtils.stringToUrl("http://localhost:" + this.getPort() + path);
            }
        }
        return null;
    }

    public FileObject fromServer(URL serverURL) {
        String path;
        try {
            path = serverURL.toURI().getPath();
        }
        catch (URISyntaxException ex) {
            path = serverURL.getPath();
        }
        return this.fromServer(path);
    }

    private FileObject fromServer(String serverURLPath) {
        Map.Entry<Project, Pair> rootEntry = null;
        for (Map.Entry<Project, Pair> entry : this.deployedApps.entrySet()) {
            if ("/".equals(entry.getValue().webContextRoot)) {
                rootEntry = entry;
                continue;
            }
            if (!serverURLPath.startsWith(entry.getValue().webContextRoot + "/")) continue;
            return this.findFile(entry, serverURLPath);
        }
        if (rootEntry != null) {
            return this.findFile(rootEntry, serverURLPath);
        }
        return null;
    }

    private FileObject findFile(Map.Entry<Project, Pair> entry, String serverURL) {
        int index = entry.getValue().webContextRoot.length() + 1;
        if (entry.getValue().webContextRoot.equals("/")) {
            index = 1;
        }
        String file = serverURL.substring(index);
        return entry.getValue().siteRoot.getFileObject(file);
    }

    private void startServer() {
        this.server = new Server();
        new Thread(this.server).start();
        Thread shutdown = new Thread(){

            @Override
            public void run() {
                WebServer.this.server.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdown);
    }

    static /* synthetic */ int access$200() {
        return PORT;
    }

    private static class Server
    implements Runnable {
        private AtomicBoolean stop = new AtomicBoolean(false);
        private ServerSocket sock;
        private int port = WebServer.access$200();

        public Server() {
            while (true) {
                try {
                    this.sock = new ServerSocket(this.port);
                }
                catch (IOException ex) {
                    ++this.port;
                    continue;
                }
                break;
            }
        }

        @Override
        public void run() {
            RequestProcessor pool = new RequestProcessor(WebServer.class.getName(), 10);
            while (!this.stop.get()) {
                Socket s;
                try {
                    s = this.sock.accept();
                }
                catch (SocketException ex) {
                    if (!this.stop.get()) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
                if (this.stop.get()) break;
                pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Server.this.read(s.getInputStream(), s.getOutputStream());
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.FINE, "reading socket failed", ex);
                        }
                    }
                });
            }
        }

        private void stop() {
            this.stop.set(true);
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int getPort() {
            return this.port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read(InputStream inputStream, OutputStream outputStream) throws IOException {
            block16: {
                BufferedReader r = null;
                FilterOutputStream out = null;
                InputStream fis = null;
                try {
                    FileObject fo;
                    r = new BufferedReader(new InputStreamReader(inputStream));
                    String line = r.readLine();
                    if (line == null || line.length() == 0) {
                        return;
                    }
                    if (!line.startsWith("GET ")) break block16;
                    StringTokenizer st = new StringTokenizer(line, " ");
                    st.nextToken();
                    String file = st.nextToken();
                    try {
                        file = URLDecoder.decode(file, "UTF-8");
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.log(Level.FINE, "cannot decode '" + file + "'", ex);
                    }
                    int queryIndex = file.indexOf(63);
                    if (queryIndex != -1) {
                        file = file.substring(0, queryIndex);
                    }
                    if ((fo = WebServer.getWebserver().fromServer(file)) != null && fo.isFolder()) {
                        fo = fo.getFileObject("index", "html");
                    }
                    if (fo != null) {
                        fis = fo.getInputStream();
                        out = new DataOutputStream(outputStream);
                        String mime = fo.getMIMEType();
                        if ("content/unknown".equals(mime)) {
                            mime = "text/plain";
                        }
                        try {
                            ((DataOutputStream)out).writeBytes("HTTP/1.1 200 OK\nContent-Length: " + fo.getSize() + "\n" + "Content-Type: " + mime + "\n\n");
                            FileUtil.copy((InputStream)fis, (OutputStream)out);
                        }
                        catch (SocketException se) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                    if (r != null) {
                        r.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }
    }

    private static class Pair {
        String webContextRoot;
        FileObject siteRoot;

        public Pair(String webContextRoot, FileObject siteRoot) {
            this.webContextRoot = webContextRoot;
            this.siteRoot = siteRoot;
        }
    }
}

