/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.common.spi.ServerURLMappingImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class ServerURLMapping {
    public static final int CONTEXT_PROJECT_SOURCES = 1;
    public static final int CONTEXT_PROJECT_TESTS = 2;

    private ServerURLMapping() {
    }

    public static URL toServer(Project p, FileObject projectFile) {
        return ServerURLMapping.toServer(p, 1, projectFile);
    }

    public static URL toServer(Project p, int projectContext, FileObject projectFile) {
        URL u;
        Parameters.notNull((CharSequence)"project", (Object)p);
        Parameters.notNull((CharSequence)"projectFile", (Object)projectFile);
        ServerURLMappingImplementation impl = (ServerURLMappingImplementation)p.getLookup().lookup(ServerURLMappingImplementation.class);
        if (impl != null && (u = impl.toServer(projectContext, projectFile)) != null) {
            return u;
        }
        try {
            URL url = projectFile.toURL();
            String urlString = url.toURI().toString();
            String urlString2 = urlString.replaceAll("file:/", "file:///");
            if (!urlString.equals(urlString2)) {
                url = new URL(urlString2);
            }
            return url;
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static FileObject fromServer(Project p, URL serverURL) {
        return ServerURLMapping.fromServer(p, 1, serverURL);
    }

    public static FileObject fromServer(Project p, int projectContext, URL serverURL) {
        FileObject fo;
        Parameters.notNull((CharSequence)"project", (Object)p);
        Parameters.notNull((CharSequence)"serverURL", (Object)serverURL);
        serverURL = WebUtils.stringToUrl(WebUtils.urlToString(serverURL, true));
        ServerURLMappingImplementation impl = (ServerURLMappingImplementation)p.getLookup().lookup(ServerURLMappingImplementation.class);
        if (impl != null && (fo = impl.fromServer(projectContext, serverURL)) != null) {
            return fo;
        }
        if ("file".equals(serverURL.getProtocol())) {
            try {
                File f = FileUtil.normalizeFile((File)Utilities.toFile((URI)serverURL.toURI()));
                return FileUtil.toFileObject((File)f);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

