/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.text.BadLocationException;
import org.openide.util.Parameters;

public class Lines {
    private CharSequence text;
    private Integer[] lines;

    public Lines(CharSequence text) {
        Parameters.notNull((CharSequence)"text", (Object)text);
        this.text = text;
        this.initLines();
    }

    private void initLines() {
        ArrayList<Integer> ls = new ArrayList<Integer>();
        int lineStart = 0;
        for (int i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '\r') {
                throw new IllegalArgumentException("The input text cannot contain carriage return char \\r");
            }
            if (c != '\n') continue;
            ls.add(lineStart);
            lineStart = i + 1;
        }
        if (this.text.length() == 0 || this.text.length() - lineStart > 0) {
            ls.add(lineStart);
        }
        this.lines = ls.toArray(new Integer[0]);
    }

    public int getLinesCount() {
        return this.lines.length;
    }

    public int getLineOffset(int lineIndex) {
        if (lineIndex < 0) {
            throw new IllegalArgumentException("Negative line index");
        }
        if (lineIndex > this.lines.length) {
            throw new IllegalArgumentException(String.format("Line index %s > number of lines %s", lineIndex, this.lines.length));
        }
        return this.lines[lineIndex];
    }

    public int getLineIndex(int offset) throws BadLocationException {
        if (offset < 0 || offset > this.text.length()) {
            throw new BadLocationException("The given offset is out of bounds <0, " + this.text.length() + ">", offset);
        }
        int index = Arrays.binarySearch((Object[])this.lines, (Object)offset);
        if (index >= 0) {
            return index;
        }
        return -(index + 2);
    }
}

