/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.api;

import java.awt.Color;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public abstract class FileReferenceCompletion<T>
implements ValueCompletion<T> {
    private static RequestProcessor RP = new RequestProcessor();
    private static final ImageIcon PACKAGE_ICON = ImageUtilities.loadImageIcon((String)"org/openide/loaders/defaultFolder.gif", (boolean)false);

    public abstract T createFileItem(int var1, String var2, Color var3, ImageIcon var4);

    public abstract T createGoUpItem(int var1, Color var2, ImageIcon var3);

    @Override
    public List<T> getItems(FileObject orig, int offset, String valuePart) {
        ArrayList<T> result = new ArrayList<T>();
        String path = "";
        String fileNamePart = valuePart;
        int lastSlash = valuePart.lastIndexOf(47);
        if (lastSlash == 0) {
            path = "/";
            fileNamePart = valuePart.substring(1);
        } else if (lastSlash > 0) {
            path = valuePart.substring(0, lastSlash);
            fileNamePart = lastSlash == valuePart.length() ? "" : valuePart.substring(lastSlash + 1);
        }
        int anchor = offset + lastSlash + 1;
        try {
            FileObject documentBase = ProjectWebRootQuery.getWebRoot(orig);
            String ctxPath = FileReferenceCompletion.resolveRelativeURL("/" + orig.getPath(), path);
            if (path.startsWith("/")) {
                if (documentBase == null) {
                    return Collections.emptyList();
                }
                ctxPath = documentBase.getPath() + path;
            } else {
                ctxPath = ctxPath.substring(1);
            }
            FileSystem fs = orig.getFileSystem();
            FileObject folder = fs.findResource(ctxPath);
            if (folder != null) {
                result.addAll(this.files(anchor, folder, fileNamePart));
                if (!(documentBase != null && folder.equals(documentBase) || path.startsWith("/") || !fileNamePart.isEmpty() && !fileNamePart.equals(".") && !fileNamePart.equals(".."))) {
                    result.add(this.createGoUpItem(anchor, Color.BLUE, PACKAGE_ICON));
                }
            }
        }
        catch (FileStateInvalidException ex) {
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        return result;
    }

    private List<T> files(int offset, FileObject folder, String prefix) {
        ArrayList res = new ArrayList();
        TreeMap<String, T> resFolders = new TreeMap<String, T>();
        TreeMap<String, T> resFiles = new TreeMap<String, T>();
        Enumeration files = folder.getChildren(false);
        while (files.hasMoreElements()) {
            final FileObject file = (FileObject)files.nextElement();
            String fname = file.getNameExt();
            if (!fname.startsWith(prefix) || "cvs".equalsIgnoreCase(fname)) continue;
            if (file.isFolder()) {
                resFolders.put(file.getNameExt(), this.createFileItem(offset, file.getNameExt() + "/", Color.BLUE, PACKAGE_ICON));
                continue;
            }
            T fileItem = this.createFileItem(offset, file.getNameExt(), Color.BLACK, null);
            if (fileItem instanceof PropertyChangeListener) {
                final PropertyChangeListener plistener = (PropertyChangeListener)fileItem;
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ImageIcon icon = new ImageIcon(FileReferenceCompletion.getIcon(file));
                        plistener.propertyChange(new PropertyChangeEvent(this, "iconLoaded", null, icon));
                    }
                });
            } else {
                ImageIcon icon = new ImageIcon(FileReferenceCompletion.getIcon(file));
                fileItem = this.createFileItem(offset, file.getNameExt(), Color.BLACK, icon);
            }
            resFiles.put(file.getNameExt(), fileItem);
        }
        res.addAll(resFolders.values());
        res.addAll(resFiles.values());
        return res;
    }

    private static String resolveRelativeURL(String relativeTo, String url) {
        String result;
        if (url.startsWith("/")) {
            result = "/";
            url = url.substring(1);
        } else {
            if (relativeTo == null || !relativeTo.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int lastSlash = (relativeTo = FileReferenceCompletion.resolveRelativeURL(null, relativeTo)).lastIndexOf(47);
            if (lastSlash == -1) {
                throw new IllegalArgumentException();
            }
            result = relativeTo.substring(0, lastSlash + 1);
        }
        StringTokenizer st = new StringTokenizer(url, "/", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                if (result.endsWith("/")) continue;
                result = result + "/";
                continue;
            }
            if (tok.equals("") || tok.equals(".")) continue;
            if (tok.equals("..")) {
                String withoutSlash = result.substring(0, result.length() - 1);
                int ls = withoutSlash.lastIndexOf("/");
                if (ls == -1) continue;
                result = withoutSlash.substring(0, ls + 1);
                continue;
            }
            result = result + tok;
        }
        return result;
    }

    private static Image getIcon(FileObject fo) {
        try {
            return DataObject.find((FileObject)fo).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException e) {
            Logger.getLogger(FileReferenceCompletion.class.getName()).log(Level.INFO, "Cannot find icon for " + fo.getNameExt(), e);
            return null;
        }
    }
}

