/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class ProfilingPointFactory {
    public static final String AVAILABILITY_PROPERTY = ProfilingPointFactory.class.getName() + "#AVAILABILITY";
    private static final String PROFILING_POINT_STORAGE_EXT = "pp";
    public static final int SCOPE_CODE = 1;
    public static final int SCOPE_GLOBAL = 2;
    public static final Icon SCOPE_CODE_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Code");
    public static final Icon SCOPE_GLOBAL_ICON = Icons.getIcon((String)"ProfilingPointsIcons.Global");
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private ValidityAwarePanel customizer = null;

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isAvailable() {
        return true;
    }

    public abstract String getDescription();

    public String getHint() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract Icon getDisabledIcon();

    public abstract int getScope();

    public abstract String getType();

    public ProfilingPoint create() {
        return this.create(null);
    }

    public abstract ProfilingPoint create(Lookup.Provider var1);

    public abstract boolean supportsCPU();

    public abstract boolean supportsMemory();

    public abstract boolean supportsMonitor();

    public Icon getScopeIcon() {
        switch (this.getScope()) {
            case 1: {
                return SCOPE_CODE_ICON;
            }
            case 2: {
                return SCOPE_GLOBAL_ICON;
            }
        }
        return null;
    }

    protected abstract Class getProfilingPointsClass();

    protected abstract ValidityAwarePanel createCustomizer();

    protected abstract ProfilingPoint loadProfilingPoint(Lookup.Provider var1, Properties var2, int var3);

    protected abstract void storeProfilingPoint(ProfilingPoint var1, int var2, Properties var3);

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.pcs.firePropertyChange(event);
    }

    ValidityAwarePanel getCustomizer() {
        if (this.customizer == null) {
            this.customizer = this.createCustomizer();
        }
        ValidityAwarePanel safeCustomizer = ProfilingPointsManager.getDefault().safeGetCustomizer(this.customizer);
        return safeCustomizer;
    }

    ProfilingPoint[] loadProfilingPoints(Lookup.Provider project, FileObject projectSettingsFolder) throws IOException, InvalidPropertiesFormatException {
        LinkedList<ProfilingPoint> profilingPoints = new LinkedList<ProfilingPoint>();
        Properties properties = new Properties();
        FileObject profilingPointsStorage = this.getProfilingPointsStorage(projectSettingsFolder);
        if (profilingPointsStorage != null) {
            InputStream is = profilingPointsStorage.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            properties.loadFromXML(bis);
            bis.close();
            int index = 0;
            while (properties.getProperty(index + "_" + "p_name") != null) {
                ProfilingPoint profilingPoint = this.loadProfilingPoint(project, properties, index);
                if (profilingPoint != null) {
                    profilingPoints.add(profilingPoint);
                } else {
                    ErrorManager.getDefault().log(65536, "Invalid " + this.getType() + " Profiling Point format at index " + index + " in project " + ProjectUtilities.getDisplayName((Lookup.Provider)project));
                }
                ++index;
            }
        }
        ProfilingPoint[] profilingPointsArr = new ProfilingPoint[profilingPoints.size()];
        profilingPoints.toArray(profilingPointsArr);
        return profilingPointsArr;
    }

    void saveProfilingPoints(Lookup.Provider project) throws IOException {
        this.saveProfilingPoints(ProfilingPointsManager.getDefault().getProfilingPoints(this.getProfilingPointsClass(), project, false).toArray(new ProfilingPoint[0]), project);
    }

    private FileObject getProfilingPointsStorage(FileObject projectSettingsFolder) throws IOException {
        if (projectSettingsFolder == null) {
            return null;
        }
        String profilingPointClassNameFull = this.getProfilingPointsClass().getName();
        String profilingPointClassName = profilingPointClassNameFull.substring(profilingPointClassNameFull.lastIndexOf(46) + 1);
        FileObject profilingPointsStorage = projectSettingsFolder.getFileObject(profilingPointClassName, PROFILING_POINT_STORAGE_EXT);
        return profilingPointsStorage;
    }

    private FileObject createProfilingPointsStorage(Lookup.Provider project) throws IOException {
        FileObject projectSettingsFolder = ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)true);
        String profilingPointClassNameFull = this.getProfilingPointsClass().getName();
        String profilingPointClassName = profilingPointClassNameFull.substring(profilingPointClassNameFull.lastIndexOf(46) + 1);
        FileObject profilingPointsStorage = projectSettingsFolder.createData(profilingPointClassName, PROFILING_POINT_STORAGE_EXT);
        return profilingPointsStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProfilingPointsStorage(Lookup.Provider project) throws IOException {
        FileObject settingsFolder = ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)false);
        FileObject profilingPointsStorage = this.getProfilingPointsStorage(settingsFolder);
        if (profilingPointsStorage != null) {
            FileLock lock = null;
            try {
                lock = profilingPointsStorage.lock();
                profilingPointsStorage.delete(lock);
            }
            catch (Exception e) {
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
    }

    private void saveProfilingPoints(ProfilingPoint[] profilingPoints, Lookup.Provider project) throws IOException {
        if (profilingPoints.length > 0) {
            FileObject settingsFolder = ProjectStorage.getSettingsFolder((Lookup.Provider)project, (boolean)false);
            FileObject profilingPointsStorage = this.getProfilingPointsStorage(settingsFolder);
            if (profilingPointsStorage == null) {
                profilingPointsStorage = this.createProfilingPointsStorage(project);
            }
            if (profilingPointsStorage != null) {
                Properties properties = new Properties();
                for (int i = 0; i < profilingPoints.length; ++i) {
                    this.storeProfilingPoint(profilingPoints[i], i, properties);
                }
                this.storeSettings(profilingPointsStorage, properties);
            }
        } else {
            this.deleteProfilingPointsStorage(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSettings(FileObject storage, Properties properties) throws IOException {
        FileLock lock = null;
        try {
            lock = storage.lock();
            OutputStream os = storage.getOutputStream(lock);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            properties.storeToXML(os, null);
            bos.close();
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }
}

