/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.LoadGeneratorCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ProfilingPointReport;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.util.Lookup;

public class LoadGenProfilingPoint
extends CodeProfilingPoint.Paired
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(LoadGenProfilingPoint.class.getName());
    public static final String PROPERTY_SCRIPTNAME = "p_ScriptName";
    private static final String ANNOTATION_ENABLED = "loadgenProfilingPoint";
    private static final String ANNOTATION_DISABLED = "loadgenProfilingPointD";
    private Annotation endAnnotation;
    private Annotation startAnnotation;
    private final List<Result> results = new ArrayList<Result>();
    private final Object resultsSync = new Object();
    private String scriptFileName;
    private WeakReference<Report> reportReference;

    public LoadGenProfilingPoint(String name, CodeProfilingPoint.Location startLocation, CodeProfilingPoint.Location endLocation, Lookup.Provider project, ProfilingPointFactory factory) {
        super(name, startLocation, endLocation, project, factory);
        this.getChangeSupport().addPropertyChangeListener(this);
    }

    @Override
    public void setEnabled(boolean value) {
        LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        if (lg != null) {
            super.setEnabled(value);
        } else {
            LOGGER.warning("Can not enable the Load Generator profiling point. The appropriate modules are not installed.");
        }
    }

    @Override
    public boolean isEnabled() {
        boolean retValue = super.isEnabled();
        if (retValue) {
            LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
            retValue &= lg != null;
        }
        return retValue;
    }

    public String getScriptFileName() {
        return this.scriptFileName != null ? this.scriptFileName : "";
    }

    public void setSriptFileName(String fileName) {
        this.scriptFileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasResults() {
        Object object = this.resultsSync;
        synchronized (object) {
            return !this.results.isEmpty();
        }
    }

    @Override
    public void hideResults() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Report report = LoadGenProfilingPoint.this.getReport(false);
                if (report != null) {
                    report.close();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Report report = this.getReport(false);
        if (report != null) {
            if (evt.getPropertyName() == "p_name") {
                report.refreshProperties();
            }
            report.refresh();
        }
    }

    @Override
    public void showResults(URL url) {
        Report topComponent = this.getReport(true);
        topComponent.open();
        topComponent.requestActive();
    }

    @Override
    protected CodeProfilingPoint.Annotation getEndAnnotation() {
        if (!this.usesEndLocation()) {
            this.endAnnotation = null;
        } else if (this.endAnnotation == null) {
            this.endAnnotation = new Annotation(false);
        }
        return this.endAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getResultsText() {
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.hasResults()) {
                return this.results.size() == 1 ? Bundle.LoadGenProfilingPoint_OneHitString(Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp())) : Bundle.LoadGenProfilingPoint_NHitsString(this.results.size(), Utils.formatProfilingPointTime(this.results.get(this.results.size() - 1).getTimestamp()));
            }
            return Bundle.LoadGenProfilingPoint_NoResultsString();
        }
    }

    @Override
    protected CodeProfilingPoint.Annotation getStartAnnotation() {
        if (this.startAnnotation == null) {
            this.startAnnotation = new Annotation(true);
        }
        return this.startAnnotation;
    }

    @Override
    protected void updateCustomizer(ValidityAwarePanel c) {
        LoadGeneratorCustomizer customizer = (LoadGeneratorCustomizer)c;
        customizer.setPPName(this.getName());
        customizer.setPPStartLocation(this.getStartLocation());
        customizer.setPPEndLocation(this.getEndLocation());
        customizer.setScriptFile(this.getScriptFileName());
        customizer.setProject(this.getProject());
    }

    @Override
    protected boolean usesEndLocation() {
        return this.getEndLocation() != null;
    }

    @Override
    void setValues(ValidityAwarePanel c) {
        LoadGeneratorCustomizer customizer = (LoadGeneratorCustomizer)c;
        this.setName(customizer.getPPName());
        this.setStartLocation(customizer.getPPStartLocation());
        this.setEndLocation(customizer.getPPEndLocation());
        this.setSriptFileName(customizer.getScriptFile());
        Utils.checkLocation(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hit(final RuntimeProfilingPoint.HitEvent hitEvent, int index) {
        LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
        Object object = this.resultsSync;
        synchronized (object) {
            if (this.usesEndLocation() && index == 1) {
                if (lg != null) {
                    lg.stop(this.getScriptFileName());
                    for (Result result : this.results) {
                        if (result.getEndTimestamp() != -1L || result.getThreadID() != hitEvent.getThreadId()) continue;
                        result.setEndTimestamp(hitEvent.getTimestamp());
                        break;
                    }
                }
            } else if (lg != null) {
                lg.start(this.getScriptFileName(), new LoadGenPlugin.Callback(){
                    private long correlationId;
                    {
                        this.correlationId = hitEvent.getTimestamp();
                    }

                    public void afterStart(LoadGenPlugin.Result result) {
                        if (ProfilingPointsManager.getDefault().belowMaxHits(LoadGenProfilingPoint.this.results.size())) {
                            Result rslt = new Result(hitEvent.getTimestamp(), hitEvent.getThreadId(), result == LoadGenPlugin.Result.SUCCESS);
                            LoadGenProfilingPoint.this.results.add(rslt);
                            this.correlationId = hitEvent.getTimestamp();
                            LoadGenProfilingPoint.this.getChangeSupport().firePropertyChange("p_results", false, true);
                        }
                    }

                    public void afterStop(LoadGenPlugin.Result result) {
                        for (Result rslt : LoadGenProfilingPoint.this.results) {
                            if (rslt.getTimestamp() != this.correlationId) continue;
                            rslt.setEndTimestamp(this.correlationId);
                            rslt.setStopTime();
                            break;
                        }
                        LoadGenProfilingPoint.this.getChangeSupport().firePropertyChange("p_results", false, true);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void reset() {
        Object object = this.resultsSync;
        synchronized (object) {
            boolean change = this.results.size() > 0;
            this.results.clear();
            if (change) {
                this.getChangeSupport().firePropertyChange("p_results", false, true);
            }
        }
    }

    private Report getReport(boolean create) {
        Report report;
        Report report2 = report = this.reportReference == null ? null : (Report)((Object)this.reportReference.get());
        if (report == null && create) {
            report = new Report();
            this.reportReference = new WeakReference<Report>(report);
        }
        return report;
    }

    private class Report
    extends ProfilingPointReport {
        private static final String START_LOCATION_URLMASK = "file:/1";
        private static final String END_LOCATION_URLMASK = "file:/2";
        private HTMLTextArea dataArea;
        private HTMLTextArea headerArea;

        public Report() {
            this.initDefaults();
            this.initComponents();
            this.refresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void refresh() {
            StringBuilder headerAreaTextBuilder = new StringBuilder();
            headerAreaTextBuilder.append(this.getHeaderName());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderType());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderEnabled());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderProject());
            headerAreaTextBuilder.append("<br>");
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderStartLocation());
            headerAreaTextBuilder.append("<br>");
            if (LoadGenProfilingPoint.this.usesEndLocation()) {
                headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                headerAreaTextBuilder.append(this.getHeaderEndLocation());
                headerAreaTextBuilder.append("<br>");
            }
            headerAreaTextBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            headerAreaTextBuilder.append(this.getHeaderHitsCount());
            this.headerArea.setText(headerAreaTextBuilder.toString());
            StringBuilder dataAreaTextBuilder = new StringBuilder();
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                if (LoadGenProfilingPoint.this.results.isEmpty()) {
                    dataAreaTextBuilder.append(ProfilingPointReport.getNoDataHint(LoadGenProfilingPoint.this));
                } else {
                    if (LoadGenProfilingPoint.this.results.size() > 1) {
                        Collections.sort(LoadGenProfilingPoint.this.results, new Comparator<Result>(){

                            @Override
                            public int compare(Result o1, Result o2) {
                                return Long.valueOf(o1.getTimestamp()).compareTo(o2.getTimestamp());
                            }
                        });
                    }
                    for (int i = 0; i < LoadGenProfilingPoint.this.results.size(); ++i) {
                        dataAreaTextBuilder.append("&nbsp;&nbsp;");
                        dataAreaTextBuilder.append(this.getDataResultItem(i));
                        dataAreaTextBuilder.append("<br>");
                    }
                    ProfilingPointsManager m = ProfilingPointsManager.getDefault();
                    if (!m.belowMaxHits(LoadGenProfilingPoint.this.results.size())) {
                        dataAreaTextBuilder.append(m.getTruncatedResultsText());
                    }
                }
            }
            this.dataArea.setText(dataAreaTextBuilder.toString());
        }

        void refreshProperties() {
            this.setName(LoadGenProfilingPoint.this.getName());
            this.setIcon(((ImageIcon)LoadGenProfilingPoint.this.getFactory().getIcon()).getImage());
            this.getAccessibleContext().setAccessibleDescription(Bundle.LoadGenProfilingPoint_ReportAccessDescr(this.getName()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataResultItem(int index) {
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                Result result = (Result)LoadGenProfilingPoint.this.results.get(index);
                String hitTime = Utils.formatProfilingPointTimeHiRes(result.getTimestamp());
                if (result.isSuccess()) {
                    return Bundle.LoadGenProfilingPoint_HitSuccessString(index + 1, hitTime);
                }
                return Bundle.LoadGenProfilingPoint_HitFailedString(index + 1, hitTime);
            }
        }

        private String getHeaderEnabled() {
            return Bundle.LoadGenProfilingPoint_HeaderEnabledString(LoadGenProfilingPoint.this.isEnabled());
        }

        private String getHeaderEndLocation() {
            CodeProfilingPoint.Location location = LoadGenProfilingPoint.this.getEndLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/2'>";
            return Bundle.LoadGenProfilingPoint_HeaderEndLocationString(locationUrl + shortFileName, lineNumber) + "</a>";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHeaderHitsCount() {
            Object object = LoadGenProfilingPoint.this.resultsSync;
            synchronized (object) {
                return Bundle.LoadGenProfilingPoint_HeaderHitsString(LoadGenProfilingPoint.this.results.size());
            }
        }

        private String getHeaderName() {
            return "<h2><b>" + LoadGenProfilingPoint.this.getName() + "</b></h2>";
        }

        private String getHeaderProject() {
            return Bundle.LoadGenProfilingPoint_HeaderProjectString(ProjectUtilities.getDisplayName((Lookup.Provider)LoadGenProfilingPoint.this.getProject()));
        }

        private String getHeaderStartLocation() {
            CodeProfilingPoint.Location location = LoadGenProfilingPoint.this.getStartLocation();
            File file = new File(location.getFile());
            String shortFileName = file.getName();
            int lineNumber = location.getLine();
            String locationUrl = "<a href='file:/1'>";
            return LoadGenProfilingPoint.this.usesEndLocation() ? Bundle.LoadGenProfilingPoint_HeaderStartLocationString(locationUrl + shortFileName, lineNumber) + "</a>" : Bundle.LoadGenProfilingPoint_HeaderLocationString(locationUrl + shortFileName, lineNumber) + "</a>";
        }

        private String getHeaderType() {
            return Bundle.LoadGenProfilingPoint_HeaderTypeString(LoadGenProfilingPoint.this.getFactory().getType());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel contentsPanel = new JPanel(new BorderLayout());
            contentsPanel.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.setOpaque(true);
            contentsPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 15, 15, UIUtils.getProfilerResultsBackground()));
            this.headerArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    String urlString = url.toString();
                    if (Report.START_LOCATION_URLMASK.equals(urlString)) {
                        Utils.openLocation(LoadGenProfilingPoint.this.getStartLocation());
                    } else if (LoadGenProfilingPoint.this.usesEndLocation()) {
                        Utils.openLocation(LoadGenProfilingPoint.this.getEndLocation());
                    }
                }
            };
            JScrollPane headerAreaScrollPane = new JScrollPane((Component)this.headerArea, 20, 30);
            headerAreaScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 15, 0, UIUtils.getProfilerResultsBackground()));
            headerAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            contentsPanel.add((Component)headerAreaScrollPane, "North");
            this.dataArea = new HTMLTextArea();
            JScrollPane dataAreaScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
            TitledBorder tb = new TitledBorder(Bundle.LoadGenProfilingPoint_DataString());
            tb.setTitleFont(Utils.getTitledBorderFont(tb).deriveFont(1));
            tb.setTitleColor(UIManager.getColor("Label.foreground"));
            dataAreaScrollPane.setBorder(tb);
            dataAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
            dataAreaScrollPane.setBackground(UIUtils.getProfilerResultsBackground());
            contentsPanel.add((Component)dataAreaScrollPane, "Center");
            this.add(contentsPanel, "Center");
        }

        private void initDefaults() {
            this.refreshProperties();
            this.setFocusable(true);
        }
    }

    private static class Result {
        private final int threadId;
        private final long timestamp;
        private boolean success = false;
        private long endTimestamp = -1L;
        private long startTime;
        private long stopTime;

        public Result(long timestamp, int threadId, boolean success) {
            this.timestamp = timestamp;
            this.threadId = threadId;
            this.success = success;
            this.startTime = System.currentTimeMillis();
            this.stopTime = 0L;
        }

        public long getDuration() {
            return this.stopTime > this.startTime ? this.stopTime - this.startTime : -1L;
        }

        public void setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public void setStopTime() {
            this.stopTime = System.currentTimeMillis();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public int getThreadID() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    private class Annotation
    extends CodeProfilingPoint.Annotation {
        private boolean isStartAnnotation;

        public Annotation(boolean isStartAnnotation) {
            this.isStartAnnotation = isStartAnnotation;
        }

        public String getAnnotationType() {
            return LoadGenProfilingPoint.this.isEnabled() ? LoadGenProfilingPoint.ANNOTATION_ENABLED : LoadGenProfilingPoint.ANNOTATION_DISABLED;
        }

        public String getShortDescription() {
            if (!LoadGenProfilingPoint.this.usesEndLocation()) {
                return LoadGenProfilingPoint.this.getName();
            }
            return this.isStartAnnotation ? Bundle.LoadGenProfilingPoint_AnnotationStartString(LoadGenProfilingPoint.this.getName()) : Bundle.LoadGenProfilingPoint_AnnotationEndString(LoadGenProfilingPoint.this.getName());
        }

        @Override
        public CodeProfilingPoint profilingPoint() {
            return LoadGenProfilingPoint.this;
        }
    }
}

