/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class UseNbBundleMessages {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ErrorDescription> run(HintContext context) {
        FileObject bundleProperties;
        String key;
        int[] span;
        MethodInvocationTree mit;
        CompilationInfo compilationInfo = context.getInfo();
        TreePath treePath = context.getPath();
        Tree tree = treePath.getLeaf();
        FileObject src = compilationInfo.getFileObject();
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            mit = (MethodInvocationTree)tree;
            ExpressionTree methodSelect = mit.getMethodSelect();
            if (methodSelect.getKind() != Tree.Kind.MEMBER_SELECT) {
                return null;
            }
            MemberSelectTree mst = (MemberSelectTree)methodSelect;
            if (!mst.getIdentifier().contentEquals("getMessage")) {
                return null;
            }
            TypeMirror invoker = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, mst.getExpression()));
            if (!String.valueOf(invoker).equals("org.openide.util.NbBundle")) {
                return null;
            }
            FileObject file = compilationInfo.getFileObject();
            if (file != null && file.getNameExt().equals("Bundle.java")) {
                return null;
            }
            span = compilationInfo.getTreeUtilities().findNameSpan(mst);
            if (span == null) {
                return null;
            }
            List<? extends ExpressionTree> args = mit.getArguments();
            if (args.size() < 2) {
                return null;
            }
            if (args.get(0).getKind() != Tree.Kind.MEMBER_SELECT) {
                return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_only_class_const(), span, compilationInfo);
            }
            MemberSelectTree thisClassMST = (MemberSelectTree)args.get(0);
            if (!thisClassMST.getIdentifier().contentEquals("class")) {
                return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_only_class_const(), span, compilationInfo);
            }
            if (thisClassMST.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_only_class_const(), span, compilationInfo);
            }
            if (!((IdentifierTree)thisClassMST.getExpression()).getName().contentEquals(src.getName())) {
                return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_wrong_class_name(src.getName()), span, compilationInfo);
            }
            if (args.get(1).getKind() != Tree.Kind.STRING_LITERAL) {
                return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_only_string_const(), span, compilationInfo);
            }
            key = ((LiteralTree)args.get(1)).getValue().toString();
        } else {
            if (treePath.getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
                return null;
            }
            AssignmentTree at = (AssignmentTree)tree;
            if (at.getExpression().getKind() != Tree.Kind.STRING_LITERAL) {
                return null;
            }
            String literal = ((LiteralTree)at.getExpression()).getValue().toString();
            if (!literal.startsWith("#")) {
                return null;
            }
            key = literal.substring(1);
            SourcePositions sp = compilationInfo.getTrees().getSourcePositions();
            span = new int[]{(int)sp.getStartPosition(compilationInfo.getCompilationUnit(), tree), (int)sp.getEndPosition(compilationInfo.getCompilationUnit(), tree)};
            mit = null;
        }
        if (compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE).findResource("org/openide/util/NbBundle$Messages.class") == null) {
            return null;
        }
        boolean isAlreadyRegistered = UseNbBundleMessages.isAlreadyRegistered(treePath, key);
        if (isAlreadyRegistered) {
            if (mit == null) {
                return null;
            }
            bundleProperties = null;
        } else {
            String bundleResource = compilationInfo.getCompilationUnit().getPackageName().toString().replace('.', '/') + "/Bundle.properties";
            bundleProperties = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findResource(bundleResource);
            if (bundleProperties == null) {
                return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_no_such_bundle(bundleResource), span, compilationInfo);
            }
            EditableProperties ep = new EditableProperties(true);
            try {
                if (DataObject.find((FileObject)bundleProperties).isModified()) {
                    return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_save_bundle(), span, compilationInfo);
                }
                InputStream is = bundleProperties.getInputStream();
                try {
                    ep.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
                return null;
            }
            if (!ep.containsKey((Object)key)) {
                return UseNbBundleMessages.warning(Bundle.UseNbBundleMessages_no_such_key(key), span, compilationInfo);
            }
        }
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)Bundle.UseNbBundleMessages_error_text(), Collections.singletonList(new UseMessagesFix(compilationInfo, treePath, isAlreadyRegistered, key, bundleProperties).toEditorFix()), (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]));
    }

    private static List<ErrorDescription> warning(String text, int[] span, CompilationInfo compilationInfo) {
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.WARNING, (String)text, Collections.emptyList(), (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]));
    }

    private static String toIdentifier(String key) {
        if (Utilities.isJavaIdentifier((String)key)) {
            return key;
        }
        String i = key.replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_");
        if (Utilities.isJavaIdentifier((String)i)) {
            return i;
        }
        return "_" + i;
    }

    private static boolean isAlreadyRegistered(TreePath treePath, String key) {
        TreePath parentPath;
        ModifiersTree modifiers;
        Tree tree = treePath.getLeaf();
        switch (tree.getKind()) {
            case METHOD: {
                modifiers = ((MethodTree)tree).getModifiers();
                break;
            }
            case VARIABLE: {
                modifiers = ((VariableTree)tree).getModifiers();
                break;
            }
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                modifiers = ((ClassTree)tree).getModifiers();
                break;
            }
            default: {
                modifiers = null;
            }
        }
        if (modifiers != null) {
            for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
                AssignmentTree assign;
                List<? extends ExpressionTree> args;
                Tree annotationType = annotationTree.getAnnotationType();
                if (!annotationType.toString().matches("((org[.]openide[.]util[.])?NbBundle[.])?Messages") || (args = annotationTree.getArguments()).size() != 1 || !(assign = (AssignmentTree)args.get(0)).getVariable().toString().equals("value")) continue;
                ExpressionTree arg = assign.getExpression();
                if (arg.getKind() == Tree.Kind.STRING_LITERAL) {
                    if (!UseNbBundleMessages.isRegistered(key, arg)) continue;
                    return true;
                }
                if (arg.getKind() != Tree.Kind.NEW_ARRAY) continue;
                for (ExpressionTree expressionTree : ((NewArrayTree)arg).getInitializers()) {
                    if (!UseNbBundleMessages.isRegistered(key, expressionTree)) continue;
                    return true;
                }
            }
        }
        if ((parentPath = treePath.getParentPath()) == null) {
            return false;
        }
        return UseNbBundleMessages.isAlreadyRegistered(parentPath, key);
    }

    private static boolean isRegistered(String key, ExpressionTree expr) {
        return expr.getKind() == Tree.Kind.STRING_LITERAL && ((LiteralTree)expr).getValue().toString().startsWith(key + "=");
    }

    private UseNbBundleMessages() {
    }

    private static class UseMessagesFix
    extends JavaFix {
        private final boolean isAlreadyRegistered;
        private final String key;
        private final FileObject bundleProperties;

        public UseMessagesFix(CompilationInfo compilationInfo, TreePath treePath, boolean isAlreadyRegistered, String key, FileObject bundleProperties) {
            super(compilationInfo, treePath);
            this.isAlreadyRegistered = isAlreadyRegistered;
            this.key = key;
            this.bundleProperties = bundleProperties;
        }

        protected String getText() {
            return Bundle.UseNbBundleMessages_displayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath treePath = ctx.getPath();
            TreeMaker make = wc.getTreeMaker();
            if (treePath.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
                void var10_16;
                List<? extends ExpressionTree> args;
                MethodInvocationTree mit = (MethodInvocationTree)treePath.getLeaf();
                CompilationUnitTree cut = wc.getCompilationUnit();
                boolean imported = false;
                String importBundleStar = cut.getPackageName() + ".Bundle.*";
                for (ImportTree importTree : cut.getImports()) {
                    if (!importTree.isStatic() || !importTree.getQualifiedIdentifier().toString().equals(importBundleStar)) continue;
                    imported = true;
                    break;
                }
                if (!imported) {
                    wc.rewrite((Tree)cut, (Tree)make.addCompUnitImport(cut, make.Import((Tree)make.Identifier((CharSequence)importBundleStar), true)));
                }
                if ((args = mit.getArguments()).size() == 3 && args.get(2).getKind() == Tree.Kind.NEW_ARRAY) {
                    List<? extends ExpressionTree> list = ((NewArrayTree)args.get(2)).getInitializers();
                } else {
                    List<? extends ExpressionTree> list = args.subList(2, args.size());
                }
                wc.rewrite((Tree)mit, (Tree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)UseNbBundleMessages.toIdentifier(this.key)), (List)var10_16));
            }
            if (!this.isAlreadyRegistered) {
                Tree nueModifiers;
                Tree modifiers;
                void var10_18;
                EditableProperties ep = new EditableProperties(true);
                InputStream is = ctx.getResourceContent(this.bundleProperties);
                try {
                    ep.load(is);
                }
                finally {
                    is.close();
                }
                ArrayList<LiteralTree> lines = new ArrayList<LiteralTree>();
                String[] arr$ = ep.getComment(this.key);
                int len$ = arr$.length;
                boolean bl = false;
                while (var10_18 < len$) {
                    String comment = arr$[var10_18];
                    lines.add(make.Literal((Object)comment));
                    ++var10_18;
                }
                lines.add(make.Literal((Object)(this.key + '=' + (String)ep.remove((Object)this.key))));
                TypeElement nbBundleMessages = wc.getElements().getTypeElement("org.openide.util.NbBundle.Messages");
                if (nbBundleMessages == null) {
                    throw new IllegalArgumentException("cannot resolve org.openide.util.NbBundle.Messages");
                }
                GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)wc);
                Tree tree = UseMessagesFix.findEnclosingElement(wc, treePath);
                ExpressionTree[] linesA = lines.toArray(new ExpressionTree[lines.size()]);
                switch (tree.getKind()) {
                    case METHOD: {
                        modifiers = wc.resolveRewriteTarget((Tree)((MethodTree)tree).getModifiers());
                        nueModifiers = gu.appendToAnnotationValue((ModifiersTree)modifiers, nbBundleMessages, "value", linesA);
                        break;
                    }
                    case VARIABLE: {
                        modifiers = wc.resolveRewriteTarget((Tree)((VariableTree)tree).getModifiers());
                        nueModifiers = gu.appendToAnnotationValue((ModifiersTree)modifiers, nbBundleMessages, "value", linesA);
                        break;
                    }
                    case COMPILATION_UNIT: {
                        modifiers = wc.resolveRewriteTarget(tree);
                        nueModifiers = gu.appendToAnnotationValue((CompilationUnitTree)modifiers, nbBundleMessages, "value", linesA);
                        break;
                    }
                    default: {
                        modifiers = wc.resolveRewriteTarget((Tree)((ClassTree)tree).getModifiers());
                        nueModifiers = gu.appendToAnnotationValue((ModifiersTree)modifiers, nbBundleMessages, "value", linesA);
                    }
                }
                wc.rewrite(modifiers, nueModifiers);
                OutputStream os = ctx.getResourceOutput(this.bundleProperties);
                try {
                    ep.store(os);
                }
                finally {
                    os.close();
                }
            }
        }

        private static Tree findEnclosingElement(WorkingCopy wc, TreePath treePath) {
            Tree leaf = treePath.getLeaf();
            Tree.Kind kind = leaf.getKind();
            switch (kind) {
                case METHOD: 
                case VARIABLE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    TypeElement type;
                    Element e = wc.getTrees().getElement(treePath);
                    if (e == null || wc.getElementUtilities().isLocal(e)) break;
                    TypeElement typeElement = type = TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind) ? (TypeElement)e : wc.getElementUtilities().enclosingTypeElement(e);
                    if (type != null && wc.getElementUtilities().isLocal((Element)type)) break;
                    return leaf;
                }
                case COMPILATION_UNIT: {
                    return leaf;
                }
            }
            TreePath parentPath = treePath.getParentPath();
            if (parentPath == null) {
                return null;
            }
            return UseMessagesFix.findEnclosingElement(wc, parentPath);
        }
    }
}

