/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.CheckReturnValue;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public interface Hinter {
    public void process(Context var1) throws Exception;

    public static class Context {
        private static final Logger LOG = Logger.getLogger(Hinter.class.getName());
        private final Document doc;
        private final LayerHandle layer;
        private final FileObject file;
        private final RunnableFuture<Map<String, Integer>> lines;
        private final List<? super ErrorDescription> errors;

        Context(Document doc, LayerHandle layer, FileObject file, RunnableFuture<Map<String, Integer>> lines, List<? super ErrorDescription> errors) {
            this.doc = doc;
            this.layer = layer;
            this.file = file;
            this.lines = lines;
            this.errors = errors;
        }

        public FileObject file() {
            return this.file;
        }

        public String standardAnnotationDescription() {
            return Bundle.Hinter_description();
        }

        public String standardAnnotationFixDescription() {
            return Bundle.Hinter_fix_description();
        }

        public void addHint(Severity severity, String description, Fix ... fixes) {
            Integer line = null;
            try {
                this.lines.run();
                line = (Integer)((Map)this.lines.get()).get(this.file.getPath());
            }
            catch (Exception x) {
                LOG.log(Level.INFO, null, x);
            }
            if (line != null) {
                this.errors.add((ErrorDescription)ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)description, Arrays.asList(fixes), (Document)this.doc, (int)line));
            } else {
                LOG.log(Level.WARNING, "no line found for {0}", this.file);
            }
        }

        public void addStandardAnnotationHint(final Callable<Void> fix) {
            this.addHint(Severity.WARNING, this.standardAnnotationDescription(), new Fix(){

                public String getText() {
                    return Context.this.standardAnnotationFixDescription();
                }

                public ChangeInfo implement() throws Exception {
                    fix.call();
                    return null;
                }
            });
        }

        public boolean canAccess(String api) {
            ClassPath cp = ClassPath.getClassPath((FileObject)this.layer.getLayerFile(), (String)"classpath/compile");
            if (cp == null) {
                return false;
            }
            return cp.findResource(api.replace('.', '/') + ".class") != null;
        }

        @CheckForNull
        private FileObject findDeclaringSource(@NullAllowed Object instanceAttribute) {
            if (!(instanceAttribute instanceof String)) {
                return null;
            }
            ClassPath src = ClassPath.getClassPath((FileObject)this.layer.getLayerFile(), (String)"classpath/source");
            if (src == null) {
                return null;
            }
            String attr = (String)instanceAttribute;
            if (attr.startsWith("new:")) {
                return src.findResource(attr.substring(4).replaceFirst("[$][^.]+$", "").replace('.', '/') + ".java");
            }
            if (attr.startsWith("method:")) {
                return src.findResource(attr.substring(7, attr.lastIndexOf(46)).replaceFirst("[$][^.]+$", "").replace('.', '/') + ".java");
            }
            return null;
        }

        @CheckForNull
        private Element findDeclaration(WorkingCopy wc, @NullAllowed Object instanceAttribute) {
            if (!(instanceAttribute instanceof String)) {
                return null;
            }
            String attr = (String)instanceAttribute;
            if (attr.startsWith("new:")) {
                return wc.getElements().getTypeElement(attr.substring(4).replace('$', '.'));
            }
            if (attr.startsWith("method:")) {
                int dot = attr.lastIndexOf(46);
                TypeElement type = wc.getElements().getTypeElement(attr.substring(7, dot).replace('$', '.'));
                if (type != null) {
                    String meth = attr.substring(dot + 1);
                    for (Element element : type.getEnclosedElements()) {
                        if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().contentEquals(meth) || !((ExecutableElement)element).getParameters().isEmpty()) continue;
                        return element;
                    }
                }
            }
            return null;
        }

        public void saveLayer() throws IOException {
            this.layer.save();
        }

        public void findAndModifyDeclaration(final @NullAllowed Object instanceAttribute, final ModifyDeclarationTask task) throws IOException {
            FileObject java = this.findDeclaringSource(instanceAttribute);
            if (java == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.Hinter_missing_instance_class(instanceAttribute), 2));
                return;
            }
            JavaSource js = JavaSource.forFileObject((FileObject)java);
            if (js == null) {
                throw new IOException("No source info for " + java);
            }
            js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    if (DataObject.find((FileObject)Context.this.layer.getLayerFile()).isModified()) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.Hinter_do_not_edit_layer(), 2));
                        return;
                    }
                    Element decl = Context.this.findDeclaration(wc, instanceAttribute);
                    if (decl == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.Hinter_missing_instance_class(instanceAttribute), 2));
                        return;
                    }
                    ModifiersTree mods = decl.getKind() == ElementKind.CLASS ? wc.getTrees().getTree((TypeElement)decl).getModifiers() : wc.getTrees().getTree((ExecutableElement)decl).getModifiers();
                    task.run(wc, decl, mods);
                    Context.this.saveLayer();
                }
            }).commit();
            SaveCookie sc = (SaveCookie)DataObject.find((FileObject)java).getLookup().lookup(SaveCookie.class);
            if (sc != null) {
                sc.save();
            }
        }

        @CheckForNull
        public Object instanceAttribute(FileObject file) {
            if (!file.isData() || !file.hasExt("instance")) {
                return null;
            }
            Object instanceCreate = file.getAttribute("literal:instanceCreate");
            if (instanceCreate != null) {
                return instanceCreate;
            }
            Object clazz = file.getAttribute("instanceClass");
            if (clazz != null) {
                return "new:" + clazz;
            }
            return "new:" + file.getName().replace('-', '.');
        }

        @CheckForNull
        public String bundlevalue(@NullAllowed Object attribute, Element declaration) {
            if (attribute instanceof String) {
                String val = (String)attribute;
                if (val.startsWith("bundle:")) {
                    String expected;
                    PackageElement pkg = this.findPackage(declaration);
                    if (pkg != null && val.startsWith(expected = "bundle:" + pkg.getQualifiedName() + ".Bundle#")) {
                        return val.substring(expected.length() - 1);
                    }
                    return val.substring(7);
                }
                return val;
            }
            return null;
        }

        private PackageElement findPackage(Element e) {
            if (e.getKind() == ElementKind.PACKAGE) {
                return (PackageElement)e;
            }
            Element parent = e.getEnclosingElement();
            if (parent == null) {
                return null;
            }
            return this.findPackage(parent);
        }

        @CheckReturnValue
        public ModifiersTree addAnnotation(WorkingCopy wc, ModifiersTree modifiers, String type, @NullAllowed String pluralType, Map<String, Object> parameters) {
            TreeMaker make = wc.getTreeMaker();
            TypeElement ann = wc.getElements().getTypeElement(type);
            if (ann == null) {
                throw new IllegalArgumentException("Could not find " + type + " in classpath");
            }
            ArrayList<AssignmentTree> arguments = new ArrayList<AssignmentTree>();
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                ExpressionTree valueTree;
                Object value = entry.getValue();
                if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    if (array.length == 1) {
                        valueTree = make.Literal(array[0]);
                    } else {
                        ArrayList<LiteralTree> elements = new ArrayList<LiteralTree>();
                        for (Object o : array) {
                            elements.add(make.Literal(o));
                        }
                        valueTree = make.NewArray(null, Collections.emptyList(), elements);
                    }
                } else {
                    if (value == null) continue;
                    valueTree = make.Literal(value);
                }
                arguments.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)entry.getKey()), valueTree));
            }
            AnnotationTree toAdd = make.Annotation((Tree)make.QualIdent((Element)ann), arguments);
            if (pluralType != null) {
                List<? extends AnnotationTree> existingAnns = modifiers.getAnnotations();
                for (int i = 0; i < existingAnns.size(); ++i) {
                    NewArrayTree arr;
                    AnnotationTree existingAnn = existingAnns.get(i);
                    String existingType = existingAnn.getAnnotationType().toString();
                    if (existingType.equals(type) || existingType.equals(type.replaceFirst(".+[.]", ""))) {
                        return make.insertModifiersAnnotation(make.removeModifiersAnnotation(modifiers, i), i, make.Annotation((Tree)make.QualIdent(pluralType), Collections.singletonList(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"value"), (ExpressionTree)make.NewArray(null, Collections.emptyList(), Arrays.asList(existingAnn, toAdd))))));
                    }
                    if (!existingType.equals(pluralType) && !existingType.equals(pluralType.replaceFirst(".+[.]", ""))) continue;
                    List<? extends ExpressionTree> args = existingAnn.getArguments();
                    if (args.size() != 1) {
                        throw new IllegalArgumentException("expecting just one arg for @" + pluralType);
                    }
                    AssignmentTree assign = (AssignmentTree)args.get(0);
                    if (!assign.getVariable().toString().equals("value")) {
                        throw new IllegalArgumentException("expected value=... for @" + pluralType);
                    }
                    ExpressionTree arg = assign.getExpression();
                    if (arg.getKind() == Tree.Kind.STRING_LITERAL) {
                        arr = make.NewArray(null, Collections.emptyList(), Collections.singletonList(arg));
                    } else if (arg.getKind() == Tree.Kind.NEW_ARRAY) {
                        arr = (NewArrayTree)arg;
                    } else {
                        throw new IllegalArgumentException("unknown arg kind " + (Object)((Object)arg.getKind()) + ": " + arg);
                    }
                    return make.insertModifiersAnnotation(make.removeModifiersAnnotation(modifiers, i), i, make.Annotation(existingAnn.getAnnotationType(), Collections.singletonList(make.Assignment(assign.getVariable(), (ExpressionTree)make.addNewArrayInitializer(arr, (ExpressionTree)toAdd)))));
                }
            }
            return make.addModifiersAnnotation(modifiers, toAdd);
        }

        public void delete(FileObject entry) throws IOException {
            entry.delete();
            FileObject parent = entry.getParent();
            if (parent.getChildren().length == 0 && !parent.getAttributes().hasMoreElements() && !parent.isRoot()) {
                this.delete(parent);
            }
        }

        static interface ModifyDeclarationTask {
            public void run(WorkingCopy var1, Element var2, ModifiersTree var3) throws Exception;
        }
    }
}

