/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.imports;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;

public class UnusedImports {
    private static final Object KEY_CACHE = new Object();

    public static Collection<TreePath> process(CompilationInfo info, AtomicBoolean cancel) {
        Collection result = (Collection)info.getCachedValue(KEY_CACHE);
        if (result != null) {
            return result;
        }
        DetectorVisitor v = new DetectorVisitor(info, cancel);
        CompilationUnitTree cu = info.getCompilationUnit();
        v.scan(cu, null);
        if (cancel.get()) {
            return null;
        }
        List<TreePath> allUnusedImports = new ArrayList();
        for (TreePath tree : v.import2Highlight.values()) {
            if (cancel.get()) {
                return null;
            }
            allUnusedImports.add(tree);
        }
        allUnusedImports = Collections.unmodifiableList(allUnusedImports);
        info.putCachedValue(KEY_CACHE, allUnusedImports, CompilationInfo.CacheClearPolicy.ON_CHANGE);
        return allUnusedImports;
    }

    private static class DetectorVisitor
    extends CancellableTreePathScanner<Void, Void> {
        private final CompilationInfo info;
        private final Map<Element, ImportTree> element2Import = new HashMap<Element, ImportTree>();
        private final Set<Element> importedBySingleImport = new HashSet<Element>();
        private final Map<String, ImportTree> method2Import = new HashMap<String, ImportTree>();
        private final Map<String, Collection<ImportTree>> simpleName2UnresolvableImports = new HashMap<String, Collection<ImportTree>>();
        private final Set<ImportTree> unresolvablePackageImports = new HashSet<ImportTree>();
        private final Map<ImportTree, TreePath> import2Highlight = new HashMap<ImportTree, TreePath>();

        private DetectorVisitor(CompilationInfo info, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
        }

        private void handleJavadoc(TreePath classMember) {
            if (classMember == null) {
                return;
            }
            for (TypeElement el : JavadocImports.computeReferencedElements(this.info, classMember)) {
                this.typeUsed(el, null, false);
            }
        }

        public Void visitClass(ClassTree node, Void p) {
            this.handleJavadoc(this.getCurrentPath());
            return (Void)super.visitClass(node, (Object)p);
        }

        public Void visitMethod(MethodTree node, Void p) {
            this.handleJavadoc(this.getCurrentPath());
            return (Void)super.visitMethod(node, (Object)p);
        }

        public Void visitVariable(VariableTree node, Void p) {
            Element e = this.info.getTrees().getElement(this.getCurrentPath());
            if (e != null && e.getKind().isField()) {
                this.handleJavadoc(this.getCurrentPath());
            }
            return (Void)super.visitVariable(node, (Object)p);
        }

        public Void visitCompilationUnit(CompilationUnitTree tree, Void d) {
            this.scan(tree.getImports(), d);
            this.scan(tree.getPackageAnnotations(), d);
            this.scan(tree.getTypeDecls(), d);
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, Void d) {
            if (this.info.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                return null;
            }
            this.typeUsed(this.info.getTrees().getElement(this.getCurrentPath()), this.getCurrentPath(), this.getCurrentPath().getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION);
            return (Void)super.visitIdentifier(tree, null);
        }

        private boolean isStar(ImportTree tree) {
            Tree qualIdent = tree.getQualifiedIdentifier();
            if (qualIdent == null || qualIdent.getKind() == Tree.Kind.IDENTIFIER) {
                return false;
            }
            return ((MemberSelectTree)qualIdent).getIdentifier().contentEquals("*");
        }

        private boolean parseErrorInImport(ImportTree imp) {
            if (this.isStar(imp)) {
                return false;
            }
            final StringBuilder fqn = new StringBuilder();
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    super.visitMemberSelect(node, p);
                    fqn.append('.');
                    fqn.append(node.getIdentifier());
                    return null;
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    fqn.append(node.getName());
                    return null;
                }
            }.scan(imp.getQualifiedIdentifier(), null);
            return !SourceVersion.isName(fqn);
        }

        public Void visitImport(ImportTree tree, Void d) {
            if (this.parseErrorInImport(tree)) {
                return (Void)super.visitImport(tree, null);
            }
            if (!tree.isStatic()) {
                if (this.isStar(tree)) {
                    MemberSelectTree qualIdent = (MemberSelectTree)tree.getQualifiedIdentifier();
                    Element decl = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), qualIdent), qualIdent.getExpression()));
                    if (decl != null && decl.getKind() == ElementKind.PACKAGE) {
                        if (!ElementFilter.typesIn(decl.getEnclosedElements()).isEmpty()) {
                            for (TypeElement te : ElementFilter.typesIn(decl.getEnclosedElements())) {
                                if (this.importedBySingleImport.contains(te)) continue;
                                this.element2Import.put(te, tree);
                            }
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        } else {
                            this.unresolvablePackageImports.add(tree);
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        }
                    }
                } else {
                    Element decl = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), tree.getQualifiedIdentifier()));
                    if (decl != null) {
                        if (decl.asType().getKind() != TypeKind.ERROR) {
                            this.element2Import.put(decl, tree);
                            this.importedBySingleImport.add(decl);
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        } else if (tree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT) {
                            this.addUnresolvableImport(((MemberSelectTree)tree.getQualifiedIdentifier()).getIdentifier(), tree);
                            this.import2Highlight.put(tree, this.getCurrentPath());
                        }
                    }
                }
            } else if (tree.getQualifiedIdentifier() != null && tree.getQualifiedIdentifier().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree qualIdent = (MemberSelectTree)tree.getQualifiedIdentifier();
                Element decl = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), qualIdent), qualIdent.getExpression()));
                if (decl != null && (decl.getKind().isClass() || decl.getKind().isInterface())) {
                    if (decl.asType().getKind() != TypeKind.ERROR) {
                        Name simpleName = this.isStar(tree) ? null : qualIdent.getIdentifier();
                        boolean assign = false;
                        for (Element element : this.info.getElements().getAllMembers((TypeElement)decl)) {
                            if (!element.getModifiers().contains((Object)Modifier.STATIC) || simpleName != null && !((Object)element.getSimpleName()).equals(simpleName)) continue;
                            if (element.getKind() == ElementKind.METHOD) {
                                this.method2Import.put(element.getSimpleName().toString() + ((Object)element.asType()).toString(), tree);
                                assign = true;
                                continue;
                            }
                            if (element.getKind().isField()) {
                                this.element2Import.put(element, tree);
                                assign = true;
                                continue;
                            }
                            if (!element.getKind().isClass() && !element.getKind().isInterface()) continue;
                            this.element2Import.put(element, tree);
                            assign = true;
                        }
                        if (!assign) {
                            this.addUnresolvableImport(qualIdent.getIdentifier(), tree);
                        }
                        this.import2Highlight.put(tree, this.getCurrentPath());
                    } else {
                        if (!this.isStar(tree)) {
                            this.addUnresolvableImport(qualIdent.getIdentifier(), tree);
                        } else {
                            this.unresolvablePackageImports.add(tree);
                        }
                        this.import2Highlight.put(tree, this.getCurrentPath());
                    }
                }
            }
            super.visitImport(tree, null);
            return null;
        }

        private void addUnresolvableImport(Name name, ImportTree imp) {
            String key = name.toString();
            Collection<ImportTree> l = this.simpleName2UnresolvableImports.get(key);
            if (l == null) {
                l = new LinkedList<ImportTree>();
                this.simpleName2UnresolvableImports.put(key, l);
            }
            l.add(imp);
        }

        private void typeUsed(Element decl, TreePath expr, boolean methodInvocation) {
            if (decl != null && (expr == null || expr.getLeaf().getKind() == Tree.Kind.IDENTIFIER || expr.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE)) {
                if (decl.asType() != null && decl.asType().getKind() != TypeKind.ERROR) {
                    ImportTree imp;
                    ImportTree importTree = imp = decl.getKind() != ElementKind.METHOD ? this.element2Import.remove(decl) : this.method2Import.remove(decl.getSimpleName().toString() + ((Object)decl.asType()).toString());
                    if (imp != null) {
                        if (this.isStar(imp)) {
                            this.handleUnresolvableImports(decl, methodInvocation, false);
                        }
                        this.import2Highlight.remove(imp);
                    }
                } else {
                    this.handleUnresolvableImports(decl, methodInvocation, true);
                    for (Map.Entry<Element, ImportTree> e : this.element2Import.entrySet()) {
                        if (this.importedBySingleImport.contains(e.getKey()) || !((Object)e.getKey().getSimpleName()).equals(decl.getSimpleName())) continue;
                        this.import2Highlight.remove(e.getValue());
                    }
                }
            }
        }

        private void handleUnresolvableImports(Element decl, boolean methodInvocation, boolean removeStarImports) {
            block2: {
                block3: {
                    Name simpleName = decl.getSimpleName();
                    if (simpleName == null) break block2;
                    Collection<ImportTree> imps = this.simpleName2UnresolvableImports.get(simpleName.toString());
                    if (imps == null) break block3;
                    for (ImportTree imp : imps) {
                        if (methodInvocation && !imp.isStatic()) continue;
                        this.import2Highlight.remove(imp);
                    }
                    break block2;
                }
                if (!removeStarImports) break block2;
                for (ImportTree unresolvable : this.unresolvablePackageImports) {
                    if (methodInvocation && !unresolvable.isStatic()) continue;
                    this.import2Highlight.remove(unresolvable);
                }
            }
        }
    }
}

