/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.fold;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.modules.java.editor.fold.JavaElementFoldManagerTaskFactory;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class JavaElementFoldManager
extends JavaFoldManager {
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private List<Fold> currentFolds;
    private Fold initialCommentFold;
    private Fold importsFold;

    public void init(FoldOperation operation) {
        this.operation = operation;
        Presets.refresh();
    }

    public synchronized void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        Object od = doc.getProperty("stream");
        if (od instanceof DataObject) {
            FileObject file = ((DataObject)od).getPrimaryFile();
            this.currentFolds = new ArrayList<Fold>();
            this.task = JavaElementFoldTask.getTask(file);
            this.task.setJavaElementFoldManager(this, file);
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold emptyFold) {
        this.removeDamagedNotify(emptyFold);
    }

    public void removeDamagedNotify(Fold damagedFold) {
        this.currentFolds.remove(this.operation.getExtraInfo(damagedFold));
        if (this.importsFold == damagedFold) {
            this.importsFold = null;
        }
        if (this.initialCommentFold == damagedFold) {
            this.initialCommentFold = null;
        }
    }

    public void expandNotify(Fold expandedFold) {
    }

    public synchronized void release() {
        if (this.task != null) {
            this.task.setJavaElementFoldManager(this, null);
        }
        this.task = null;
        this.file = null;
        this.currentFolds = null;
        this.importsFold = null;
        this.initialCommentFold = null;
    }

    protected static final class FoldInfo
    implements Comparable {
        private final Position start;
        private final Position end;
        private final JavaFoldManager.FoldTemplate template;
        private final boolean collapseByDefault;

        public FoldInfo(Document doc, int start, int end, JavaFoldManager.FoldTemplate template, boolean collapseByDefault) throws BadLocationException {
            this.start = doc.createPosition(start);
            this.end = doc.createPosition(end);
            this.template = template;
            this.collapseByDefault = collapseByDefault;
        }

        public int compareTo(Fold remote) {
            if (this.start.getOffset() < remote.getStartOffset()) {
                return -1;
            }
            if (this.start.getOffset() > remote.getStartOffset()) {
                return 1;
            }
            if (this.end.getOffset() < remote.getEndOffset()) {
                return -1;
            }
            if (this.end.getOffset() > remote.getEndOffset()) {
                return 1;
            }
            return this.template.getDescription().length() - remote.getDescription().length();
        }

        public int compareTo(Object o) {
            if (o instanceof Fold) {
                return this.compareTo((Fold)o);
            }
            FoldInfo remote = (FoldInfo)o;
            if (this.start.getOffset() < remote.start.getOffset()) {
                return -1;
            }
            if (this.start.getOffset() > remote.start.getOffset()) {
                return 1;
            }
            if (this.end.getOffset() < remote.end.getOffset()) {
                return -1;
            }
            if (this.end.getOffset() > remote.end.getOffset()) {
                return 1;
            }
            return this.template.getDescription().length() - remote.template.getDescription().length();
        }

        public String toString() {
            return "FoldInfo[" + this.start.getOffset() + ", " + this.end.getOffset() + ", " + this.template.getDescription() + "]";
        }
    }

    private static final class JavaElementFoldVisitor
    extends CancellableTreePathScanner<Object, Object> {
        private List<FoldInfo> folds = new ArrayList<FoldInfo>();
        private CompilationInfo info;
        private CompilationUnitTree cu;
        private SourcePositions sp;
        private boolean stopped;
        private int initialCommentStopPos = Integer.MAX_VALUE;
        private Document doc;
        private Presets presets;

        public JavaElementFoldVisitor(CompilationInfo info, CompilationUnitTree cu, SourcePositions sp, Document doc, Presets presets) {
            this.info = info;
            this.cu = cu;
            this.sp = sp;
            this.doc = doc;
            this.presets = presets;
        }

        public void checkInitialFold() {
            try {
                TokenHierarchy th = this.info.getTokenHierarchy();
                TokenSequence ts = th.tokenSequence(JavaTokenId.language());
                while (ts.moveNext() && ts.offset() < this.initialCommentStopPos) {
                    Token token = ts.token();
                    if (token.id() != JavaTokenId.BLOCK_COMMENT && token.id() != JavaTokenId.JAVADOC_COMMENT) continue;
                    int startOffset = ts.offset();
                    boolean collapsed = this.presets.foldInitialCommentsPreset;
                    this.folds.add(new FoldInfo(this.doc, startOffset, startOffset + token.length(), JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE, collapsed));
                    break;
                }
            }
            catch (BadLocationException e) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException e) {
                this.stopped = true;
            }
        }

        private void handleJavadoc(Tree t) throws BadLocationException, ConcurrentModificationException {
            TokenHierarchy th;
            TokenSequence ts;
            int start = (int)this.sp.getStartPosition(this.cu, t);
            if (start == -1) {
                return;
            }
            if (start < this.initialCommentStopPos) {
                this.initialCommentStopPos = start;
            }
            if ((ts = (th = this.info.getTokenHierarchy()).tokenSequence(JavaTokenId.language())).move(start) == Integer.MAX_VALUE) {
                return;
            }
            while (ts.movePrevious()) {
                Token token = ts.token();
                if (token.id() == JavaTokenId.JAVADOC_COMMENT) {
                    int startOffset = ts.offset();
                    this.folds.add(new FoldInfo(this.doc, startOffset, startOffset + token.length(), JavaFoldManager.JAVADOC_FOLD_TEMPLATE, this.presets.foldJavadocsPreset));
                    if (startOffset < this.initialCommentStopPos) {
                        this.initialCommentStopPos = startOffset;
                    }
                }
                if (token.id() == JavaTokenId.WHITESPACE || token.id() == JavaTokenId.BLOCK_COMMENT || token.id() == JavaTokenId.LINE_COMMENT) continue;
                break;
            }
        }

        private void handleTree(Tree node, Tree javadocTree, boolean handleOnlyJavadoc) {
            try {
                if (!handleOnlyJavadoc) {
                    int start = (int)this.sp.getStartPosition(this.cu, node);
                    int end = (int)this.sp.getEndPosition(this.cu, node);
                    if (start != -1 && end != -1) {
                        this.folds.add(new FoldInfo(this.doc, start, end, JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE, this.presets.foldCodeBlocksPreset));
                    }
                }
                this.handleJavadoc(javadocTree != null ? javadocTree : node);
            }
            catch (BadLocationException e) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException e) {
                this.stopped = true;
            }
        }

        public Object visitMethod(MethodTree node, Object p) {
            super.visitMethod(node, p);
            this.handleTree(node.getBody(), node, false);
            return null;
        }

        public Object visitClass(ClassTree node, Object p) {
            super.visitClass(node, (Object)Boolean.TRUE);
            try {
                if (p == Boolean.TRUE) {
                    int start = Utilities.findBodyStart(node, this.cu, this.sp, this.doc);
                    int end = (int)this.sp.getEndPosition(this.cu, node);
                    if (start != -1 && end != -1) {
                        this.folds.add(new FoldInfo(this.doc, start, end, JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE, this.presets.foldInnerClassesPreset));
                    }
                }
                this.handleJavadoc(node);
            }
            catch (BadLocationException e) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException e) {
                this.stopped = true;
            }
            return null;
        }

        public Object visitVariable(VariableTree node, Object p) {
            super.visitVariable(node, p);
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)this.getCurrentPath().getParentPath().getLeaf().getKind())) {
                this.handleTree(node, null, true);
            }
            return null;
        }

        public Object visitBlock(BlockTree node, Object p) {
            super.visitBlock(node, p);
            TreePath path = this.getCurrentPath();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) {
                this.handleTree(node, null, false);
            }
            return null;
        }

        public Object visitCompilationUnit(CompilationUnitTree node, Object p) {
            int importsStart = Integer.MAX_VALUE;
            int importsEnd = -1;
            for (ImportTree importTree : node.getImports()) {
                int start = (int)this.sp.getStartPosition(this.cu, importTree);
                int end = (int)this.sp.getEndPosition(this.cu, importTree);
                if (importsStart > start) {
                    importsStart = start;
                }
                if (end <= importsEnd) continue;
                importsEnd = end;
            }
            if (importsEnd != -1 && importsStart != -1) {
                if (importsStart < this.initialCommentStopPos) {
                    this.initialCommentStopPos = importsStart;
                }
                try {
                    boolean collapsed = this.presets.foldImportsPreset;
                    if ((importsStart += 7) < importsEnd) {
                        this.folds.add(new FoldInfo(this.doc, importsStart, importsEnd, JavaFoldManager.IMPORTS_FOLD_TEMPLATE, collapsed));
                    }
                }
                catch (BadLocationException e) {
                    this.stopped = true;
                }
            }
            return super.visitCompilationUnit(node, p);
        }
    }

    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private Document doc;
        private List<FoldInfo> infos;
        private long startTime;

        public CommitFolds(Document doc, List<FoldInfo> infos) {
            this.doc = doc;
            this.infos = infos;
        }

        private boolean mergeSpecialFoldState(FoldInfo fi) {
            if (fi.template == JavaFoldManager.IMPORTS_FOLD_TEMPLATE) {
                if (JavaElementFoldManager.this.importsFold != null) {
                    return JavaElementFoldManager.this.importsFold.isCollapsed();
                }
            } else if (fi.template == JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE && JavaElementFoldManager.this.initialCommentFold != null) {
                return JavaElementFoldManager.this.initialCommentFold.isCollapsed();
            }
            return fi.collapseByDefault;
        }

        private int flip(int order) {
            if (order > 0) {
                return -1;
            }
            if (order < 0) {
                return 1;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                Document d = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                if (d != this.doc) {
                    return;
                }
                d.render(this);
                return;
            }
            JavaElementFoldManager.this.operation.getHierarchy().lock();
            try {
                FoldHierarchyTransaction tr = JavaElementFoldManager.this.operation.openTransaction();
                try {
                    FoldInfo currentNew;
                    if (JavaElementFoldManager.this.currentFolds == null) {
                        return;
                    }
                    ArrayList<Fold> updatedFolds = new ArrayList<Fold>(this.infos.size());
                    Iterator itExisting = JavaElementFoldManager.this.currentFolds.iterator();
                    Iterator<FoldInfo> itNew = this.infos.iterator();
                    Fold currentExisting = itExisting.hasNext() ? (Fold)itExisting.next() : null;
                    FoldInfo foldInfo = currentNew = itNew.hasNext() ? itNew.next() : null;
                    while (currentExisting != null || currentNew != null) {
                        FoldInfo newNew;
                        int order;
                        int n = currentExisting != null && currentNew != null ? currentNew.compareTo(currentExisting) : (order = currentExisting != null ? 1 : -1);
                        if (order > 0) {
                            JavaElementFoldManager.this.operation.removeFromHierarchy(currentExisting, tr);
                            if (JavaElementFoldManager.this.importsFold == currentExisting) {
                                JavaElementFoldManager.this.importsFold = null;
                            }
                            if (JavaElementFoldManager.this.initialCommentFold == currentExisting) {
                                JavaElementFoldManager.this.initialCommentFold = null;
                            }
                            currentExisting = itExisting.hasNext() ? (Fold)itExisting.next() : null;
                            continue;
                        }
                        if (order < 0) {
                            int start = currentNew.start.getOffset();
                            int end = currentNew.end.getOffset();
                            if (end > start && end - start >= currentNew.template.getStartGuardedLength() + currentNew.template.getEndGuardedLength()) {
                                Fold f = JavaElementFoldManager.this.operation.addToHierarchy(currentNew.template.getType(), currentNew.template.getDescription(), this.mergeSpecialFoldState(currentNew), start, end, currentNew.template.getStartGuardedLength(), currentNew.template.getEndGuardedLength(), (Object)currentNew, tr);
                                if (currentNew.template == JavaFoldManager.IMPORTS_FOLD_TEMPLATE) {
                                    JavaElementFoldManager.this.importsFold = f;
                                }
                                if (currentNew.template == JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE) {
                                    JavaElementFoldManager.this.initialCommentFold = f;
                                }
                                updatedFolds.add(f);
                            }
                        } else {
                            updatedFolds.add(currentExisting);
                            currentExisting = itExisting.hasNext() ? (Fold)itExisting.next() : null;
                        }
                        FoldInfo foldInfo2 = newNew = itNew.hasNext() ? itNew.next() : null;
                        while (newNew != null && currentNew.compareTo(newNew) == 0) {
                            newNew = itNew.hasNext() ? itNew.next() : null;
                        }
                        currentNew = newNew;
                    }
                    JavaElementFoldManager.this.currentFolds = updatedFolds;
                }
                catch (BadLocationException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                finally {
                    tr.commit();
                }
            }
            finally {
                JavaElementFoldManager.this.operation.getHierarchy().unlock();
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{JavaElementFoldManager.this.file, endTime - this.startTime});
        }
    }

    static final class JavaElementFoldTask
    extends ScanningCancellableTask<CompilationInfo> {
        private static Map<DataObject, JavaElementFoldTask> file2Task = new WeakHashMap<DataObject, JavaElementFoldTask>();
        private Collection<Reference<JavaElementFoldManager>> managers = new ArrayList<Reference<JavaElementFoldManager>>(2);

        JavaElementFoldTask() {
        }

        static JavaElementFoldTask getTask(FileObject file) {
            try {
                DataObject od = DataObject.find((FileObject)file);
                JavaElementFoldTask task = file2Task.get(od);
                if (task == null) {
                    task = new JavaElementFoldTask();
                    file2Task.put(od, task);
                }
                return task;
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(JavaElementFoldManager.class.getName()).log(Level.FINE, null, ex);
                return new JavaElementFoldTask();
            }
        }

        synchronized void setJavaElementFoldManager(JavaElementFoldManager manager, FileObject file) {
            if (file == null) {
                Iterator<Reference<JavaElementFoldManager>> it = this.managers.iterator();
                while (it.hasNext()) {
                    Reference<JavaElementFoldManager> ref = it.next();
                    JavaElementFoldManager fm = ref.get();
                    if (fm != null && fm != manager) continue;
                    it.remove();
                    break;
                }
            } else {
                this.managers.add(new WeakReference<JavaElementFoldManager>(manager));
                JavaElementFoldManagerTaskFactory.doRefresh(file);
            }
        }

        private synchronized Object findLiveManagers() {
            Object oneMgr = null;
            ArrayList<JavaElementFoldManager> result = null;
            Iterator<Reference<JavaElementFoldManager>> it = this.managers.iterator();
            while (it.hasNext()) {
                Reference<JavaElementFoldManager> ref = it.next();
                JavaElementFoldManager fm = ref.get();
                if (fm == null) {
                    it.remove();
                    continue;
                }
                if (result != null) {
                    result.add(fm);
                    continue;
                }
                if (oneMgr != null) {
                    result = new ArrayList<JavaElementFoldManager>(2);
                    result.add((JavaElementFoldManager)((Object)oneMgr));
                    result.add(fm);
                    continue;
                }
                oneMgr = fm;
            }
            return result != null ? result : oneMgr;
        }

        @Override
        public void run(CompilationInfo info) {
            this.resume();
            final Object mgrs = this.findLiveManagers();
            if (mgrs == null) {
                return;
            }
            long startTime = System.currentTimeMillis();
            CompilationUnitTree cu = info.getCompilationUnit();
            final Document doc = info.getSnapshot().getSource().getDocument(false);
            if (doc == null) {
                return;
            }
            final JavaElementFoldVisitor v = new JavaElementFoldVisitor(info, cu, info.getTrees().getSourcePositions(), doc, Presets.get());
            this.scan(v, (Tree)cu, null);
            if (v.stopped || this.isCancelled()) {
                return;
            }
            v.checkInitialFold();
            if (v.stopped || this.isCancelled()) {
                return;
            }
            Collections.sort(v.folds);
            if (mgrs instanceof JavaElementFoldManager) {
                JavaElementFoldManager javaElementFoldManager = (JavaElementFoldManager)((Object)mgrs);
                ((Object)((Object)javaElementFoldManager)).getClass();
                SwingUtilities.invokeLater(javaElementFoldManager.new CommitFolds(doc, v.folds));
            } else {
                SwingUtilities.invokeLater(new Runnable(){
                    Collection<JavaElementFoldManager> jefms;
                    {
                        this.jefms = (Collection)mgrs;
                    }

                    @Override
                    public void run() {
                        Iterator<JavaElementFoldManager> i$ = this.jefms.iterator();
                        while (i$.hasNext()) {
                            JavaElementFoldManager jefm;
                            JavaElementFoldManager javaElementFoldManager = jefm = i$.next();
                            ((Object)((Object)javaElementFoldManager)).getClass();
                            javaElementFoldManager.new CommitFolds(doc, v.folds).run();
                        }
                    }
                });
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{info.getFileObject(), endTime - startTime});
        }
    }

    private static class Presets {
        private boolean foldImportsPreset = false;
        private boolean foldInnerClassesPreset = false;
        private boolean foldJavadocsPreset = false;
        private boolean foldCodeBlocksPreset = false;
        private boolean foldInitialCommentsPreset = false;
        private static volatile Presets CURRENT;

        public Presets() {
            Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
            this.foldInitialCommentsPreset = prefs.getBoolean("code-folding-collapse-initial-comment", this.foldInitialCommentsPreset);
            this.foldImportsPreset = prefs.getBoolean("code-folding-collapse-import", this.foldImportsPreset);
            this.foldCodeBlocksPreset = prefs.getBoolean("code-folding-collapse-method", this.foldCodeBlocksPreset);
            this.foldInnerClassesPreset = prefs.getBoolean("code-folding-collapse-innerclass", this.foldInnerClassesPreset);
            this.foldJavadocsPreset = prefs.getBoolean("code-folding-collapse-javadoc", this.foldJavadocsPreset);
        }

        static void refresh() {
            CURRENT = null;
        }

        static Presets get() {
            Presets p = CURRENT;
            if (p != null) {
                return p;
            }
            CURRENT = new Presets();
            return CURRENT;
        }
    }
}

