/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins.firefox;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.extbrowser.plugins.ExtensionManager;
import org.netbeans.modules.extbrowser.plugins.ExtensionManagerAccessor;
import org.netbeans.modules.extbrowser.plugins.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FFManagerAccessor
implements ExtensionManagerAccessor {
    @Override
    public ExtensionManagerAccessor.BrowserExtensionManager getManager() {
        return new FFExtensionManager();
    }

    private static class FFExtensionManager
    extends ExtensionManagerAccessor.AbstractBrowserExtensionManager {
        private static final long BUTTON_DELAY = 10000L;
        private static final long CHECK_PERIOD = 700L;
        private static final String PROFILE_LOCK_WINDOWS = "parent.lock";
        private static final String PROFILE_LOCK = "lock";
        private static final String[] WIN32_PROFILES_LOCATIONS = new String[]{"\\Mozilla\\Firefox\\"};
        private static final String[] LINUX_PROFILES_LOCATIONS = new String[]{"/.mozilla/firefox/"};
        private static final String[] MACOSX_PROFILES_LOCATIONS = new String[]{"/Library/Application Support/Firefox/", "/Library/Mozilla/Firefox/"};
        private static final String EXTENSION_ID = "ros-firefox-plugin@netbeans.org";
        private static final String INSTALL_KEYWORD = "needs-install";
        private static final String EXTENSION_CACHE = "extensions.cache";
        private static final String EXTENSION_PATH = "modules/ext/netbeans-ros-firefox-plugin.xpi";

        private FFExtensionManager() {
        }

        @Override
        public ExtensionManager.ExtensitionStatus isInstalled() {
            File defaultProfile = this.getDefaultProfile();
            File extensionDir = new File(defaultProfile, "extensions" + File.separator + EXTENSION_ID);
            String extensionVersion = this.getVersion(extensionDir);
            if (extensionVersion != null) {
                boolean isInstalling = this.checkExtensionCache(extensionDir, INSTALL_KEYWORD);
                if (isInstalling) {
                    return ExtensionManager.ExtensitionStatus.MISSING;
                }
            } else {
                File xpi = new File(defaultProfile, "extensions" + File.separator + EXTENSION_ID + ".xpi");
                extensionVersion = this.getVersion(xpi);
            }
            if (this.isUpdateRequired(extensionVersion)) {
                if (!this.checkExtensionInstall(defaultProfile)) {
                    return ExtensionManager.ExtensitionStatus.INSTALLED;
                }
                return ExtensionManager.ExtensitionStatus.MISSING;
            }
            return ExtensionManager.ExtensitionStatus.INSTALLED;
        }

        @Override
        public boolean install(ExtensionManager.ExtensitionStatus state) {
            File defaultProfile = this.getDefaultProfile();
            File extensionDir = new File(defaultProfile, "extensions" + File.separator + EXTENSION_ID);
            File extensionFile = InstalledFileLocator.getDefault().locate(EXTENSION_PATH, "org.netbeans.modules.extbrowser", false);
            if (extensionFile == null) {
                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).severe("Could not find firefox extension in installation directory");
                return false;
            }
            if (extensionDir.exists() && extensionDir.isDirectory()) {
                return this.oldStyleInstall(extensionFile);
            }
            NotifyDescriptor.Confirmation installDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(FFExtensionManager.class, (String)"LBL_InstallMsgWithoutRestart"), NbBundle.getMessage(FFExtensionManager.class, (String)"TTL_InstallExtension"), 2, 3);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)installDesc);
            if (result != NotifyDescriptor.OK_OPTION) {
                return false;
            }
            try {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("file:///" + extensionFile.getCanonicalPath()));
            }
            catch (IOException e) {
                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.INFO, null, e);
                return false;
            }
            return true;
        }

        private boolean oldStyleInstall(File extensionFile) {
            File extensionsDotRdf;
            boolean success;
            File defaultProfile = this.getDefaultProfile();
            File extensionDir = new File(defaultProfile, "extensions" + File.separator + EXTENSION_ID);
            if (!this.checkExtensionInstall(defaultProfile)) {
                NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)NbBundle.getMessage(FFExtensionManager.class, (String)"LBL_FirefoxNotRestarted"), 0);
                descriptor.setTitle(NbBundle.getMessage(FFExtensionManager.class, (String)"TTL_FirefoxNotRestarted"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                return false;
            }
            String dialogMsg = Utilities.isMac() ? NbBundle.getMessage(FFExtensionManager.class, (String)"LBL_InstallMsgMacOs") : NbBundle.getMessage(FFExtensionManager.class, (String)"LBL_InstallMsg");
            NotifyDescriptor.Confirmation installDesc = new NotifyDescriptor.Confirmation((Object)dialogMsg, NbBundle.getMessage(FFExtensionManager.class, (String)"TTL_InstallExtension"), 2, 3);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)installDesc);
            if (result != NotifyDescriptor.OK_OPTION) {
                return false;
            }
            if (this.isFirefoxRunning(defaultProfile)) {
                boolean cancelled;
                boolean bl = cancelled = !this.displayFirefoxRunningDialog(defaultProfile);
                if (cancelled) {
                    return false;
                }
            }
            if ((success = this.installExtension(extensionDir, extensionFile)) && (extensionsDotRdf = new File(defaultProfile, "extensions.rdf")).exists()) {
                extensionsDotRdf.delete();
            }
            return success;
        }

        @Override
        protected String getCurrentPluginVersion() {
            File extensionFile = InstalledFileLocator.getDefault().locate(EXTENSION_PATH, "org.netbeans.modules.extbrowser", false);
            return this.getVersion(extensionFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean installExtension(File extensionDir, File extensionFile) {
            block13: {
                File backupFolder;
                block14: {
                    backupFolder = null;
                    if (extensionDir.exists()) {
                        StringBuilder tmp = new StringBuilder(EXTENSION_ID);
                        tmp.append("-tmp");
                        do {
                            tmp.append("0");
                        } while ((backupFolder = new File(extensionDir.getParentFile(), tmp.toString())).exists());
                        if (!extensionDir.renameTo(backupFolder)) {
                            Logger.getLogger(FFExtensionManager.class.getCanonicalName()).warning("Could not create backup for existing extension: ros-firefox-plugin@netbeans.org");
                            Utils.rmDir(extensionDir);
                            backupFolder = null;
                        }
                    }
                    boolean copySuccessful = false;
                    try {
                        Utils.extractFiles(extensionFile, extensionDir);
                        copySuccessful = true;
                        if (backupFolder == null) break block13;
                        if (!copySuccessful) break block14;
                    }
                    catch (IOException ex) {
                        boolean bl;
                        block15: {
                            block16: {
                                try {
                                    Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.SEVERE, "Could not copy extension: ros-firefox-plugin@netbeans.org", ex);
                                    bl = false;
                                    if (backupFolder == null) break block15;
                                    if (!copySuccessful) break block16;
                                }
                                catch (Throwable throwable) {
                                    if (backupFolder != null) {
                                        if (copySuccessful) {
                                            Utils.rmDir(backupFolder);
                                        } else {
                                            Utils.rmDir(extensionDir);
                                            boolean movedBack = backupFolder.renameTo(extensionDir);
                                            if (!movedBack) {
                                                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).warning("Could not restore old extension: ros-firefox-plugin@netbeans.org");
                                            }
                                        }
                                    }
                                    throw throwable;
                                }
                                Utils.rmDir(backupFolder);
                                break block15;
                            }
                            Utils.rmDir(extensionDir);
                            boolean movedBack = backupFolder.renameTo(extensionDir);
                            if (!movedBack) {
                                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).warning("Could not restore old extension: ros-firefox-plugin@netbeans.org");
                            }
                        }
                        return bl;
                    }
                    Utils.rmDir(backupFolder);
                    break block13;
                }
                Utils.rmDir(extensionDir);
                boolean movedBack = backupFolder.renameTo(extensionDir);
                if (!movedBack) {
                    Logger.getLogger(FFExtensionManager.class.getCanonicalName()).warning("Could not restore old extension: ros-firefox-plugin@netbeans.org");
                }
            }
            return true;
        }

        private boolean isFirefoxRunning(File profileDir) {
            if (Utilities.isWindows()) {
                return new File(profileDir, PROFILE_LOCK_WINDOWS).exists();
            }
            if (Utilities.isMac()) {
                return false;
            }
            String[] fileNames = profileDir.list();
            if (fileNames != null) {
                for (String fileName : fileNames) {
                    if (!fileName.equals(PROFILE_LOCK)) continue;
                    return true;
                }
            }
            return false;
        }

        private String getVersion(File file) {
            Node descriptionNode = null;
            Document doc = this.getInstallRdfDocument(file);
            if (doc == null) {
                return null;
            }
            for (Node node = doc.getDocumentElement().getFirstChild(); descriptionNode == null && node != null; node = node.getNextSibling()) {
                String nodeName = node.getNodeName();
                String string = nodeName = nodeName == null ? "" : nodeName.toLowerCase();
                if (!nodeName.equalsIgnoreCase("description") && !nodeName.equalsIgnoreCase("rdf:description")) continue;
                Node aboutNode = node.getAttributes().getNamedItem("about");
                if (aboutNode == null) {
                    aboutNode = node.getAttributes().getNamedItem("RDF:about");
                }
                if (aboutNode == null) continue;
                String aboutText = aboutNode.getNodeValue();
                String string2 = aboutText = aboutText == null ? "" : aboutText.toLowerCase(Locale.US);
                if (!aboutText.equals("urn:mozilla:install-manifest")) continue;
                descriptionNode = node;
            }
            if (descriptionNode == null) {
                return null;
            }
            Node versionNode = descriptionNode.getAttributes().getNamedItem("em:version");
            if (versionNode != null) {
                return versionNode.getNodeValue();
            }
            NodeList children = descriptionNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                String name = child.getNodeName();
                String string = name = name == null ? "" : name.toLowerCase();
                if (!name.equals("em:version")) continue;
                return child.getTextContent();
            }
            return null;
        }

        private Document getInstallRdfDocument(File file) {
            if (!file.exists()) {
                return null;
            }
            File rdfFile = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            Document doc = null;
            try {
                builder = factory.newDocumentBuilder();
                if (!file.isDirectory()) {
                    return Utils.parseZipXml(file, "install.rdf", builder);
                }
                rdfFile = new File(file, "install.rdf");
                if (rdfFile.isFile()) {
                    doc = builder.parse(rdfFile);
                }
                return doc;
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.WARNING, null, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.WARNING, null, ex);
            }
            return null;
        }

        private File getDefaultProfile() {
            String[] firefoxDirs = this.getLocationsForOS();
            if (firefoxDirs != null) {
                for (String firefoxUserDir : firefoxDirs) {
                    File dir = new File(firefoxUserDir);
                    if (!dir.isDirectory() || !dir.exists()) continue;
                    List<FirefoxProfile> profiles = this.getAllProfiles(dir);
                    if (profiles == null || profiles.size() == 0) {
                        return this.guessDefaultProfile(dir);
                    }
                    return this.findDefaultProfile(dir, profiles);
                }
            }
            return null;
        }

        private File findDefaultProfile(File dir, List<FirefoxProfile> profiles) {
            File profileDir;
            for (FirefoxProfile profile : profiles) {
                if (!profile.isDefaultProfile()) continue;
                profileDir = null;
                profileDir = profile.isRelative() ? new File(dir, profile.getPath()) : new File(profile.getPath());
                if (!profileDir.isDirectory()) continue;
                return profileDir;
            }
            for (FirefoxProfile profile : profiles) {
                profileDir = null;
                profileDir = profile.isRelative() ? new File(dir, profile.getPath()) : new File(profile.getPath());
                if (!profileDir.isDirectory()) continue;
                return profileDir;
            }
            return null;
        }

        private File guessDefaultProfile(File dir) {
            File profilesDir = new File(dir, "Profiles");
            if (profilesDir.isDirectory()) {
                File[] childrenFiles = profilesDir.listFiles();
                for (int i = 0; childrenFiles != null && i < childrenFiles.length; ++i) {
                    File childFile = childrenFiles[i];
                    if (!childFile.isDirectory() || !childFile.getAbsolutePath().endsWith(".default")) continue;
                    return childFile;
                }
            }
            return null;
        }

        private String[] getLocationsForOS() {
            if (Utilities.isWindows()) {
                return Utils.getUserPaths(WIN32_PROFILES_LOCATIONS);
            }
            if (Utilities.isMac()) {
                return Utils.getUserPaths(MACOSX_PROFILES_LOCATIONS);
            }
            return Utils.getUserPaths(LINUX_PROFILES_LOCATIONS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<FirefoxProfile> getAllProfiles(File dir) {
            File profileCfg = new File(dir, "profiles.ini");
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(profileCfg), Utils.UTF_8));
                HashSet profileData = new HashSet();
                LinkedHashSet<String> currentProfile = null;
                while (reader.ready()) {
                    String line = reader.readLine().trim();
                    if (line.startsWith("[") && line.endsWith("]")) {
                        if (currentProfile != null) {
                            profileData.add(currentProfile);
                        }
                        currentProfile = new LinkedHashSet<String>();
                        currentProfile.add(line);
                        continue;
                    }
                    if (line.indexOf(61) <= 0) continue;
                    currentProfile.add(line);
                }
                if (currentProfile != null) {
                    profileData.add(currentProfile);
                }
                ArrayList<FirefoxProfile> allProfiles = new ArrayList<FirefoxProfile>(profileData.size());
                for (LinkedHashSet linkedHashSet : profileData) {
                    if (linkedHashSet.size() == 0) continue;
                    FirefoxProfile profile = new FirefoxProfile();
                    boolean isValidProfile = false;
                    for (String line : linkedHashSet) {
                        int index = line.indexOf(61);
                        if (index <= 0 || index >= line.length() - 1) continue;
                        String var = line.substring(0, index);
                        String val = line.substring(index + 1, line.length());
                        if (var.equals("Name")) {
                            isValidProfile = true;
                            continue;
                        }
                        if (var.equals("IsRelative")) {
                            if (!val.equals("1")) continue;
                            profile.setRelative(true);
                            continue;
                        }
                        if (var.equals("Path")) {
                            profile.setPath(val);
                            continue;
                        }
                        if (!var.equals("Default") || !val.equals("1")) continue;
                        profile.setDefaultProfile(true);
                    }
                    if (!isValidProfile) continue;
                    allProfiles.add(profile);
                }
                ArrayList<FirefoxProfile> arrayList = allProfiles;
                return arrayList;
            }
            catch (IOException ex) {
                Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.WARNING, "Could not read Firefox profiles", ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.WARNING, null, e);
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkExtensionCache(File profileDir, String keyword) {
            File extensionCache = new File(profileDir, EXTENSION_CACHE);
            if (extensionCache.exists() && extensionCache.isFile()) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(extensionCache), Utils.UTF_8));
                    boolean foundExtension = false;
                    while (br.ready() && !foundExtension) {
                        String[] words;
                        String nextLine = br.readLine();
                        if (nextLine == null) continue;
                        for (String element : words = nextLine.split("\\s")) {
                            if (element.equals(EXTENSION_ID)) {
                                foundExtension = true;
                                if (keyword != null) continue;
                                boolean bl = true;
                                return bl;
                            }
                            if (!foundExtension || !element.equals(keyword)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.WARNING, null, ex);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(FFExtensionManager.class.getCanonicalName()).log(Level.WARNING, null, ex);
                        }
                    }
                }
            }
            return false;
        }

        private boolean checkExtensionInstall(File profileDir) {
            File extensionCache = new File(profileDir, EXTENSION_CACHE);
            if (extensionCache.exists() && extensionCache.isFile()) {
                return this.checkExtensionCache(profileDir, null);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean displayFirefoxRunningDialog(final File profileDir) {
            String dialogText = NbBundle.getMessage(FFExtensionManager.class, (String)"LBL_FirefoxRunning");
            String dialogTitle = NbBundle.getMessage(FFExtensionManager.class, (String)"TTL_FirefoxRunning");
            final JButton ok = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)ok, (String)NbBundle.getMessage(FFExtensionManager.class, (String)"LBL_ForceInstall"));
            ok.setEnabled(false);
            JButton cancel = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)cancel, (String)NbBundle.getMessage(FFExtensionManager.class, (String)"LBL_CanelButton"));
            Object[] options = new Object[]{ok, cancel};
            DialogDescriptor dd = new DialogDescriptor((Object)dialogText, dialogTitle, true, options, (Object)cancel, 0, null, null);
            dd.setClosingOptions(new Object[]{cancel});
            final Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            final boolean[] cancelled = new boolean[]{true};
            TimerTask runningCheck = new TimerTask(){

                @Override
                public void run() {
                    if (dialog.isVisible() && !FFExtensionManager.this.isFirefoxRunning(profileDir)) {
                        cancelled[0] = false;
                        dialog.setVisible(false);
                        this.cancel();
                    }
                }
            };
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cancelled[0] = false;
                    dialog.setVisible(false);
                }
            });
            TimerTask enableButton = new TimerTask(){

                @Override
                public void run() {
                    ok.setEnabled(true);
                }
            };
            Timer timer = new Timer();
            timer.schedule(enableButton, 10000L);
            Timer profileCheckTimer = new Timer();
            profileCheckTimer.schedule(runningCheck, 700L, 700L);
            try {
                dialog.setVisible(true);
            }
            finally {
                dialog.dispose();
                timer.cancel();
                profileCheckTimer.cancel();
            }
            return !cancelled[0];
        }

        private static final class FirefoxProfile {
            private boolean relative;
            private boolean defaultProfile;
            private String path = "";

            public boolean isDefaultProfile() {
                return this.defaultProfile;
            }

            public void setDefaultProfile(boolean defaultProfile) {
                this.defaultProfile = defaultProfile;
            }

            public String getPath() {
                return this.path;
            }

            public void setPath(String path) {
                this.path = path;
            }

            public boolean isRelative() {
                return this.relative;
            }

            public void setRelative(boolean relative) {
                this.relative = relative;
            }
        }
    }
}

