/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins.chrome;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class WebStorePanel
extends JPanel {
    private static final long serialVersionUID = 6387325958428583652L;
    static final Logger LOGGER = Logger.getLogger(WebStorePanel.class.getName());
    static final String EXTENSION_HELP = "chrome.extension";
    private JEditorPane description;
    private JEditorPane notConnectedLink;
    private JLabel warningLbl;
    private JLabel warningTextLbl;
    private JButton webStoreButton;

    WebStorePanel(Runnable runnable) {
        this.init();
        this.warningTextLbl.setText(NbBundle.getMessage(WebStorePanel.class, (String)"LBL_UpdateRequired"));
        this.description.setText(NbBundle.getMessage(WebStorePanel.class, (String)"TXT_WebStoreUpdate"));
        this.webStoreButton.setText(NbBundle.getMessage(WebStorePanel.class, (String)"LBL_RerunButton"));
        this.remove(this.notConnectedLink);
        this.attachActions(runnable);
    }

    WebStorePanel(boolean rerun, String link, Runnable runnable, final Runnable linkAction) {
        this.init();
        this.notConnectedLink.setBackground(this.getBackground());
        if (rerun) {
            this.warningTextLbl.setText(NbBundle.getMessage(WebStorePanel.class, (String)"LBL_Rerun"));
            this.description.setText("");
            this.description.setPreferredSize(new Dimension(0, 0));
            this.webStoreButton.setText(NbBundle.getMessage(WebStorePanel.class, (String)"LBL_RerunButton"));
            this.notConnectedLink.setText(NbBundle.getMessage(WebStorePanel.class, (String)"LBL_UnableInstall", (Object)link));
        } else {
            this.notConnectedLink.setText(NbBundle.getMessage(WebStorePanel.class, (String)"LBL_NotConnected", (Object)link));
        }
        this.notConnectedLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    linkAction.run();
                }
            }
        });
        if (runnable != null) {
            this.attachActions(runnable);
        }
    }

    private Dimension getDescriptionSize() {
        return new Dimension(350, (int)this.getAdjustedHeight());
    }

    private void init() {
        this.initComponents();
        this.description.setBackground(this.getBackground());
        Font font = this.description.getFont();
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.description.getDocument()).getStyleSheet().addRule(bodyRule);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent event) {
                if ((4L & event.getChangeFlags()) != 0L && WebStorePanel.this.isShowing()) {
                    Dimension size = WebStorePanel.this.description.getPreferredSize();
                    size.setSize(size.getWidth(), WebStorePanel.this.getAdjustedHeight());
                    WebStorePanel.this.description.setPreferredSize(size);
                    WebStorePanel.this.description.setMaximumSize(size);
                    WebStorePanel.this.description.setMinimumSize(size);
                    Window window = SwingUtilities.getWindowAncestor(WebStorePanel.this);
                    window.pack();
                }
            }
        });
    }

    private double getAdjustedHeight() {
        JEditorPane fakePane = new JEditorPane();
        fakePane.setEditable(false);
        fakePane.setBorder(null);
        fakePane.setContentType("text/html");
        fakePane.setFont(this.description.getFont());
        Dimension size = this.description.getPreferredSize();
        size.setSize(size.getWidth(), 32767.0);
        fakePane.setSize(size);
        fakePane.setText(this.description.getText());
        Font font = this.description.getFont();
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)fakePane.getDocument()).getStyleSheet().addRule(bodyRule);
        return fakePane.getPreferredSize().getHeight();
    }

    private int getRows() {
        int count;
        block3: {
            count = 0;
            try {
                int offs = this.description.getCaretPosition();
                while (offs > 0) {
                    offs = Utilities.getRowStart(this.description, offs) - 1;
                    ++count;
                }
            }
            catch (BadLocationException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return count + 1;
    }

    private void attachActions(final Runnable runnable) {
        this.webStoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                runnable.run();
            }
        });
    }

    private void initComponents() {
        this.warningLbl = new JLabel();
        this.warningTextLbl = new JLabel();
        this.webStoreButton = new JButton();
        this.description = new JEditorPane();
        this.notConnectedLink = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.warningLbl.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/extbrowser/resources/warning.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(20, 20, 15, 20);
        this.add((Component)this.warningLbl, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.warningTextLbl, (String)NbBundle.getMessage(WebStorePanel.class, (String)"LBL_ConnectorExtenstion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 15, 20);
        this.add((Component)this.warningTextLbl, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.webStoreButton, (String)NbBundle.getMessage(WebStorePanel.class, (String)"LBL_WebStore"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.webStoreButton, gridBagConstraints);
        this.description.setEditable(false);
        this.description.setBackground(new Color(240, 240, 240));
        this.description.setBorder(null);
        this.description.setContentType("text/html");
        this.description.setText(NbBundle.getMessage(WebStorePanel.class, (String)"WebStorePanel.description.text"));
        this.description.setMinimumSize(new Dimension(350, 60));
        this.description.setOpaque(false);
        this.description.setPreferredSize(new Dimension(350, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 10, 20);
        this.add((Component)this.description, gridBagConstraints);
        this.notConnectedLink.setEditable(false);
        this.notConnectedLink.setBackground(new Color(240, 240, 240));
        this.notConnectedLink.setBorder(null);
        this.notConnectedLink.setContentType("text/html");
        this.notConnectedLink.setText(NbBundle.getMessage(WebStorePanel.class, (String)"LBL_NotConnected"));
        this.notConnectedLink.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.notConnectedLink, gridBagConstraints);
    }
}

