/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins.chrome;

import java.net.URL;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.plugins.ExternalBrowserPlugin;
import org.netbeans.modules.web.webkit.debugging.api.TransportStateException;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;

public class WebKitDebuggingTransport
implements TransportImplementation {
    private ExtBrowserImpl impl;
    private ResponseCallback callback;

    public WebKitDebuggingTransport(ExtBrowserImpl impl) {
        this.impl = impl;
    }

    public void sendCommand(Command command) throws TransportStateException {
        if (this.impl.getBrowserTabDescriptor() == null) {
            throw new TransportStateException();
        }
        ExternalBrowserPlugin.getInstance().sendWebKitDebuggerCommand(this.impl.getBrowserTabDescriptor(), command.getCommand());
    }

    public void registerResponseCallback(ResponseCallback callback) {
        this.callback = callback;
    }

    public boolean attach() {
        ExternalBrowserPlugin.getInstance().attachWebKitDebugger(this.impl.getBrowserTabDescriptor());
        this.impl.getBrowserTabDescriptor().setCallback(this.callback);
        return true;
    }

    public boolean detach() {
        ExternalBrowserPlugin.getInstance().detachWebKitDebugger(this.impl.getBrowserTabDescriptor());
        return true;
    }

    public String getConnectionName() {
        if (this.impl.getURL() != null) {
            return this.impl.getURL().toExternalForm();
        }
        return "...";
    }

    public URL getConnectionURL() {
        if (this.impl.getURL() != null) {
            return this.impl.getURL();
        }
        return null;
    }

    public String getVersion() {
        return "version 1.0";
    }
}

