/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins;

import java.util.Locale;
import java.util.Map;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.openide.util.Exceptions;

public class Message {
    private static final String MESSAGE = "message";
    private final MessageType type;
    private final JSONObject data;
    static final String TAB_ID = "tabId";

    Message(MessageType type, JSONObject data) {
        this.type = type;
        this.data = data;
    }

    Message(MessageType type, Map map) {
        this.type = type;
        this.data = new JSONObject(map);
    }

    public int getTabId() {
        Number n = (Number)this.getValue().get((Object)TAB_ID);
        if (n == null) {
            return -1;
        }
        return n.intValue();
    }

    public static Message parse(String message) {
        try {
            JSONObject json = (JSONObject)JSONValue.parseWithException((String)message);
            return new Message(MessageType.forString((String)json.get((Object)MESSAGE)), json);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public MessageType getType() {
        return this.type;
    }

    public String toStringValue() {
        JSONObject result = new JSONObject((Map)this.data);
        result.put((Object)MESSAGE, (Object)this.type.toString());
        return result.toJSONString();
    }

    public JSONObject getValue() {
        return this.data;
    }

    public static enum MessageType {
        INIT,
        RELOAD,
        URLCHANGE,
        CLOSE,
        INSPECT,
        ATTACH_DEBUGGER,
        DETACH_DEBUGGER,
        DEBUGGER_COMMAND,
        DEBUGGER_COMMAND_RESPONSE,
        DEBUGGER_DETACHED,
        LOAD_RESIZE_OPTIONS,
        SAVE_RESIZE_OPTIONS,
        READY;


        public String toString() {
            return super.toString().toLowerCase(Locale.US);
        }

        public static MessageType forString(String str) {
            for (MessageType type : MessageType.values()) {
                if (!type.toString().equals(str)) continue;
                return type;
            }
            return null;
        }
    }
}

