/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Format;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.SimpleExtBrowser;
import org.netbeans.modules.extbrowser.URLUtil;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MacBrowserImpl
extends ExtBrowserImpl {
    public MacBrowserImpl(ExtWebBrowser extBrowserFactory) {
        this.extBrowserFactory = extBrowserFactory;
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "MacBrowserImpl created from factory: " + extBrowserFactory);
        }
    }

    @Override
    protected void loadURLInBrowser(URL url) {
        if (url == null) {
            return;
        }
        try {
            url = URLUtil.createExternalURL(url, false);
            URI uri = url.toURI();
            NbProcessDescriptor np = this.extBrowserFactory.getBrowserExecutable();
            if (np != null) {
                np.exec((Format)((Object)new SimpleExtBrowser.BrowserFormat(uri == null ? "" : uri.toASCIIString())));
            }
        }
        catch (URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            MacBrowserImpl.logInfo(ex);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MacBrowserImpl.class, (String)"EXC_Invalid_Processor"), -1, 2));
        }
    }

    private static void logInfo(Exception ex) {
        Logger logger = Logger.getLogger(MacBrowserImpl.class.getName());
        logger.log(Level.INFO, null, ex);
    }

    @Override
    protected BrowserFamilyId getDefaultBrowserFamilyId() {
        BrowserFamilyId pluginId = super.getDefaultBrowserFamilyId();
        if (pluginId != BrowserFamilyId.UNKNOWN) {
            return pluginId;
        }
        String defaultApps = this.getDefaultApps();
        if (pluginId == null || pluginId == BrowserFamilyId.UNKNOWN) {
            pluginId = this.parseDefaultApps(defaultApps, "LSHandlerContentType", "public.url");
            if (pluginId == null) {
                pluginId = BrowserFamilyId.UNKNOWN;
            }
            return pluginId;
        }
        return pluginId;
    }

    private BrowserFamilyId parseDefaultApps(String defaultApps, String key, String value) {
        if (defaultApps == null) {
            return null;
        }
        int index = 0;
        while (true) {
            if ((index = defaultApps.indexOf(value, index)) == -1) {
                return null;
            }
            int lBrace = defaultApps.substring(0, index).lastIndexOf(123);
            int rBrace = defaultApps.indexOf(125, index);
            if (lBrace == -1 || rBrace == -1) {
                return null;
            }
            int valueIndex = defaultApps.indexOf(key, lBrace);
            if (valueIndex == -1 || valueIndex >= index) continue;
            int chromeIndex = defaultApps.indexOf("chrome", lBrace);
            if (chromeIndex < rBrace) {
                return BrowserFamilyId.CHROME;
            }
            int firefoxIndex = defaultApps.indexOf("firefox", lBrace);
            if (firefoxIndex < rBrace) break;
        }
        return BrowserFamilyId.FIREFOX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultApps() {
        BufferedReader reader = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec("defaults read com.apple.LaunchServices");
            process.waitFor();
            InputStream inputStream = process.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                builder.append(line);
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception ex) {
            Logger.getLogger(MacBrowserImpl.class.getCanonicalName()).log(Level.INFO, "Unable to run process: 'defaults read com.apple.LaunchServices'", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(MacBrowserImpl.class.getCanonicalName()).log(Level.INFO, "Unable close process input stream reader ", ex);
                }
            }
        }
        return null;
    }
}

