/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.plugins.ExtensionManager;
import org.netbeans.modules.extbrowser.plugins.ExternalBrowserPlugin;
import org.netbeans.modules.extbrowser.plugins.MessageDispatcherImpl;
import org.netbeans.modules.extbrowser.plugins.PageInspectionHandleImpl;
import org.netbeans.modules.extbrowser.plugins.RemoteScriptExecutor;
import org.netbeans.modules.extbrowser.plugins.chrome.WebKitDebuggingTransport;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.modules.web.webkit.debugging.spi.Factory;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class ExtBrowserImpl
extends HtmlBrowser.Impl
implements EnhancedBrowser {
    private Lookup lookup;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport((Object)this);
    private URL url;
    protected String title = "";
    protected ExtWebBrowser extBrowserFactory;
    private ExternalBrowserPlugin.BrowserTabDescriptor browserTabDescriptor = null;
    private boolean enhancedMode;
    private boolean disablePageInspector = false;
    private boolean liveHTMLEnabled = false;
    private boolean running = false;
    private Lookup projectContext;

    public boolean hasEnhancedMode() {
        return this.enhancedMode;
    }

    public void setEnhancedMode(boolean mode) {
        this.enhancedMode = mode;
    }

    public void disablePageInspector() {
        this.disablePageInspector = true;
    }

    public void enableLiveHTML() {
        this.liveHTMLEnabled = true;
    }

    public boolean isDisablePageInspector() {
        return this.disablePageInspector;
    }

    public boolean isLiveHTMLEnabled() {
        return this.liveHTMLEnabled;
    }

    private Lookup createLookup() {
        BrowserFamilyId id;
        ArrayList<Lookup> lookups = new ArrayList<Lookup>();
        lookups.add(Lookups.fixed((Object[])new Object[]{new MessageDispatcherImpl(), new RemoteScriptExecutor(this), new PageInspectionHandleImpl(this)}));
        if (this.hasEnhancedMode() && ((id = this.extBrowserFactory.getBrowserFamilyId()) == BrowserFamilyId.CHROME || id == BrowserFamilyId.CHROMIUM)) {
            WebKitDebuggingTransport transport = new WebKitDebuggingTransport(this);
            lookups.add(Lookups.fixed((Object[])new Object[]{transport, Factory.createWebKitDebugging((TransportImplementation)transport)}));
        }
        return new ProxyLookup(lookups.toArray(new Lookup[lookups.size()]));
    }

    protected BrowserFamilyId getDefaultBrowserFamilyId() {
        return BrowserFamilyId.UNKNOWN;
    }

    public boolean isBackward() {
        return false;
    }

    public boolean isForward() {
        return false;
    }

    public void backward() {
    }

    public void forward() {
    }

    public boolean isHistory() {
        return false;
    }

    public void showHistory() {
    }

    public void stopLoading() {
    }

    protected void setTitle(String title) {
    }

    public String getTitle() {
        return "";
    }

    public String getStatusMessage() {
        return "";
    }

    public void reloadDocument() {
        if (this.url == null) {
            return;
        }
        if (this.hasEnhancedMode()) {
            ExternalBrowserPlugin.BrowserTabDescriptor tab = this.getBrowserTabDescriptor();
            if (tab != null) {
                ExternalBrowserPlugin.getInstance().showURLInTab(tab, this.url);
            }
        } else {
            this.setURL(this.url);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void close(boolean closeTab) {
        ExternalBrowserPlugin.BrowserTabDescriptor tab;
        if (this.hasEnhancedMode() && (tab = this.getBrowserTabDescriptor()) != null) {
            ExternalBrowserPlugin.getInstance().close(tab, closeTab);
        }
    }

    public void setProjectContext(Lookup projectContext) {
        this.projectContext = projectContext;
    }

    public Lookup getProjectContext() {
        return this.projectContext;
    }

    public final void setURL(URL url) {
        if (this.hasEnhancedMode()) {
            ExternalBrowserPlugin.BrowserTabDescriptor tab = this.getBrowserTabDescriptor();
            if (tab == null) {
                BrowserFamilyId pluginId = this.extBrowserFactory.getBrowserFamilyId();
                ExtensionManager.ExtensitionStatus status = ExtensionManager.isInstalled(pluginId);
                boolean browserPluginAvailable = true;
                if (status == ExtensionManager.ExtensitionStatus.DISABLED) {
                    browserPluginAvailable = false;
                } else if (status == ExtensionManager.ExtensitionStatus.MISSING || status == ExtensionManager.ExtensitionStatus.NEEDS_UPGRADE) {
                    browserPluginAvailable = ExtensionManager.installExtension(pluginId, status);
                }
                if (browserPluginAvailable) {
                    if (ExternalBrowserPlugin.getInstance().isServerRunning()) {
                        URL tempUrl = this.createBlankHTMLPage();
                        assert (tempUrl != null);
                        ExternalBrowserPlugin.getInstance().register(tempUrl, url, this);
                        this.loadURLInBrowser(tempUrl);
                    } else {
                        this.loadURLInBrowser(url);
                    }
                }
            } else {
                ExternalBrowserPlugin.getInstance().showURLInTab(tab, url);
            }
        } else {
            this.loadURLInBrowser(url);
        }
        this.url = url;
    }

    private URL createBlankHTMLPage() {
        try {
            File f = File.createTempFile("blank", ".html");
            FileWriter fw = new FileWriter(f);
            fw.write("<html :netbeans_temporary=\"true\"></html>");
            fw.close();
            return f.toURI().toURL();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    protected abstract void loadURLInBrowser(URL var1);

    public final Component getComponent() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public final Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    public void wasClosed() {
        this.setBrowserTabDescriptor(null);
        this.url = null;
        this.pcs.firePropertyChange("browser.was.closed", null, null);
    }

    public synchronized ExternalBrowserPlugin.BrowserTabDescriptor getBrowserTabDescriptor() {
        return this.browserTabDescriptor;
    }

    public synchronized void setBrowserTabDescriptor(ExternalBrowserPlugin.BrowserTabDescriptor browserTabDescriptor) {
        this.browserTabDescriptor = browserTabDescriptor;
    }

    public void urlHasChanged() {
        this.pcs.firePropertyChange("url", null, null);
    }
}

