/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.FirefoxBrowser;
import org.netbeans.modules.extbrowser.UnixBrowserImpl;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ChromiumBrowser
extends ExtWebBrowser
implements PropertyChangeListener {
    private static final long serialVersionUID = -2700536003661091286L;
    private static final String CHROMIUM_PATH = "/usr/bin/chromium-browser";

    public ChromiumBrowser() {
        this.ddeServer = "CHROMIUM";
    }

    public static Boolean isHidden() {
        File file;
        if (Utilities.isUnix() && !Utilities.isMac() && (file = new File(CHROMIUM_PATH)).exists() && file.canExecute()) {
            return Boolean.FALSE;
        }
        return true;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getMessage(ChromiumBrowser.class, (String)"CTL_ChromiumBrowserName");
        }
        return this.name;
    }

    @Override
    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        UnixBrowserImpl impl = null;
        if (!Utilities.isUnix() || Utilities.isMac()) {
            throw new UnsupportedOperationException(NbBundle.getMessage(FirefoxBrowser.class, (String)"MSG_CannotUseBrowser"));
        }
        impl = new UnixBrowserImpl(this);
        return impl;
    }

    @Override
    protected NbProcessDescriptor defaultBrowserExecutable() {
        File file;
        if (Utilities.isUnix() && !Utilities.isMac() && (file = new File(CHROMIUM_PATH)).exists()) {
            return new NbProcessDescriptor(file.getAbsolutePath(), "{URL}", NbBundle.getMessage(ChromiumBrowser.class, (String)"MSG_BrowserExecutorHint"));
        }
        return null;
    }

    @Override
    public BrowserFamilyId getBrowserFamilyId() {
        return BrowserFamilyId.CHROMIUM;
    }
}

