/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.netbeans.modules.extbrowser.FirefoxBrowser;
import org.netbeans.modules.extbrowser.MacBrowserImpl;
import org.netbeans.modules.extbrowser.NbBrowserException;
import org.netbeans.modules.extbrowser.NbDdeBrowserImpl;
import org.netbeans.modules.extbrowser.UnixBrowserImpl;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ChromeBrowser
extends ExtWebBrowser
implements PropertyChangeListener {
    private static final long serialVersionUID = -4553174676787993831L;

    public ChromeBrowser() {
        this.ddeServer = "CHROME";
    }

    public static Boolean isHidden() {
        String detectedPath = null;
        if (Utilities.isWindows()) {
            detectedPath = ChromeBrowser.getLocalAppPath().getPath();
            try {
                if (detectedPath == null) {
                    detectedPath = NbDdeBrowserImpl.getBrowserPath("chrome");
                }
            }
            catch (NbBrowserException e) {
                ExtWebBrowser.getEM().log(Level.INFO, "Cannot detect chrome : " + e);
            }
            if (detectedPath != null && detectedPath.trim().length() > 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = NbBundle.getMessage(ChromeBrowser.class, (String)"CTL_ChromeBrowserName");
        }
        return this.name;
    }

    @Override
    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        ExtBrowserImpl impl = null;
        if (Utilities.isWindows()) {
            impl = new NbDdeBrowserImpl(this);
        } else if (Utilities.isMac()) {
            impl = new MacBrowserImpl(this);
        } else if (Utilities.isUnix() && !Utilities.isMac()) {
            impl = new UnixBrowserImpl(this);
        } else {
            throw new UnsupportedOperationException(NbBundle.getMessage(FirefoxBrowser.class, (String)"MSG_CannotUseBrowser"));
        }
        return impl;
    }

    @Override
    protected NbProcessDescriptor defaultBrowserExecutable() {
        NbProcessDescriptor retValue;
        block14: {
            String b = "";
            String params = "";
            retValue = null;
            if (Utilities.isWindows()) {
                params = params + "{URL}";
                File file = ChromeBrowser.getLocalAppPath();
                if (file.exists() && file.canExecute()) {
                    this.setDDEServer("CHROME");
                    return new NbProcessDescriptor(file.getPath(), params);
                }
                try {
                    try {
                        b = NbDdeBrowserImpl.getBrowserPath("chrome");
                        if (b != null && b.trim().length() > 0) {
                            this.setDDEServer("CHROME");
                            return new NbProcessDescriptor(b, params);
                        }
                        break block14;
                    }
                    catch (NbBrowserException e) {
                        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
                            ExtWebBrowser.getEM().log(Level.FINE, "Cannot get Path for Chrome: " + e);
                        }
                        break block14;
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
                        ExtWebBrowser.getEM().log(Level.FINE, "Some problem here:" + e);
                    }
                    break block14;
                }
            }
            if (Utilities.isMac()) {
                params = params + "-b com.google.chrome {URL}";
                retValue = new NbProcessDescriptor("/usr/bin/open", params, ExtWebBrowser.UnixBrowserFormat.getHint());
                return retValue;
            }
            boolean found = false;
            b = "chrome";
            File f = new File("/opt/google/chrome/chrome");
            if (f.exists()) {
                found = true;
                b = f.getAbsolutePath();
            }
            f = new File("/opt/google/chrome/google-chrome");
            if (!found && f.exists()) {
                found = true;
                b = f.getAbsolutePath();
            }
            f = new File("/usr/bin/google-chrome");
            if (!found && f.exists()) {
                found = true;
                b = f.getAbsolutePath();
            }
            f = new File("/usr/local/bin/google-chrome");
            if (!found && f.exists()) {
                found = true;
                b = f.getAbsolutePath();
            }
            retValue = new NbProcessDescriptor(b, "{URL}", NbBundle.getMessage(ChromeBrowser.class, (String)"MSG_BrowserExecutorHint"));
        }
        return retValue;
    }

    @Override
    public BrowserFamilyId getBrowserFamilyId() {
        return BrowserFamilyId.CHROME;
    }

    private static File getLocalAppPath() {
        String localFiles = System.getenv("LOCALAPPDATA");
        String chrome = localFiles + "\\Google\\Chrome\\Application\\chrome.exe";
        return new File(chrome);
    }
}

