/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.netbeans.junit.NbTestCase;

final class MethodOrder {
    private static final List<Method[]> allDeclaredMethods = new LinkedList<Method[]>();
    private static final String DEFAULT_METHOD_ORDER = "natural";
    private static Long shuffleSeed;

    MethodOrder() {
    }

    static void initialize() {
        String orderS = MethodOrder.findOrder();
        if (!DEFAULT_METHOD_ORDER.equals(orderS)) {
            try {
                Field classesF = ClassLoader.class.getDeclaredField("classes");
                classesF.setAccessible(true);
                ArrayList classes = new ArrayList((Collection)classesF.get(NbTestCase.class.getClassLoader()));
                for (Class c : classes) {
                    if (!NbTestCase.class.isAssignableFrom(c) || c == NbTestCase.class) continue;
                    MethodOrder.orderMethods(c, orderS);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    static void orderMethods(Class<?> c, String orderS) throws Exception {
        if (orderS == null) {
            orderS = MethodOrder.findOrder();
        }
        if (DEFAULT_METHOD_ORDER.equals(orderS)) {
            return;
        }
        Field declaredMethodsF = Class.class.getDeclaredField("declaredMethods");
        declaredMethodsF.setAccessible(true);
        Method[] ms = null;
        while (ms == null) {
            c.getDeclaredMethods();
            ms = (Method[])((Reference)declaredMethodsF.get(c)).get();
        }
        allDeclaredMethods.add(ms);
        if (orderS.equals("a-z")) {
            MethodOrder.abcSort(ms, true);
        } else if (orderS.equals("z-a")) {
            MethodOrder.abcSort(ms, false);
        } else if (orderS.equals("shuffle")) {
            if (shuffleSeed == null) {
                shuffleSeed = System.currentTimeMillis();
            }
            MethodOrder.shuffle(ms, shuffleSeed);
        } else {
            try {
                long seed = Long.parseLong(orderS);
                MethodOrder.shuffle(ms, seed);
            }
            catch (NumberFormatException ex) {
                throw new Exception("Specify -DNbTestCase.order=a-z or =z-a or =shuffle or =<number>");
            }
        }
    }

    private static void abcSort(Method[] ms, boolean asscending) {
        final int multi = asscending ? 1 : -1;
        Arrays.sort(ms, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return multi * m1.toString().compareTo(m2.toString());
            }
        });
    }

    private static void shuffle(Method[] arr, long seed) {
        MethodOrder.abcSort(arr, true);
        Random r = new Random(seed);
        for (int i = 0; i < arr.length; ++i) {
            int from = i + r.nextInt(arr.length - i);
            if (i == from) continue;
            Method m = arr[i];
            arr[i] = arr[from];
            arr[from] = m;
        }
    }

    private static String findOrder() {
        String orderS = System.getProperty("NbTestCase.order");
        if (orderS == null) {
            orderS = DEFAULT_METHOD_ORDER;
        }
        return orderS;
    }

    static boolean isShuffled() {
        return shuffleSeed != null;
    }

    static long getSeed() {
        assert (shuffleSeed != null);
        return shuffleSeed;
    }
}

