/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.newproject;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.ide.ergonomics.ServerWizardProviderProxy;
import org.netbeans.modules.ide.ergonomics.fod.ConfigurationPanel;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.netbeans.modules.ide.ergonomics.fod.ModulesInstaller;
import org.netbeans.modules.ide.ergonomics.newproject.ContentPanel;
import org.netbeans.modules.ide.ergonomics.newproject.FeatureOnDemandWizardIterator;
import org.netbeans.spi.server.ServerWizardProvider;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DescriptionStep
implements WizardDescriptor.Panel<WizardDescriptor>,
Runnable {
    private ContentPanel panel;
    private ProgressHandle handle = null;
    private Collection<UpdateElement> forEnable = null;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static FindComponentModules finder = null;
    private FeatureInfo info;
    private WizardDescriptor wd;
    private ConfigurationPanel configPanel;
    private final boolean autoEnable;
    private PresentModules findModules = new PresentModules();

    public DescriptionStep(boolean autoEnable) {
        this.autoEnable = autoEnable;
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.configPanel = new ConfigurationPanel(new Callable<JComponent>(){

                @Override
                public JComponent call() throws Exception {
                    FoDLayersProvider.getInstance().refreshForce();
                    DescriptionStep.this.waitForDelegateWizard();
                    return new JLabel(" ");
                }
            }, (Boolean)this.autoEnable);
            this.panel = new ContentPanel(DescriptionStep.getBundle("DescriptionPanel_Name", new Object[0]));
            this.panel.addPropertyChangeListener(this.findModules);
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        return false;
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        Mutex.EVENT.readAccess((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<ChangeListener> templist;
        DescriptionStep descriptionStep = this;
        synchronized (descriptionStep) {
            templist = new ArrayList<ChangeListener>(this.listeners);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : templist) {
            l.stateChanged(e);
        }
    }

    private void presentModulesForActivation() {
        this.forEnable = this.getFinder().getModulesForEnable();
        this.presentModulesForEnable();
    }

    private void presentModulesForEnable() {
        Collection<UpdateElement> elems;
        if (this.handle != null) {
            this.handle.finish();
            this.panel.replaceComponents(new JComponent[0]);
            this.handle = null;
        }
        if ((elems = this.getFinder().getModulesForEnable()) != null && !elems.isEmpty()) {
            Collection<UpdateElement> visible = this.getFinder().getVisibleUpdateElements(elems);
            String name = ModulesInstaller.presentUpdateElements(visible);
            this.configPanel.setInfo(this.info);
            this.configPanel.setPanelName(name);
            this.panel.replaceComponents(this.configPanel);
            this.forEnable = elems;
            this.fireChange();
        } else {
            FoDLayersProvider.getInstance().refreshForce();
            this.waitForDelegateWizard();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DescriptionStep.this.waitForDelegateWizard();
                    DescriptionStep.this.fireChange();
                }
            });
        }
    }

    private FindComponentModules getFinder() {
        assert (finder != null) : "Finder needs to be created first!";
        return finder;
    }

    private static String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(DescriptionStep.class, (String)key, (Object[])params);
    }

    public void readSettings(WizardDescriptor settings) {
        this.wd = settings;
        Object o = settings.getProperty("chosen-template");
        assert (o != null && o instanceof FileObject) : o + " is not null and instanceof FileObject.";
        FileObject fileObject = (FileObject)o;
        this.info = FoDLayersProvider.getInstance().whichProvides(fileObject);
        assert (this.info != null) : "No info for " + fileObject;
        finder = new FindComponentModules(this.info, new FeatureInfo[0]);
    }

    public void storeSettings(WizardDescriptor settings) {
        if (this.forEnable != null && !this.forEnable.isEmpty()) {
            settings.putProperty("chosen-elements-for-enable", this.forEnable);
            this.fireChange();
        }
    }

    private void waitForDelegateWizard() {
        Object o = this.wd.getProperty("chosen-template");
        assert (o != null && o instanceof FileObject) : o + " is not null and instanceof FileObject";
        String templateResource = ((FileObject)o).getPath();
        FileObject fo = null;
        WizardDescriptor.InstantiatingIterator iterator = null;
        int i = 0;
        while (fo == null || iterator == null) {
            block19: {
                try {
                    FoDLayersProvider.getInstance().refreshForce();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (templateResource.startsWith("Servers/WizardProvider")) {
                    try {
                        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                        Class<?> clazz = Class.forName("org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory", true, loader);
                        Collection c = Lookups.forPath((String)("J2EE/DeploymentPlugins/" + templateResource.substring(templateResource.indexOf(45) + 1, templateResource.indexOf(46)) + "/")).lookupAll(clazz);
                        if (!c.isEmpty()) {
                            Object optFactory = c.iterator().next();
                            Method m = optFactory.getClass().getMethod("getAddInstanceIterator", new Class[0]);
                            iterator = (WizardDescriptor.InstantiatingIterator)m.invoke(optFactory, new Object[0]);
                            fo = (FileObject)o;
                        }
                        break block19;
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        break;
                    }
                }
                if (templateResource.startsWith("Cloud/WizardProvider")) {
                    String resource = "Cloud/" + templateResource.substring(templateResource.indexOf(45) + 1);
                    fo = FileUtil.getConfigFile((String)resource);
                    try {
                        if (fo != null) {
                            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                            Object oo = ((InstanceCookie)DataObject.find((FileObject)fo).getCookie(InstanceCookie.class)).instanceCreate();
                            if (oo instanceof ServerWizardProvider && ServerWizardProviderProxy.isReal((ServerWizardProvider)oo)) {
                                iterator = ((ServerWizardProvider)oo).getInstantiatingIterator();
                            }
                        }
                        break block19;
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        break;
                    }
                }
                fo = FileUtil.getConfigFile((String)templateResource);
                iterator = DescriptionStep.readWizard(fo);
            }
            if (!(iterator instanceof FeatureOnDemandWizardIterator)) continue;
            Logger LOG = Logger.getLogger(DescriptionStep.class.getName());
            LOG.warning("There is still wrong iterator " + iterator.getClass().getName() + " for file object " + fo);
            FeatureManager.dumpModules(Level.INFO, Level.INFO);
            iterator = null;
            if (++i == 10) {
                Logger.getLogger(DescriptionStep.class.getName()).severe("Giving up to find iterator for " + fo);
                Logger.getLogger(DescriptionStep.class.getName()).severe(DescriptionStep.threadDump());
                boolean npe = false;
                if (!$assertionsDisabled) {
                    npe = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (npe) {
                    throw new NullPointerException("No iterator for " + fo);
                }
                return;
            }
            LOG.info("Forcing refresh");
            FoDLayersProvider.getInstance().refreshForce();
            LOG.info("Done with refresh");
            FileObject fake = FileUtil.getConfigFile((String)templateResource);
            if (fake == null) {
                LOG.warning("no " + templateResource + " on FoD: " + fake);
                for (FileObject p = fo; p != null; p = p.getParent()) {
                    LOG.info("  parent: " + p + " children: " + Arrays.asList(p.getChildren()));
                }
                continue;
            }
            LOG.info("fake found " + fake);
            LOG.info("its wizard is " + DescriptionStep.readWizard(fake));
        }
        iterator.initialize(this.wd);
        this.wd.putProperty("delegate-iterator", iterator);
        this.fireChange();
    }

    public static WizardDescriptor.InstantiatingIterator<?> readWizard(FileObject fo) {
        Object twi;
        if (fo == null || !fo.isValid()) {
            return null;
        }
        Object o = fo.getAttribute("instantiatingIterator");
        if ((o == null || o instanceof FeatureOnDemandWizardIterator) && (twi = fo.getAttribute("templateWizardIterator")) != null) {
            o = twi;
        }
        if (!(o instanceof WizardDescriptor.InstantiatingIterator) && o instanceof TemplateWizard.Iterator) {
            final TemplateWizard.Iterator it = (TemplateWizard.Iterator)o;
            o = new WizardDescriptor.InstantiatingIterator<WizardDescriptor>(){
                private TemplateWizard tw;

                public Set instantiate() throws IOException {
                    return it.instantiate(this.tw);
                }

                public void initialize(WizardDescriptor wizard) {
                    this.tw = (TemplateWizard)wizard;
                    try {
                        FileObject real = this.tw.getTemplate().getPrimaryFile();
                        if (!real.isValid()) {
                            real = FileUtil.getConfigFile((String)real.getPath());
                        }
                        this.tw.setTemplate(DataObject.find((FileObject)real));
                        it.initialize(this.tw);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Logger.getLogger(DescriptionStep.class.getName()).severe(ex.toString());
                    }
                }

                public void uninitialize(WizardDescriptor wizard) {
                    it.uninitialize((TemplateWizard)wizard);
                    this.tw = null;
                }

                public WizardDescriptor.Panel<WizardDescriptor> current() {
                    return it.current();
                }

                public String name() {
                    return it.name();
                }

                public boolean hasNext() {
                    return it.hasNext();
                }

                public boolean hasPrevious() {
                    return it.hasPrevious();
                }

                public void nextPanel() {
                    it.nextPanel();
                }

                public void previousPanel() {
                    it.previousPanel();
                }

                public void addChangeListener(ChangeListener l) {
                    it.addChangeListener(l);
                }

                public void removeChangeListener(ChangeListener l) {
                    it.removeChangeListener(l);
                }
            };
        }
        assert (o != null && o instanceof WizardDescriptor.InstantiatingIterator) : o + " is not null and instanceof WizardDescriptor.InstantiatingIterator";
        return (WizardDescriptor.InstantiatingIterator)o;
    }

    private static String threadDump() {
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        sb.append("Thread dump:\n");
        for (Map.Entry<Thread, StackTraceElement[]> entry : all.entrySet()) {
            sb.append(entry.getKey().getName()).append('\n');
            if (entry.getValue() == null) {
                sb.append("  no information\n");
                continue;
            }
            for (StackTraceElement stackTraceElement : entry.getValue()) {
                sb.append("  ");
                sb.append(stackTraceElement.getClassName()).append('.');
                sb.append(stackTraceElement.getMethodName()).append(':');
                sb.append(stackTraceElement.getLineNumber()).append('\n');
            }
        }
        return sb.toString();
    }

    private class PresentModules
    implements Runnable,
    PropertyChangeListener {
        private PresentModules() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ContentPanel.FINDING_MODULES.equals(evt.getPropertyName())) {
                FeatureManager.getInstance().create(this).schedule(0);
            }
        }

        @Override
        public void run() {
            assert (!SwingUtilities.isEventDispatchThread());
            DescriptionStep.this.presentModulesForActivation();
        }
    }
}

