/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.editor.completion.WSCompletionItem;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class WSCompletionProvider
implements CompletionProvider {
    private static Logger LOG = Logger.getLogger(WSCompletionProvider.class.getCanonicalName().toString());
    private static final String[] BINDING_TYPES = new String[]{"SOAPBinding.SOAP11HTTP_BINDING", "SOAPBinding.SOAP11HTTP_MTOM_BINDING", "SOAPBinding.SOAP12HTTP_BINDING", "SOAPBinding.SOAP12HTTP_MTOM_BINDING", "HTTPBinding.HTTP_BINDING"};

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new WsCompletionQuery(component.getSelectionStart()), component);
        }
        return null;
    }

    static final class WsCompletionQuery
    extends AsyncCompletionQuery
    implements CancellableTask<CompilationController> {
        private int caretOffset;
        private int anchorOffset;
        private List<CompletionItem> results;
        private JTextComponent component;
        private JAXWSSupport jaxWsSupport;
        private volatile boolean hasErrors;
        private RequestProcessor REQUEST_PROCESSOR = new RequestProcessor(WsCompletionQuery.class);

        private WsCompletionQuery(int caretOffset) {
            this.caretOffset = caretOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                NbEditorUtilities.getFileObject((Document)doc);
                JavaSource js = JavaSource.forDocument((Document)doc);
                if (js != null) {
                    js.runUserActionTask((Task)this, true);
                    if (this.isTaskCancelled()) {
                        return;
                    }
                    if (this.results != null) {
                        resultSet.addAllItems(this.results);
                    }
                    if (this.anchorOffset > -1) {
                        resultSet.setAnchorOffset(this.anchorOffset);
                    }
                }
            }
            catch (CancellationException e) {
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
            finally {
                resultSet.finish();
            }
        }

        public void cancel() {
        }

        public void run(CompilationController controller) throws Exception {
            this.resolveCompletion(controller);
        }

        private void resolveCompletion(CompilationController controller) throws IOException {
            if (this.isTaskCancelled()) {
                return;
            }
            controller.toPhase(JavaSource.Phase.PARSED);
            this.results = new ArrayList<CompletionItem>();
            Env env = this.getCompletionEnvironment(controller, true);
            this.anchorOffset = env.getOffset();
            TreePath path = env.getPath();
            switch (path.getLeaf().getKind()) {
                case ANNOTATION: {
                    break;
                }
                case STRING_LITERAL: {
                    this.createStringResults(controller, env);
                    break;
                }
                case ASSIGNMENT: {
                    this.createAssignmentResults(controller, env);
                    break;
                }
            }
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
            FileObject fo = NbEditorUtilities.getFileObject((Document)component.getDocument());
            if (fo != null) {
                this.jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)fo);
            }
        }

        private Env getCompletionEnvironment(CompilationController controller, boolean upToOffset) throws IOException {
            int offset = this.caretOffset;
            String prefix = "";
            if (upToOffset && offset > 0) {
                TokenSequence ts = controller.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                boolean successfullyMoved = false;
                successfullyMoved = ts.move(offset) == 0 ? ts.movePrevious() : ts.moveNext();
                if (successfullyMoved && ts.offset() < offset) {
                    String token = ((Object)ts.token().text()).toString();
                    int length = Math.min(offset - ts.offset(), token.length());
                    prefix = token.substring(0, length);
                    offset = ts.offset();
                    if (ts.token().id() == JavaTokenId.STRING_LITERAL && prefix.startsWith("\"")) {
                        prefix = prefix.substring(1);
                        ++offset;
                    } else if (ts.token().id() == JavaTokenId.EQ && prefix.startsWith("=")) {
                        prefix = prefix.substring(1);
                        ++offset;
                    }
                }
            }
            controller.toPhase(JavaSource.Phase.PARSED);
            TreePath path = controller.getTreeUtilities().pathFor(this.caretOffset);
            return new Env(offset, prefix, path);
        }

        private boolean hasErrors() {
            return this.hasErrors;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void createStringResults(CompilationController controller, Env env) throws IOException {
            TreePath elementPath = env.getPath();
            TreePath parentPath = elementPath.getParentPath();
            Tree parent = parentPath.getLeaf();
            Tree grandParent = parentPath.getParentPath().getLeaf();
            switch (grandParent.getKind()) {
                case ANNOTATION: {
                    switch (parent.getKind()) {
                        case ASSIGNMENT: {
                            FileObject wsdlFolder;
                            ExpressionTree var = ((AssignmentTree)parent).getVariable();
                            if (var.getKind() != Tree.Kind.IDENTIFIER) return;
                            Name name = ((IdentifierTree)var).getName();
                            if (!name.contentEquals("wsdlLocation") || this.jaxWsSupport == null) {
                                return;
                            }
                            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TypeElement webMethodEl = controller.getElements().getTypeElement("javax.jws.WebService");
                            if (webMethodEl == null) {
                                this.hasErrors = true;
                                return;
                            }
                            TypeMirror el = controller.getTrees().getTypeMirror(parentPath.getParentPath());
                            if (el == null || el.getKind() == TypeKind.ERROR) {
                                this.hasErrors = true;
                                return;
                            }
                            if (!controller.getTypes().isSameType(el, webMethodEl.asType()) || (wsdlFolder = this.jaxWsSupport.getWsdlFolder(false)) == null) return;
                            Enumeration en = wsdlFolder.getChildren(true);
                            while (en.hasMoreElements()) {
                                FileObject fo = (FileObject)en.nextElement();
                                if (!fo.isData() || !"wsdl".equalsIgnoreCase(fo.getExt())) continue;
                                String wsdlPath = FileUtil.getRelativePath((FileObject)wsdlFolder.getParent().getParent(), (FileObject)fo);
                                if (wsdlPath.startsWith("conf/")) {
                                    wsdlPath = "META-INF/" + wsdlPath.substring(5);
                                }
                                if (!wsdlPath.startsWith(env.getPrefix())) continue;
                                this.results.add(WSCompletionItem.createWsdlFileItem(wsdlFolder, fo, env.getOffset()));
                            }
                            return;
                        }
                    }
                    return;
                }
            }
        }

        private void createAssignmentResults(CompilationController controller, Env env) throws IOException {
            TreePath elementPath = env.getPath();
            TreePath parentPath = elementPath.getParentPath();
            Tree parent = parentPath.getLeaf();
            switch (parent.getKind()) {
                case ANNOTATION: {
                    Name name;
                    ExpressionTree var = ((AssignmentTree)elementPath.getLeaf()).getVariable();
                    if (var == null || var.getKind() != Tree.Kind.IDENTIFIER || !(name = ((IdentifierTree)var).getName()).contentEquals("value")) break;
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement webParamEl = controller.getElements().getTypeElement("javax.xml.ws.BindingType");
                    if (webParamEl == null) {
                        this.hasErrors = true;
                        return;
                    }
                    TypeMirror el = controller.getTrees().getTypeMirror(parentPath);
                    if (el == null || el.getKind() == TypeKind.ERROR) {
                        this.hasErrors = true;
                        return;
                    }
                    if (!controller.getTypes().isSameType(el, webParamEl.asType())) break;
                    for (String mode : BINDING_TYPES) {
                        if (!mode.startsWith(env.getPrefix())) continue;
                        this.results.add(WSCompletionItem.createEnumItem(mode, "String", env.getOffset()));
                    }
                    break;
                }
            }
        }

        private static class Env {
            private int offset;
            private String prefix;
            private TreePath path;

            private Env(int offset, String prefix, TreePath path) {
                this.offset = offset;
                this.prefix = prefix;
                this.path = path;
            }

            public int getOffset() {
                return this.offset;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public TreePath getPath() {
                return this.path;
            }
        }
    }
}

