/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ProjectInfo;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsInvokeOperation;
import org.netbeans.modules.websvc.spi.support.InvokeOperationActionProvider;
import org.openide.filesystems.FileObject;

public class JaxWsInvokeOperationProvider
implements InvokeOperationActionProvider {
    public InvokeOperationCookie getInvokeOperationCookie(FileObject targetSource) {
        if (JAXWSClientSupport.getJaxWsClientSupport((FileObject)targetSource) != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)targetSource);
            ProjectInfo projectInfo = new ProjectInfo(project);
            int projectType = projectInfo.getProjectType();
            if (projectType == 0 && !this.isJAXRPCProject(project) && !this.isJAXWSProject(project) || projectType == 0 && this.isJAXWSProject(project) && this.isJaxWsLibraryOnClasspath(targetSource) || Util.isJavaEE5orHigher((Project)project) && (projectType == 1 || projectType == 3 || projectType == 2)) {
                return new JaxWsInvokeOperation(targetSource);
            }
            if (JaxWsUtils.isEjbJavaEE5orHigher(projectInfo)) {
                return new JaxWsInvokeOperation(targetSource);
            }
            if (projectType == 1 && !Util.isJavaEE5orHigher((Project)project) && this.isJaxWsLibraryOnRuntimeClasspath(targetSource)) {
                return new JaxWsInvokeOperation(targetSource);
            }
        }
        return null;
    }

    private boolean isJaxWsLibraryOnRuntimeClasspath(FileObject targetSource) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)targetSource, (String)"classpath/execute");
        return classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null && classPath.findResource("javax/xml/rpc/Service.class") == null;
    }

    private boolean isJAXRPCProject(Project project) {
        ClassPath classPath;
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject wscompileFO = null;
        if (sgs.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile")) != null) {
            wscompileFO = classPath.findResource("com/sun/xml/rpc/tools/ant/Wscompile.class");
        }
        return wscompileFO != null;
    }

    private boolean isJAXWSProject(Project project) {
        ClassPath classPath;
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        FileObject wsimportFO = null;
        if (sgs.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile")) != null) {
            wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        }
        return wsimportFO != null;
    }

    private boolean isJaxWsLibraryOnClasspath(FileObject targetSource) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)targetSource, (String)"classpath/compile");
        if (classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null) {
            return true;
        }
        classPath = ClassPath.getClassPath((FileObject)targetSource, (String)"classpath/boot");
        return classPath != null && classPath.findResource("javax/xml/ws/Service.class") != null;
    }
}

