/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.util;

import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public final class UsageLogging {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.hudson");
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.hudson");

    private UsageLogging() {
    }

    public static void logUI(ResourceBundle bundle, String message, Object ... params) {
        assert (bundle != null);
        assert (message != null);
        LogRecord logRecord = UsageLogging.createLogRecord(bundle, message, params);
        logRecord.setLoggerName(UI_LOGGER.getName());
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class<?> srcClass, String message, Object ... params) {
        assert (srcClass != null);
        assert (message != null);
        LogRecord logRecord = UsageLogging.createLogRecord(NbBundle.getBundle(srcClass), message, params);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        USG_LOGGER.log(logRecord);
    }

    private static LogRecord createLogRecord(ResourceBundle bundle, String message, Object ... params) {
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setResourceBundle(bundle);
        if (params != null) {
            logRecord.setParameters(params);
        }
        return logRecord;
    }
}

