/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.ui.nodes.Bundle;
import org.netbeans.modules.hudson.ui.nodes.HudsonJobNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

public class HudsonInstanceNode
extends AbstractNode {
    private static final String ICON_BASE = "org/netbeans/modules/hudson/ui/resources/instance.png";
    private HudsonInstanceImpl instance;
    private InstanceNodeChildren children;
    private boolean warn = false;
    private boolean run = false;
    private boolean alive = false;
    private boolean forbidden;
    private boolean version = false;
    public static final String SELECTED_VIEW = "view";

    public HudsonInstanceNode(HudsonInstanceImpl instance) {
        super((Children)new Children.Array(), Lookups.singleton((Object)instance));
        this.children = new InstanceNodeChildren(instance);
        this.setName(instance.getUrl());
        this.setDisplayName(instance.getName());
        this.setShortDescription(instance.getUrl());
        this.setIconBaseWithExtension(ICON_BASE);
        this.setValue("customDelete", true);
        this.instance = instance;
        instance.addHudsonChangeListener(new HudsonChangeListener(){

            @Override
            public void stateChanged() {
                HudsonInstanceNode.this.refreshState();
            }

            @Override
            public void contentChanged() {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        instance.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                HudsonInstanceNode.this.refreshContent();
            }
        });
        this.refreshState();
        this.refreshContent();
    }

    public String getHtmlDisplayName() {
        String selectedView = this.instance.prefs().get(SELECTED_VIEW, null);
        return (this.run ? "<b>" : "") + (this.warn ? "<font color=\"#A40000\">" : "") + this.instance.getName() + (this.warn ? "</font>" : "") + (this.run ? "</b>" : "") + (selectedView != null ? " <font color='!controlShadow'>[" + selectedView + "]</font>" : "") + (this.alive ? (this.version ? "" : " <font color=\"#A40000\">" + Bundle.MSG_WrongVersion(HudsonVersion.SUPPORTED_VERSION) + "</font>") : " <font color=\"#A40000\">" + (this.forbidden ? Bundle.MSG_forbidden() : Bundle.MSG_Disconnected()) + "</font>") + this.getProjectInfoString();
    }

    private String getProjectInfoString() {
        boolean pers = this.instance.isPersisted();
        String info = this.instance.getPersistence().getInfo(Bundle.HudsonInstanceNode_from_open_project());
        return !pers ? " <font color='!controlShadow'>" + info + "</font>" : "";
    }

    public Action[] getActions(boolean context) {
        List actions = Utilities.actionsForPath((String)"org-netbeans-modules-hudson/Actions/instance");
        return actions.toArray(new Action[actions.size()]);
    }

    public boolean canDestroy() {
        return this.instance.isPersisted();
    }

    public void destroy() throws IOException {
        HudsonManagerImpl.getDefault().removeInstance(this.instance);
    }

    public Node.PropertySet[] getPropertySets() {
        return new Node.PropertySet[]{this.instance.getProperties().getSheetSet()};
    }

    private synchronized void refreshState() {
        this.alive = this.instance.isConnected();
        this.forbidden = this.instance.isForbidden();
        this.version = org.netbeans.modules.hudson.api.Utilities.isSupportedVersion(this.instance.getVersion());
        if (!this.alive || !this.version) {
            this.setChildren((Children)new Children.Array());
        } else if (this.getChildren().getNodesCount() == 0) {
            this.setChildren((Children)this.children);
        }
        this.fireDisplayNameChange(null, this.getHtmlDisplayName());
    }

    private synchronized void refreshContent() {
        this.warn = false;
        this.run = false;
        for (HudsonJob job : this.instance.getJobs()) {
            if (job.getColor().equals((Object)HudsonJob.Color.red) || job.getColor().equals((Object)HudsonJob.Color.red_anime)) {
                this.warn = true;
            }
            if (job.getColor().isRunning()) {
                this.run = true;
            }
            if (!this.warn || !this.run) continue;
            break;
        }
        this.fireDisplayNameChange(null, this.getHtmlDisplayName());
    }

    private static class InstanceNodeChildren
    extends Children.Keys<HudsonJob>
    implements HudsonChangeListener {
        private final HudsonInstance instance;

        InstanceNodeChildren(HudsonInstance instance) {
            this.instance = instance;
            instance.addHudsonChangeListener(this);
            instance.prefs().addPreferenceChangeListener(new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    InstanceNodeChildren.this.refreshKeys();
                }
            });
        }

        protected Node[] createNodes(HudsonJob job) {
            return new Node[]{new HudsonJobNode(job)};
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private void refreshKeys() {
            ArrayList<HudsonJob> jobs = new ArrayList<HudsonJob>();
            HudsonView view = this.instance.getPrimaryView();
            String selectedView = this.instance.prefs().get(HudsonInstanceNode.SELECTED_VIEW, null);
            if (selectedView != null) {
                for (HudsonView v : this.instance.getViews()) {
                    if (!v.getName().equals(selectedView)) continue;
                    view = v;
                    break;
                }
            }
            for (HudsonJob job : this.instance.getJobs()) {
                if (!job.getViews().contains(view)) continue;
                jobs.add(job);
            }
            Collections.sort(jobs);
            this.setKeys(jobs);
        }

        @Override
        public void stateChanged() {
        }

        @Override
        public void contentChanged() {
            this.refreshKeys();
        }
    }
}

