/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.spi.BuilderConnector;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.openide.util.RequestProcessor;

public class ShowFailures
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ShowFailures.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ShowFailures.class);
    private final HudsonJobBuild build;
    private final HudsonMavenModuleBuild moduleBuild;

    public ShowFailures(HudsonJobBuild build) {
        this(build, null);
    }

    public ShowFailures(HudsonMavenModuleBuild module) {
        this(module.getBuild(), module);
    }

    private ShowFailures(HudsonJobBuild build, HudsonMavenModuleBuild moduleBuild) {
        this.build = build;
        this.moduleBuild = moduleBuild;
        this.putValue("Name", Bundle.ShowFailures_label());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HudsonInstance hudsonInstance = this.build.getJob().getInstance();
        if (hudsonInstance instanceof HudsonInstanceImpl) {
            HudsonInstanceImpl hudsonInstanceImpl = (HudsonInstanceImpl)hudsonInstance;
            BuilderConnector builderClient = hudsonInstanceImpl.getBuilderConnector();
            if (this.moduleBuild != null) {
                builderClient.getFailureDisplayer().showFailures(this.moduleBuild);
            } else {
                builderClient.getFailureDisplayer().showFailures(this.build);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        HudsonInstance instance = this.build.getJob().getInstance();
        if (instance instanceof HudsonInstanceImpl) {
            BuilderConnector builderClient = ((HudsonInstanceImpl)instance).getBuilderConnector();
            return builderClient.getFailureDisplayer() != null;
        }
        return false;
    }
}

