/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.netbeans.modules.hudson.ui.actions.CreateJobPanel;
import org.netbeans.modules.hudson.util.UsageLogging;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public class CreateJob
implements ActionListener {
    private final HudsonInstance instance;

    public static ActionListener global() {
        return new CreateJob(null);
    }

    public CreateJob(HudsonInstance instance) {
        this.instance = instance;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<HudsonInstanceImpl> instances;
        Action custom;
        if (this.instance instanceof HudsonInstanceImpl && (custom = ((HudsonInstanceImpl)this.instance).getPersistence().getNewJobAction()) != null) {
            custom.actionPerformed(e);
            return;
        }
        final CreateJobPanel panel = new CreateJobPanel();
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.CreateJob_title());
        final AtomicReference<Dialog> dialog = new AtomicReference<Dialog>();
        final JButton createButton = new JButton(Bundle.CreateJob_create());
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        CreateJob.this.finalizeJob(panel.instance, panel.creator, panel.name(), panel.selectedProject());
                    }
                });
                ((Dialog)dialog.get()).dispose();
            }
        });
        dd.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("valid".equals(evt.getPropertyName())) {
                    createButton.setEnabled(dd.isValid());
                }
            }
        });
        HudsonInstance _instance = this.instance != null ? this.instance : ((instances = HudsonManagerImpl.getDefault().getInstances()).isEmpty() ? null : (HudsonInstance)instances.iterator().next());
        panel.init(dd, _instance);
        dd.setOptions(new Object[]{createButton, NotifyDescriptor.CANCEL_OPTION});
        dd.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        dialog.set(DialogDisplayer.getDefault().createDialog(dd));
        ((Dialog)dialog.get()).setVisible(true);
    }

    private void finalizeJob(HudsonInstance instance, ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator creator, String name, Project project) {
        try {
            Document doc = creator.configure();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
            String createItemURL = instance.getUrl() + "createItem?name=" + Utilities.uriEncode(name);
            new ConnectionBuilder().instance(instance).url(createItemURL).header("Content-Type", "text/xml").postData(baos.toByteArray()).httpConnection().disconnect();
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(instance.getUrl() + "job/" + Utilities.uriEncode(name) + "/"));
            ((HudsonInstanceImpl)instance).synchronize(false);
            ProjectHudsonProvider.getDefault().recordAssociation(project, new ProjectHudsonProvider.Association(instance.getUrl(), name));
            OpenProjects.getDefault().open(new Project[]{project}, false);
            UI.selectNode(instance.getUrl(), name);
            UsageLogging.logUI(NbBundle.getBundle(CreateJob.class), "UI_HUDSON_JOB_CREATED", project.getClass().getName());
            UsageLogging.logUsage(CreateJob.class, "USG_HUDSON_JOB_CREATED", project.getClass().getName());
        }
        catch (ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator.SilentIOException x) {
            Logger.getLogger(CreateJob.class.getName()).log(Level.INFO, null, x);
        }
        catch (IOException x) {
            Exceptions.attachLocalizedMessage((Throwable)x, (String)Bundle.CreateJob_failure());
            Logger.getLogger(CreateJob.class.getName()).log(Level.WARNING, null, x);
        }
    }
}

