/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class HudsonInstanceProperties
extends HashMap<String, String> {
    private Sheet.Set set;
    private static final RequestProcessor RP = new RequestProcessor(HudsonInstanceProperties.class);
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public HudsonInstanceProperties(String name, String url, String sync) {
        this.put("name", name);
        this.put("url", url);
        this.put("sync_time", sync);
    }

    public HudsonInstanceProperties(Map<String, String> properties) {
        super(properties);
    }

    @Override
    public final synchronized String put(String key, String value) {
        String o = super.put(key, value);
        this.pcs.firePropertyChange(key, o, value);
        if (key.equals("name")) {
            this.loadPreferences();
        }
        this.updatePreferences(key);
        return o;
    }

    @Override
    public synchronized String remove(Object key) {
        String o = (String)super.remove((String)key);
        this.pcs.firePropertyChange((String)key, o, null);
        this.updatePreferences((String)key);
        return o;
    }

    public final boolean isPersisted() {
        String pers = (String)this.get("persisted");
        return pers == null || "true".equals(pers);
    }

    public Sheet.Set getSheetSet() {
        if (null == this.set) {
            this.set = Sheet.createPropertiesSet();
            this.set.setDisplayName((String)this.get("name"));
            this.set.put(new Node.Property[]{new HudsonInstanceProperty("name", Bundle.TXT_Instance_Prop_Name(), Bundle.DESC_Instance_Prop_Name(), true, false), new HudsonInstanceProperty("url", Bundle.TXT_Instance_Prop_Url(), Bundle.DESC_Instance_Prop_Url(), true, false), new PropertySupport<Integer>("sync_time", Integer.class, Bundle.TXT_Instance_Prop_Sync(), Bundle.DESC_Instance_Prop_Sync(), true, true){

                public Integer getValue() {
                    return Integer.valueOf((String)HudsonInstanceProperties.this.get("sync_time"));
                }

                public void setValue(Integer val) {
                    if (val == null || val < 0) {
                        throw new IllegalArgumentException();
                    }
                    HudsonInstanceProperties.this.put("sync_time", val.toString());
                }

                public boolean canWrite() {
                    return HudsonInstanceProperties.this.isPersisted();
                }
            }});
        }
        return this.set;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public List<PropertyChangeListener> getCurrentListeners() {
        return Arrays.asList(this.pcs.getPropertyChangeListeners());
    }

    public static List<String> split(String prop) {
        return prop != null && prop.trim().length() > 0 ? Arrays.asList(prop.split("/")) : Collections.emptyList();
    }

    public static String join(List<String> pieces) {
        StringBuilder b = new StringBuilder();
        for (String piece : pieces) {
            assert (!piece.contains("/")) : piece;
            if (b.length() > 0) {
                b.append('/');
            }
            b.append(piece);
        }
        return b.toString();
    }

    public Preferences getPreferences() {
        String nodeName = this.getNodeName();
        if (nodeName != null) {
            return HudsonManagerImpl.instancePrefs().node(nodeName);
        }
        return null;
    }

    private boolean hasPreferences() {
        String nodeName = this.getNodeName();
        if (nodeName != null) {
            try {
                return HudsonManagerImpl.instancePrefs().nodeExists(nodeName);
            }
            catch (BackingStoreException ex) {
                return false;
            }
        }
        return false;
    }

    private String getNodeName() {
        String name = (String)this.get("name");
        if (name != null && !name.isEmpty()) {
            return HudsonManagerImpl.simplifyServerLocation(name, true);
        }
        return null;
    }

    private void updatePreferences(final String ... keys) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Preferences prefs = HudsonInstanceProperties.this.getPreferences();
                if (prefs != null) {
                    for (String key : keys) {
                        String val = (String)HudsonInstanceProperties.this.get(key);
                        if (val == null) {
                            prefs.remove(key);
                            continue;
                        }
                        prefs.put(key, val);
                    }
                }
            }
        });
    }

    private void loadPreferences() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Preferences prefs;
                if (HudsonInstanceProperties.this.hasPreferences() && (prefs = HudsonInstanceProperties.this.getPreferences()) != null) {
                    try {
                        String[] keys;
                        for (String key : keys = prefs.keys()) {
                            String val;
                            if ("name".equals(key) || "url".equals(key) || (val = prefs.get(key, null)) == null) continue;
                            HudsonInstanceProperties.this.put(key, val);
                        }
                    }
                    catch (BackingStoreException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }

    private class HudsonInstanceProperty
    extends PropertySupport<String> {
        private String key;

        HudsonInstanceProperty(String key, String name, String desc, boolean read, boolean write) {
            super(key, String.class, name, desc, read, write);
            this.key = key;
        }

        public void setValue(String value) {
            HudsonInstanceProperties.this.put(this.key, value);
        }

        public String getValue() {
            return (String)HudsonInstanceProperties.this.get(this.key);
        }
    }
}

