/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.awt.Image;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.impl.HudsonJobBuildImpl;
import org.netbeans.modules.hudson.ui.actions.ShowBuildConsole;
import org.netbeans.modules.hudson.ui.actions.ShowChanges;
import org.netbeans.modules.hudson.ui.actions.ShowFailures;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class UI {
    private static final Logger LOG = Logger.getLogger(UI.class.getName());

    private UI() {
    }

    public static void selectNode(final String ... path) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                TopComponent tab = WindowManager.getDefault().findTopComponent("services");
                if (tab == null) {
                    LOG.fine("No ServicesTab found");
                    return;
                }
                tab.open();
                tab.requestActive();
                if (!(tab instanceof ExplorerManager.Provider)) {
                    LOG.fine("ServicesTab not an ExplorerManager.Provider");
                    return;
                }
                final ExplorerManager mgr = ((ExplorerManager.Provider)tab).getExplorerManager();
                final Node root = mgr.getRootContext();
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        Node _selected;
                        Node hudson = NodeOp.findChild((Node)root, (String)"hudson");
                        if (hudson == null) {
                            LOG.fine("ServicesTab does not contain hudson");
                            return;
                        }
                        try {
                            _selected = NodeOp.findPath((Node)hudson, (String[])path);
                        }
                        catch (NodeNotFoundException x) {
                            LOG.log(Level.FINE, "Could not find subnode", x);
                            _selected = x.getClosestNode();
                        }
                        final Node selected = _selected;
                        Mutex.EVENT.readAccess(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    mgr.setSelectedNodes(new Node[]{selected});
                                }
                                catch (PropertyVetoException x) {
                                    LOG.log(Level.FINE, "Could not select path", x);
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    public static Action showChangesAction(HudsonJobBuild build) {
        return new ShowChanges(build);
    }

    public static Action showConsoleAction(HudsonJobBuild build) {
        return new ShowBuildConsole(build);
    }

    public static Action showConsoleAction(HudsonMavenModuleBuild build) {
        return new ShowBuildConsole(build);
    }

    public static Action showFailuresAction(HudsonJobBuild build) {
        return new ShowFailures(build);
    }

    public static Action showFailuresAction(HudsonMavenModuleBuild build) {
        return new ShowFailures(build);
    }

    public static Icon getIcon(HudsonJob job) {
        return UI.makeIcon(job.getColor().iconBase());
    }

    public static Icon getIcon(HudsonJobBuild build) {
        return UI.makeIcon(HudsonJobBuildImpl.getColorForBuild(build).iconBase());
    }

    private static Icon makeIcon(String iconBase) {
        return ImageUtilities.image2Icon((Image)ImageUtilities.loadImageIcon((String)iconBase, (boolean)false).getImage());
    }
}

