/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;

public interface HudsonInstance
extends Comparable<HudsonInstance> {
    public static final String ACTION_PATH = "org-netbeans-modules-hudson/Actions/instance";

    public String getName();

    public HudsonVersion getVersion();

    public boolean isConnected();

    public String getUrl();

    public Collection<HudsonJob> getJobs();

    public Collection<HudsonView> getViews();

    public HudsonView getPrimaryView();

    public void addHudsonChangeListener(HudsonChangeListener var1);

    public void removeHudsonChangeListener(HudsonChangeListener var1);

    public boolean isPersisted();

    public Preferences prefs();

    public static final class Persistence {
        private static final Persistence TRANSIENT_INSTANCE = new Persistence(false);
        private static final Persistence PERSISTENT_INSTANCE = new Persistence(true);
        private boolean isPersistent;
        private String info;
        private Action newJobAction = null;

        private Persistence(boolean isPersistent) {
            this.isPersistent = isPersistent;
            this.info = null;
        }

        public Persistence(boolean isPersistent, String info, Action newJob) {
            this.isPersistent = isPersistent;
            this.info = info == null ? "" : info;
            this.newJobAction = newJob;
        }

        public static Persistence persistent() {
            return PERSISTENT_INSTANCE;
        }

        public static Persistence tranzient() {
            return TRANSIENT_INSTANCE;
        }

        public static Persistence tranzient(String info) {
            return new Persistence(false, info, null);
        }

        public static Persistence tranzient(String info, Action newJob) {
            return new Persistence(false, info, newJob);
        }

        public static Persistence instance(boolean persistent) {
            if (persistent) {
                return PERSISTENT_INSTANCE;
            }
            return TRANSIENT_INSTANCE;
        }

        public String getInfo(String defaultInfo) {
            if (this.info == null) {
                return defaultInfo;
            }
            return this.info;
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public Action getNewJobAction() {
            return this.newJobAction;
        }
    }
}

