/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar.effpom;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.apache.maven.model.InputLocation;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.maven.grammar.effpom.AnnotationMark;
import org.netbeans.modules.maven.grammar.effpom.AnnotationMarkInstaller;
import org.netbeans.modules.maven.grammar.effpom.AnnotationMarkProvider;
import org.netbeans.modules.maven.grammar.effpom.Bundle;
import org.netbeans.modules.maven.grammar.effpom.LocationAwareMavenXpp3Writer;
import org.netbeans.modules.maven.hyperlinks.HyperlinkProviderImpl;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public final class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
ChangeListener,
ActionListener,
Runnable,
ComponentListener {
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private final Caret caret;
    private Timer caretTimer;
    private Map<Integer, LocationAwareMavenXpp3Writer.Location> elementAnnotations;
    private Color backgroundColor = Color.GRAY.brighter();
    private Color foregroundColor = Color.BLACK;
    private Color selectedColor = Color.BLUE;
    private String recentLocationName;
    static RequestProcessor requestProcessor = null;
    private RequestProcessor.Task latestAnnotationTask = null;
    static final Logger LOG = Logger.getLogger(AnnotationBar.class.getName());
    private MouseListener mouseListener;

    public AnnotationBar(JTextComponent target) {
        this.textComponent = target;
        this.editorUI = Utilities.getEditorUI((JTextComponent)target);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.caret = this.textComponent.getCaret();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    void annotate(final List<LocationAwareMavenXpp3Writer.Location> locations) {
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                StyledDocument sd = (StyledDocument)AnnotationBar.this.doc;
                AnnotationBar.this.elementAnnotations = new HashMap();
                for (LocationAwareMavenXpp3Writer.Location loc : locations) {
                    int line = NbDocument.findLineNumber((StyledDocument)sd, (int)loc.startOffset);
                    AnnotationBar.this.elementAnnotations.put(line, loc);
                    int endline = NbDocument.findLineNumber((StyledDocument)sd, (int)loc.endOffset);
                    if (endline == line || AnnotationBar.this.elementAnnotations.containsKey(endline)) continue;
                    AnnotationBar.this.elementAnnotations.put(endline, loc);
                }
            }
        });
        this.caret.addChangeListener(this);
        this.caretTimer = new Timer(500, this);
        this.caretTimer.setRepeats(false);
        this.onCurrentLine();
        this.revalidate();
    }

    Document getDocument() {
        return this.doc;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    AnnotationBar.this.createPopup(e).show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getID() == 502 && e.getButton() == 1) {
                    e.consume();
                    AnnotationBar.this.showTooltipWindow(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent me) {
                LocationAwareMavenXpp3Writer.Location al;
                if (me.isConsumed()) {
                    return;
                }
                if (me.getClickCount() > 1 && !me.isPopupTrigger() && AnnotationBar.this.elementAnnotations != null && (al = AnnotationBar.this.getAnnotateLine(AnnotationBar.this.getLineFromMouseEvent(me))) != null) {
                    HyperlinkProviderImpl.openAtSource(al.loc);
                }
            }
        };
        this.addMouseListener(this.mouseListener);
        this.setToolTipText("");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void showTooltipWindow(MouseEvent event) {
        Point p = new Point(event.getPoint());
        SwingUtilities.convertPointToScreen(p, this);
        Point p2 = new Point(p);
        SwingUtilities.convertPointFromScreen(p2, this.textComponent);
        LocationAwareMavenXpp3Writer.Location al = null;
        if (this.elementAnnotations != null) {
            al = this.getAnnotateLine(this.getLineFromMouseEvent(event));
        }
    }

    private JPopupMenu createPopup(MouseEvent e) {
        LocationAwareMavenXpp3Writer.Location al;
        JPopupMenu popupMenu = new JPopupMenu();
        if (this.elementAnnotations != null && (al = this.getAnnotateLine(this.getLineFromMouseEvent(e))) != null) {
            JMenuItem item = new JMenuItem(Bundle.ACT_GoToSource());
            popupMenu.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    InputLocation loc = al.loc;
                    if (loc != null) {
                        HyperlinkProviderImpl.openAtSource(loc);
                    }
                }
            });
        }
        return popupMenu;
    }

    private static synchronized RequestProcessor getRequestProcessor() {
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("AnnotationBarRP", 1, true);
        }
        return requestProcessor;
    }

    private void onCurrentLine() {
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        this.latestAnnotationTask = AnnotationBar.getRequestProcessor().post((Runnable)this);
    }

    @Override
    public void run() {
        AnnotationMarkProvider amp;
        int line;
        int offset = this.caret.getDot();
        try {
            line = Utilities.getLineOffset((BaseDocument)this.doc, (int)offset);
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, "Can not get line for caret at offset ", offset);
            return;
        }
        LocationAwareMavenXpp3Writer.Location al = this.getAnnotateLine(line);
        if (al == null) {
            AnnotationMarkProvider amp2 = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (amp2 != null) {
                amp2.setMarks(Collections.<AnnotationMark>emptyList());
            }
            if (this.recentLocationName != null) {
                this.recentLocationName = null;
                this.repaint();
            }
            return;
        }
        String locat = this.getDisplayName(al);
        if (!locat.equals(this.recentLocationName)) {
            this.recentLocationName = locat;
            this.repaint();
        }
        if ((amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent)) != null) {
            ArrayList<AnnotationMark> marks = new ArrayList<AnnotationMark>(this.elementAnnotations.size());
            for (Map.Entry<Integer, LocationAwareMavenXpp3Writer.Location> loca : this.elementAnnotations.entrySet()) {
                LocationAwareMavenXpp3Writer.Location loc = loca.getValue();
                if (!loc.loc.getSource().equals(al.loc.getSource())) continue;
                marks.add(new AnnotationMark(loca.getKey(), loc.loc.getSource().getModelId()));
            }
            amp.setMarks(marks);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width;
        Dimension dim = this.textComponent.getSize();
        dim.width = width = this.getBarWidth();
        dim.height *= 2;
        return dim;
    }

    private int getBarWidth() {
        if (this.elementAnnotations == null) {
            return 0;
        }
        String longestString = "";
        for (LocationAwareMavenXpp3Writer.Location line : this.elementAnnotations.values()) {
            String displayName = this.getDisplayName(line);
            if (displayName.length() <= longestString.length()) continue;
            longestString = displayName;
        }
        char[] data = longestString.toCharArray();
        int w = this.getGraphics().getFontMetrics(this.editorUI.getComponent().getFont()).charsWidth(data, 0, data.length);
        return w + 4;
    }

    private String getDisplayName(LocationAwareMavenXpp3Writer.Location line) {
        if (line.loc.getSource() == null) {
            return "";
        }
        String modelId = line.loc.getSource().getModelId();
        return modelId.substring(modelId.indexOf(58) + 1, modelId.lastIndexOf(":"));
    }

    private void release() {
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.caret.removeChangeListener(this);
        if (this.caretTimer != null) {
            this.caretTimer.removeActionListener(this);
        }
        this.elementAnnotations = null;
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
    }

    private void paintView(View view, Graphics g, int yBase) {
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)component.getUI();
        Element rootElem = textUI.getRootView(component).getElement();
        int line = rootElem.getElementIndex(view.getStartOffset());
        String annotation = "";
        LocationAwareMavenXpp3Writer.Location al = null;
        if (this.elementAnnotations != null && (al = this.getAnnotateLine(line)) != null) {
            annotation = this.getDisplayName(al);
        }
        if (al != null && this.getDisplayName(al).equals(this.recentLocationName)) {
            g.setColor(this.selectedColor());
        } else {
            g.setColor(this.foregroundColor());
        }
        int texty = yBase + this.editorUI.getLineAscent();
        int textx = 2;
        g.setFont(component.getFont());
        g.drawString(annotation, textx, texty);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.editorUI == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(e);
        StringBuilder annotation = new StringBuilder();
        if (this.elementAnnotations != null) {
            LocationAwareMavenXpp3Writer.Location al = this.getAnnotateLine(line);
            if (al != null && al.loc.getSource() != null) {
                annotation.append("<html>").append(Bundle.AnnBar_Value()).append("<br/>");
                annotation.append(Bundle.AnnBar_Model(al.loc.getSource().getModelId())).append("<br/>");
                annotation.append(Bundle.AnnBar_Line(al.loc.getLineNumber())).append("<br/>");
                if (al.loc.getSource().getLocation() != null) {
                    annotation.append(Bundle.AnnBar_File(al.loc.getSource().getLocation()));
                }
                annotation.append("</html>");
            } else {
                annotation.append("<html>").append(Bundle.AnnBar_NonDetermined()).append("</html>");
            }
        }
        return annotation.toString();
    }

    private LocationAwareMavenXpp3Writer.Location getAnnotateLine(int line) {
        if (this.elementAnnotations != null) {
            return this.elementAnnotations.get(line);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        block13: {
            super.paintComponent(g);
            Rectangle clip = g.getClipBounds();
            JTextComponent component = this.editorUI.getComponent();
            if (component == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.backgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            AbstractDocument docum = (AbstractDocument)component.getDocument();
            docum.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block13;
                    int clipEndY = clip.y + clip.height;
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        View view = rootView.getView(i);
                        Rectangle rec = component.modelToView(view.getStartOffset());
                        if (rec == null) {
                        } else {
                            int y = rec.y;
                            this.paintView(view, g, y);
                            if (y < clipEndY) continue;
                        }
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
                LOG.log(Level.WARNING, null, ble);
            }
            finally {
                docum.readUnlock();
            }
        }
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color selectedColor() {
        return this.selectedColor;
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent component = this.editorUI.getComponent();
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                line = Utilities.getLineOffset((BaseDocument)this.doc, (int)clickOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return line;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        String id = evt.getPropertyName();
        if ("component".equals(id) && evt.getNewValue() == null) {
            this.release();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        assert (e.getSource() == this.caret);
        this.caretTimer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (e.getSource() == this.caretTimer);
        this.onCurrentLine();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

