/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.findbugs.installer;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.findbugs.installer.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.RequestProcessor;

public class ModuleInstallerSupport {
    private static RequestProcessor RP = new RequestProcessor(ModuleInstallerSupport.class.getName(), 1);
    private static final Logger LOG = Logger.getLogger(ModuleInstallerSupport.class.getName());
    private JButton tryAgain;
    private JButton proxySettings;

    public boolean download(String cnb, final String displayName) throws Exception {
        UpdateElement element;
        UpdateUnit unit = this.findModule(cnb);
        if (unit == null) {
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)Bundle.searching_handle(displayName));
            this.initButtons();
            final DialogDescriptor searching = new DialogDescriptor((Object)ModuleInstallerSupport.searchingPanel(new JLabel(Bundle.searching_handle(displayName)), ProgressHandleFactory.createProgressComponent((ProgressHandle)handle)), Bundle.resolve_title(displayName), true, null);
            handle.setInitialDelay(0);
            handle.start();
            searching.setOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
            searching.setMessageType(-1);
            final Dialog dlg = DialogDisplayer.getDefault().createDialog(searching);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        try {
                            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                                p.refresh(handle, true);
                            }
                            dlg.dispose();
                        }
                        catch (IOException ex) {
                            LOG.log(Level.FINE, ex.getMessage(), ex);
                            if (!dlg.isVisible()) {
                                LOG.fine("dialog not visible => do nothing");
                                return;
                            }
                            DialogDescriptor networkProblem = new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(Bundle.resolve_title(displayName), Bundle.networkproblem_message()), Bundle.networkproblem_header(), true, null);
                            networkProblem.setOptions(new Object[]{ModuleInstallerSupport.this.tryAgain, ModuleInstallerSupport.this.proxySettings, NotifyDescriptor.CANCEL_OPTION});
                            networkProblem.setClosingOptions(new Object[]{ModuleInstallerSupport.this.tryAgain, NotifyDescriptor.CANCEL_OPTION});
                            networkProblem.setMessageType(2);
                            Dialog networkProblemDialog = DialogDisplayer.getDefault().createDialog(networkProblem);
                            networkProblemDialog.setVisible(true);
                            Object answer = networkProblem.getValue();
                            if (NotifyDescriptor.CANCEL_OPTION.equals(answer) || answer.equals(-1)) {
                                LOG.fine("cancel network problem dialog");
                                searching.setValue(answer);
                                dlg.dispose();
                            }
                            if (ModuleInstallerSupport.this.tryAgain.equals(answer)) {
                                LOG.fine("try again searching");
                                RP.post((Runnable)this);
                            }
                            if ($assertionsDisabled) break block6;
                            throw new AssertionError((Object)("Unknown " + answer));
                        }
                    }
                }
            });
            dlg.setVisible(true);
            handle.finish();
            if (NotifyDescriptor.CANCEL_OPTION.equals(searching.getValue()) || searching.getValue().equals(-1)) {
                LOG.log(Level.FINE, "user canceled searching for {0}", cnb);
                return this.showNoDownloadDialog(cnb, displayName);
            }
            unit = this.findModule(cnb);
            if (unit == null) {
                LOG.log(Level.FINE, "could not find {0} on any update site", cnb);
                return this.showNoDownloadDialog(cnb, displayName);
            }
        }
        if (unit.getInstalled() != null) {
            LOG.fine(unit.getInstalled() + " already installed. Is active? " + unit.getInstalled().isEnabled());
            if (unit.getInstalled().isEnabled()) {
                throw new Exception(unit.getInstalled() + " already installed and active");
            }
            OperationContainer oc = OperationContainer.createForEnable();
            if (!oc.canBeAdded(unit, unit.getInstalled())) {
                throw new Exception("could not add " + unit.getInstalled() + " for activation");
            }
            for (UpdateElement req : oc.add(unit.getInstalled()).getRequiredElements()) {
                oc.add(req);
            }
            ProgressHandle activeHandle = ProgressHandleFactory.createHandle((String)Bundle.active_handle(displayName));
            OperationSupport.Restarter restarter = ((OperationSupport)oc.getSupport()).doOperation(activeHandle);
            assert (restarter == null) : "No Restater need to make " + unit.getInstalled() + " active";
            return true;
        }
        List updates = unit.getAvailableUpdates();
        if (updates.isEmpty()) {
            throw new Exception("no updates for " + unit);
        }
        OperationContainer oc = OperationContainer.createForInstall();
        if (!oc.canBeAdded(unit, element = (UpdateElement)updates.get(0))) {
            throw new Exception("could not add " + element + " to updates");
        }
        for (UpdateElement req : oc.add(element).getRequiredElements()) {
            oc.add(req);
        }
        if (!PluginManager.openInstallWizard((OperationContainer)oc)) {
            LOG.fine("user canceled PM");
            return this.showNoDownloadDialog(cnb, displayName);
        }
        return true;
    }

    private UpdateUnit findModule(String cnb) throws IOException {
        for (UpdateUnit unit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!unit.getCodeName().equals(cnb)) continue;
            return unit;
        }
        return null;
    }

    private void initButtons() {
        if (this.tryAgain != null) {
            return;
        }
        this.tryAgain = new JButton();
        this.proxySettings = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.tryAgain, (String)Bundle.tryagain_button());
        Mnemonics.setLocalizedText((AbstractButton)this.proxySettings, (String)Bundle.proxy_button());
        this.proxySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.fine("show proxy options");
                OptionsDisplayer.getDefault().open("General");
            }
        });
    }

    private boolean showNoDownloadDialog(String cnb, String displayName) throws Exception {
        DialogDescriptor networkProblem = new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(Bundle.nodownload_header(displayName), Bundle.nodownload_message(displayName)), Bundle.resolve_title(displayName), true, null);
        this.initButtons();
        networkProblem.setOptions(new Object[]{this.tryAgain, NotifyDescriptor.CANCEL_OPTION});
        networkProblem.setClosingOptions(new Object[]{this.tryAgain, NotifyDescriptor.CANCEL_OPTION});
        networkProblem.setMessageType(2);
        Dialog networkProblemDialog = DialogDisplayer.getDefault().createDialog(networkProblem);
        networkProblemDialog.setVisible(true);
        Object answer = networkProblem.getValue();
        if (NotifyDescriptor.CANCEL_OPTION.equals(answer) || answer.equals(-1)) {
            LOG.fine("cancel no download dialog");
            return false;
        }
        if (this.tryAgain.equals(answer)) {
            LOG.fine("try again download()");
            return this.download(cnb, displayName);
        }
        assert (false) : "Unknown " + answer;
        assert (false) : "Unknown " + answer;
        return false;
    }

    private static JPanel searchingPanel(JLabel progressLabel, JComponent progressComponent) {
        JPanel panel = new JPanel();
        progressLabel.setLabelFor(progressComponent);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(progressLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(progressComponent, GroupLayout.Alignment.LEADING, -1, 399, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(96, 96, 96).addComponent(progressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(progressComponent, -2, -1, -2).addContainerGap(109, Short.MAX_VALUE)));
        return panel;
    }

    private static JPanel problemPanel(String header, String message) {
        JPanel panel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        JTextArea jTextArea1 = new JTextArea();
        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | 1));
        jLabel1.setText(header);
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setRows(5);
        jTextArea1.setText(message);
        jTextArea1.setOpaque(false);
        jScrollPane1.setViewportView(jTextArea1);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane1, -1, 478, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(jLabel1).addGap(107, 107, 107))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane1, -1, 133, Short.MAX_VALUE).addGap(82, 82, 82)));
        return panel;
    }
}

