/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.spi.RemoteScreenshot;
import org.netbeans.modules.debugger.jpda.visual.spi.ScreenshotUIManager;
import org.netbeans.modules.debugger.jpda.visual.ui.ComponentHierarchy;
import org.netbeans.modules.debugger.jpda.visual.ui.ComponentHierarchyNavigatorHint;
import org.netbeans.modules.debugger.jpda.visual.ui.ComponentNode;
import org.netbeans.spi.navigator.NavigatorLookupHint;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ScreenshotComponent
extends TopComponent {
    private static final Logger logger = Logger.getLogger(ScreenshotComponent.class.getName());
    private static final Map<DebuggerEngine, Set<ScreenshotComponent>> openedScreenshots = new HashMap<DebuggerEngine, Set<ScreenshotComponent>>();
    private static volatile ScreenshotComponent activeScreenshotComponent;
    private static final String[] ZOOM_PERCENTS;
    private static final String PROP_ZOOM = "zoom";
    private RemoteScreenshot screenshot;
    private ScreenshotUIManager manager;
    private NavigatorLookupHint componentHierarchyNavigatorHint = new ComponentHierarchyNavigatorHint();
    private ComponentNode componentNodes;
    private ScreenshotCanvas canvas;
    private JScrollPane scrollPane;
    private boolean propertiesOpened;

    public ScreenshotComponent(RemoteScreenshot screenshot, ScreenshotUIManager manager) {
        ScreenshotCanvas c;
        this.screenshot = screenshot;
        this.manager = manager;
        this.setFocusable(true);
        screenshot.getImage();
        this.canvas = c = new ScreenshotCanvas(screenshot.getImage());
        this.scrollPane = new JScrollPane(c);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane, "Center");
        JToolBar toolBar = this.createToolBar();
        this.add(toolBar, "North");
        String title = screenshot.getTitle();
        title = title == null ? NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_DebuggerSnapshot") : NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_DebuggerSnapshotOf", (Object)title);
        this.setDisplayName(title);
        this.componentNodes = new ComponentNode(screenshot.getComponentInfo());
        ComponentHierarchy.getInstance().getExplorerManager().setRootContext((Node)this.componentNodes);
        ComponentInfo firstCi = ScreenshotComponent.getFirstCustomComponent((Node)this.componentNodes);
        if (firstCi != null) {
            c.listener.selectComponent(firstCi, false);
        } else {
            this.setActivatedNodes(new Node[]{this.componentNodes});
        }
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                switch (c) {
                    case '+': 
                    case '=': {
                        ScreenshotComponent.this.canvas.zoomIn();
                        break;
                    }
                    case '-': 
                    case '_': {
                        ScreenshotComponent.this.canvas.zoomOut();
                        break;
                    }
                    case '1': {
                        ScreenshotComponent.this.canvas.zoom(1.0);
                        break;
                    }
                    case '2': {
                        ScreenshotComponent.this.canvas.zoom(2.0);
                        break;
                    }
                    case '3': {
                        ScreenshotComponent.this.canvas.zoom(3.0);
                        break;
                    }
                    case '4': {
                        ScreenshotComponent.this.canvas.zoom(4.0);
                        break;
                    }
                    case '7': {
                        ScreenshotComponent.this.canvas.zoom(0.25);
                        break;
                    }
                    case '8': {
                        ScreenshotComponent.this.canvas.zoom(0.3333333333333333);
                        break;
                    }
                    case '9': {
                        ScreenshotComponent.this.canvas.zoom(0.5);
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        ScreenshotComponent.this.canvas.zoomFit();
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar(NbBundle.getMessage(ScreenshotComponent.class, (String)"CTL_ToolBarName"));
        toolBar.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ScreenshotComponent.class, (String)"CTL_ToolBarA11yName"));
        toolBar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScreenshotComponent.class, (String)"CTL_ToolBarA11yDescr"));
        toolBar.add(this.createZoomInButton());
        toolBar.add(this.createZoomOutButton());
        toolBar.addSeparator();
        toolBar.add(this.createZoomOrigButton());
        toolBar.addSeparator();
        toolBar.add(this.createZoomFitButton());
        toolBar.addSeparator();
        toolBar.add(this.createZoomPercent());
        toolBar.addSeparator();
        return toolBar;
    }

    private JButton createZoomInButton() {
        JButton inButton = new JButton(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/jpda/visual/resources/zoomIn.gif")));
        inButton.setToolTipText(NbBundle.getMessage(ScreenshotComponent.class, (String)"TLTP_ZoomIn"));
        inButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_ZoomInA11yDescr"));
        inButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenshotComponent.this.canvas.zoomIn();
            }
        });
        inButton.setAlignmentX(0.5f);
        return inButton;
    }

    private JButton createZoomOutButton() {
        JButton outButton = new JButton(ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/jpda/visual/resources/zoomOut.gif")));
        outButton.setToolTipText(NbBundle.getMessage(ScreenshotComponent.class, (String)"TLTP_ZoomOut"));
        outButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_ZoomOutA11yDescr"));
        outButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenshotComponent.this.canvas.zoomOut();
            }
        });
        outButton.setAlignmentX(0.5f);
        return outButton;
    }

    private JButton createZoomOrigButton() {
        JButton origButton = new JButton(NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_ZoomOrig"));
        origButton.setToolTipText(NbBundle.getMessage(ScreenshotComponent.class, (String)"TLTP_ZoomOrig"));
        origButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_ZoomOrigA11yDescr"));
        origButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenshotComponent.this.canvas.zoom(1.0);
            }
        });
        origButton.setAlignmentX(0.5f);
        return origButton;
    }

    private JButton createZoomFitButton() {
        JButton fitButton = new JButton(NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_ZoomFit"));
        fitButton.setToolTipText(NbBundle.getMessage(ScreenshotComponent.class, (String)"TLTP_ZoomFit"));
        fitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_ZoomFitA11yDescr"));
        fitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScreenshotComponent.this.canvas.zoomFit();
            }
        });
        fitButton.setAlignmentX(0.5f);
        return fitButton;
    }

    private JComboBox createZoomPercent() {
        final JComboBox<String> cb = new JComboBox<String>(ZOOM_PERCENTS);
        final boolean[] ignoreChanges = new boolean[]{false};
        cb.setEditable(true);
        Font font = cb.getEditor().getEditorComponent().getFont();
        int textWidth = cb.getEditor().getEditorComponent().getFontMetrics(font).stringWidth(ZOOM_PERCENTS[ZOOM_PERCENTS.length - 1]);
        for (Component c : cb.getComponents()) {
            if (!(c instanceof AbstractButton)) continue;
            int buttonWidth = c.getMinimumSize().width;
            Dimension dim = new Dimension(buttonWidth + textWidth + 10, cb.getPreferredSize().height);
            cb.setPreferredSize(dim);
            cb.setMinimumSize(dim);
            cb.setMaximumSize(dim);
            break;
        }
        cb.setPrototypeDisplayValue(ZOOM_PERCENTS[ZOOM_PERCENTS.length - 1]);
        cb.setMaximumSize(cb.getPreferredSize());
        cb.setToolTipText(NbBundle.getMessage(ScreenshotComponent.class, (String)"TLTP_ZoomPercent"));
        cb.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ScreenshotComponent.class, (String)"LBL_ZoomPercentA11yDescr"));
        double scale = this.canvas.getScale();
        int pc = (int)(scale * 100.0);
        String str = Integer.toString(pc) + '%';
        cb.setSelectedItem(str);
        cb.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof AbstractButton) {
                    int buttonWidth = child.getMinimumSize().width;
                    Font font = cb.getEditor().getEditorComponent().getFont();
                    int textWidth = cb.getEditor().getEditorComponent().getFontMetrics(font).stringWidth(ZOOM_PERCENTS[ZOOM_PERCENTS.length - 1]);
                    int width = buttonWidth + textWidth + 10;
                    Dimension dim = new Dimension(width, cb.getPreferredSize().height);
                    cb.setPreferredSize(dim);
                    cb.setMinimumSize(dim);
                    cb.setMaximumSize(dim);
                    cb.removeContainerListener(this);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        });
        cb.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (ignoreChanges[0]) {
                    return;
                }
                String selected = (String)cb.getSelectedItem();
                if ((selected = selected.trim()).endsWith("%")) {
                    selected = selected.substring(0, selected.length() - 1);
                }
                try {
                    int pc = Integer.parseInt(selected);
                    double scale = (double)pc / 100.0;
                    ScreenshotComponent.this.canvas.setScale(scale);
                }
                catch (NumberFormatException nfex) {
                    int pc = (int)(ScreenshotComponent.this.canvas.getScale() * 100.0);
                    String str = Integer.toString(pc) + '%';
                    ignoreChanges[0] = true;
                    try {
                        cb.setSelectedItem(str);
                    }
                    finally {
                        ignoreChanges[0] = false;
                    }
                }
            }
        });
        this.canvas.addPropertyChangeListener(PROP_ZOOM, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                double newScale = (Double)evt.getNewValue();
                int pc = (int)(newScale * 100.0);
                String str = Integer.toString(pc) + '%';
                if (!str.equals(cb.getSelectedItem())) {
                    ignoreChanges[0] = true;
                    try {
                        cb.setSelectedItem(str);
                    }
                    finally {
                        ignoreChanges[0] = false;
                    }
                }
            }
        });
        cb.setAlignmentX(0.5f);
        return cb;
    }

    private static ComponentInfo getFirstCustomComponent(Node node) {
        Node[] nodes;
        ComponentInfo ci = (ComponentInfo)node.getLookup().lookup(ComponentInfo.class);
        if (ci != null && ci instanceof JavaComponentInfo && ((JavaComponentInfo)ci).isCustomType()) {
            return ci;
        }
        for (Node n : nodes = node.getChildren().getNodes()) {
            ComponentInfo fci = ScreenshotComponent.getFirstCustomComponent(n);
            if (fci == null) continue;
            return fci;
        }
        return null;
    }

    public static ScreenshotComponent getActive() {
        return activeScreenshotComponent;
    }

    public ScreenshotUIManager getManager() {
        return this.manager;
    }

    public ComponentInfo getSelectedComponent() {
        Node[] nodes = this.getActivatedNodes();
        if (nodes.length > 0) {
            return (ComponentInfo)nodes[0].getLookup().lookup(ComponentInfo.class);
        }
        return null;
    }

    public Lookup getLookup() {
        Lookup lookup = super.getLookup();
        return new ProxyLookup(new Lookup[]{lookup, Lookups.singleton((Object)this.componentHierarchyNavigatorHint)});
    }

    protected void componentActivated() {
        logger.fine("componentActivated() root = " + (Object)((Object)this.componentNodes) + ", ci = " + this.componentNodes.getLookup().lookup(ComponentInfo.class));
        activeScreenshotComponent = this;
        ComponentHierarchy.getInstance().getExplorerManager().setRootContext((Node)this.componentNodes);
        ComponentHierarchy.getInstance().getExplorerManager().setExploredContext((Node)this.componentNodes);
        this.canvas.activated();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
    }

    protected void componentShowing() {
        super.componentShowing();
        TopComponent properties = WindowManager.getDefault().findTopComponent("properties");
        if (properties != null && !properties.isOpened()) {
            this.propertiesOpened = true;
            properties.open();
        }
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.propertiesOpened) {
            this.propertiesOpened = false;
            TopComponent properties = WindowManager.getDefault().findTopComponent("properties");
            if (properties != null) {
                properties.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentOpened() {
        Map<DebuggerEngine, Set<ScreenshotComponent>> map = openedScreenshots;
        synchronized (map) {
            Set<ScreenshotComponent> components = openedScreenshots.get(this.screenshot.getDebuggerEngine());
            if (components == null) {
                components = new HashSet<ScreenshotComponent>();
                openedScreenshots.put(this.screenshot.getDebuggerEngine(), components);
            }
            components.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        if (activeScreenshotComponent == this) {
            activeScreenshotComponent = null;
        }
        Map<DebuggerEngine, Set<ScreenshotComponent>> map = openedScreenshots;
        synchronized (map) {
            Set<ScreenshotComponent> components = openedScreenshots.get(this.screenshot.getDebuggerEngine());
            if (components != null) {
                components.remove((Object)this);
                if (components.isEmpty()) {
                    openedScreenshots.remove(this.screenshot.getDebuggerEngine());
                }
            }
        }
        this.canvas.deactivated();
    }

    public int getPersistenceType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeScreenshots(DebuggerEngine engine) {
        Map<DebuggerEngine, Set<ScreenshotComponent>> map = openedScreenshots;
        synchronized (map) {
            Set<ScreenshotComponent> components = openedScreenshots.get(engine);
            if (components != null) {
                final HashSet<ScreenshotComponent> theComponents = new HashSet<ScreenshotComponent>(components);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (ScreenshotComponent c : theComponents) {
                            c.close();
                        }
                    }
                });
            }
        }
    }

    public void markBreakpoint(ComponentInfo ci) {
        this.canvas.markBreakpoint(ci);
    }

    public void unmarkBreakpoint(ComponentInfo ci) {
        this.canvas.unmarkBreakpoint(ci);
    }

    static {
        ZOOM_PERCENTS = new String[]{"10%", "25%", "50%", "75%", "100%", "150%", "200%", "300%"};
    }

    private class ScreenshotCanvas
    extends JComponent {
        private Image image;
        private Rectangle selection;
        private final Set<Rectangle> breakpoints = new HashSet<Rectangle>();
        private Listener listener;
        private boolean active;
        private double scale = 1.0;
        private final double SCALLE_FACTOR = Math.sqrt(2.0);

        public ScreenshotCanvas(Image image) {
            this.image = image;
            this.listener = new Listener();
            this.updateSize();
        }

        private void updateSize() {
            ImageObserver io = new ImageObserver(){

                @Override
                public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                    boolean hasWidth;
                    boolean hasHeight = (infoflags & 2) > 0;
                    boolean bl = hasWidth = (infoflags & 1) > 0;
                    if (!hasHeight || !hasWidth) {
                        return true;
                    }
                    ScreenshotCanvas.this.setSize(width, height);
                    ScreenshotCanvas.this.setPreferredSize(ScreenshotCanvas.this.getSize());
                    return false;
                }
            };
            int width = (int)(this.scale * (double)this.image.getWidth(io)) + 2;
            int height = (int)(this.scale * (double)this.image.getHeight(io)) + 2;
            if (width > 0 && height > 0) {
                this.setSize(width, height);
                this.setPreferredSize(this.getSize());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            int scaledWidth = (int)(this.scale * (double)imageWidth);
            int scaledHeight = (int)(this.scale * (double)imageHeight);
            g.drawImage(this.image, 1, 1, scaledWidth + 1, scaledHeight + 1, 0, 0, imageWidth, imageHeight, this);
            g.drawRect(0, 0, scaledWidth + 2, scaledHeight + 2);
            Set<Rectangle> set = this.breakpoints;
            synchronized (set) {
                Color c = g.getColor();
                g.setColor(Color.RED);
                for (Rectangle r : this.breakpoints) {
                    g.drawRect((int)(this.scale * (double)r.x), (int)(this.scale * (double)r.y), (int)(this.scale * (double)r.width) + 1, (int)(this.scale * (double)r.height) + 1);
                }
                g.setColor(c);
            }
            if (this.selection != null) {
                Color c = g.getColor();
                g.setColor(Color.BLUE);
                g.drawRect((int)(this.scale * (double)this.selection.x), (int)(this.scale * (double)this.selection.y), (int)(this.scale * (double)this.selection.width) + 1, (int)(this.scale * (double)this.selection.height) + 1);
                g.setColor(c);
            }
        }

        void activated() {
            if (this.selection != null) {
                this.listener.selectComponentAt((int)(this.scale * (double)this.selection.x) + 1, (int)(this.scale * (double)this.selection.y) + 1, true);
            }
            if (!this.active) {
                this.addMouseListener(this.listener);
                ComponentHierarchy.getInstance().getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this.listener);
            }
            this.active = true;
        }

        void deactivated() {
            if (!this.active) {
                return;
            }
            this.active = false;
            this.removeMouseListener(this.listener);
            ComponentHierarchy.getInstance().getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this.listener);
        }

        private Rectangle getBreakpointRectangle(ComponentInfo ci) {
            Rectangle r = ci.getWindowBounds();
            return new Rectangle(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markBreakpoint(ComponentInfo ci) {
            Rectangle r;
            Set<Rectangle> set = this.breakpoints;
            synchronized (set) {
                r = this.getBreakpointRectangle(ci);
                this.breakpoints.add(r);
            }
            this.repaint(r.x, r.y, r.width + 3, r.height + 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unmarkBreakpoint(ComponentInfo ci) {
            Rectangle r;
            Set<Rectangle> set = this.breakpoints;
            synchronized (set) {
                r = this.getBreakpointRectangle(ci);
                this.breakpoints.remove(r);
            }
            this.repaint(r.x, r.y, r.width + 3, r.height + 3);
        }

        public void zoomIn() {
            this.setScale(this.scale * this.SCALLE_FACTOR);
        }

        public void zoomOut() {
            double newScale = this.scale / this.SCALLE_FACTOR;
            if (newScale * (double)this.image.getWidth(null) < 1.0 && newScale * (double)this.image.getHeight(null) < 1.0) {
                return;
            }
            this.setScale(newScale);
        }

        public void zoomFit() {
            Rectangle bounds = ScreenshotComponent.this.scrollPane.getViewportBorderBounds();
            int imageWidth = this.image.getWidth(null);
            int imageHeight = this.image.getHeight(null);
            if (imageWidth <= 0 || imageHeight <= 0) {
                return;
            }
            double scalew = (double)bounds.width / (double)(imageWidth + 2);
            double scaleh = (double)bounds.height / (double)(imageHeight + 2);
            this.setScale(Math.min(scalew, scaleh));
        }

        public void zoom(double newScale) {
            int imageWidth = this.image.getWidth(null);
            int imageHeight = this.image.getHeight(null);
            if (imageWidth <= 0 || imageHeight <= 0) {
                return;
            }
            if (newScale * (double)imageWidth < 1.0 && newScale * (double)imageHeight < 1.0) {
                newScale = Math.min(1.0 / (double)imageWidth, 1.0 / (double)imageHeight);
            }
            this.setScale(newScale);
        }

        private void setScale(double scale) {
            if (this.scale != scale) {
                Point2D.Double center = this.computeCenterPoint();
                double oldScale = this.scale;
                this.scale = scale;
                this.updateSize();
                this.setCenterPoint(center);
                this.repaint();
                this.firePropertyChange(ScreenshotComponent.PROP_ZOOM, oldScale, scale);
            }
        }

        public double getScale() {
            return this.scale;
        }

        private Point2D.Double computeCenterPoint() {
            Point p = ScreenshotComponent.this.scrollPane.getViewport().getViewPosition();
            Rectangle viewRect = ScreenshotComponent.this.scrollPane.getViewport().getViewRect();
            p.x += viewRect.width / 2;
            p.y += viewRect.height / 2;
            return new Point2D.Double((double)p.x / this.scale, (double)p.y / this.scale);
        }

        private void setCenterPoint(Point2D.Double pd) {
            Rectangle viewRect = ScreenshotComponent.this.scrollPane.getViewport().getViewRect();
            Point p = new Point((int)(pd.x * this.scale), (int)(pd.y * this.scale));
            p.x -= viewRect.width / 2;
            if (p.x < 0) {
                p.x = 0;
            }
            p.y -= viewRect.height / 2;
            if (p.y < 0) {
                p.y = 0;
            }
            ScreenshotComponent.this.scrollPane.getViewport().setViewPosition(p);
        }

        private class Listener
        implements MouseListener,
        PropertyChangeListener {
            private Listener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.selectComponentAt(e.getX(), e.getY(), false);
                    this.showPopupMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.selectComponentAt(e.getX(), e.getY(), false);
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            private void showPopupMenu(int x, int y) {
                Node[] activatedNodes = ScreenshotComponent.this.getActivatedNodes();
                if (activatedNodes.length == 1) {
                    Action[] actions = activatedNodes[0].getActions(true);
                    JPopupMenu contextMenu = Utilities.actionsToPopup((Action[])actions, (Component)((Object)ScreenshotComponent.this));
                    contextMenu.show(ScreenshotComponent.this.canvas, x, y);
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.fine("propertyChange(" + evt + ") propertyName = " + evt.getPropertyName());
                String propertyName = evt.getPropertyName();
                if ("selectedNodes".equals(propertyName)) {
                    Object[] nodes = ComponentHierarchy.getInstance().getExplorerManager().getSelectedNodes();
                    ComponentInfo ci = null;
                    if (nodes.length > 0) {
                        ci = (ComponentInfo)nodes[0].getLookup().lookup(ComponentInfo.class);
                    }
                    logger.fine("nodes = " + Arrays.toString(nodes) + " => selectComponent(" + ci + ")");
                    this.selectComponent(ci, false);
                } else if ("rootContext".equals(propertyName)) {
                    ScreenshotCanvas.this.deactivated();
                }
            }

            private void selectComponentAt(int x, int y, boolean reActivated) {
                --x;
                x = (int)((double)x / ScreenshotCanvas.this.scale);
                --y;
                y = (int)((double)y / ScreenshotCanvas.this.scale);
                ComponentInfo ci = ScreenshotComponent.this.screenshot.findAt(x, y);
                logger.fine("Component Info at " + x + ", " + y + " is: " + (ci != null ? ci.getDisplayName() : null));
                this.selectComponent(ci, reActivated);
            }

            private void selectComponent(ComponentInfo ci, boolean reActivated) {
                ComponentNode node = null;
                if (ci != null) {
                    Rectangle oldSelection = null;
                    if (ScreenshotCanvas.this.selection != null) {
                        oldSelection = ScreenshotCanvas.this.selection;
                    }
                    ScreenshotCanvas.this.selection = ci.getWindowBounds();
                    if (oldSelection != null) {
                        if (oldSelection.equals(ScreenshotCanvas.this.selection) && !reActivated) {
                            return;
                        }
                        ScreenshotCanvas.this.repaint((int)(ScreenshotCanvas.this.scale * (double)oldSelection.x), (int)(ScreenshotCanvas.this.scale * (double)oldSelection.y), (int)(ScreenshotCanvas.this.scale * (double)oldSelection.width) + 3, (int)(ScreenshotCanvas.this.scale * (double)oldSelection.height) + 3);
                    }
                    ScreenshotCanvas.this.repaint((int)(ScreenshotCanvas.this.scale * (double)((ScreenshotCanvas)ScreenshotCanvas.this).selection.x), (int)(ScreenshotCanvas.this.scale * (double)((ScreenshotCanvas)ScreenshotCanvas.this).selection.y), (int)(ScreenshotCanvas.this.scale * (double)((ScreenshotCanvas)ScreenshotCanvas.this).selection.width) + 3, (int)(ScreenshotCanvas.this.scale * (double)((ScreenshotCanvas)ScreenshotCanvas.this).selection.height) + 3);
                    logger.fine("New selection = " + ScreenshotCanvas.this.selection);
                    node = ScreenshotComponent.this.componentNodes.findNodeFor(ci);
                    logger.fine("FindNodeFor(" + ci + ") on '" + (Object)((Object)ScreenshotComponent.this.componentNodes) + "' gives: " + (Object)((Object)node));
                }
                Object[] nodes = node != null ? new Node[]{node} : new Node[]{};
                logger.fine("setActivated/SelectedNodes(" + Arrays.toString(nodes) + ")");
                ScreenshotComponent.this.setActivatedNodes((Node[])nodes);
                try {
                    ComponentHierarchy.getInstance().getExplorerManager().setSelectedNodes((Node[])nodes);
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

