/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.indexing.api.CssIndex;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.html.editor.api.actions.AbstractSourceElementAction;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.ui.Bundle;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ModifyElementRulesPanel
extends JPanel {
    private AbstractSourceElementAction.SourceElementHandle sourceHandle;
    private int state = 0;
    private Collection<FileObject> linkedStyleSheets;
    private Map<FileObject, Collection<String>> files2classes;
    private Map<FileObject, Collection<String>> files2ids;
    private Map<String, Collection<FileObject>> classes2files;
    private Map<String, Collection<FileObject>> ids2files;
    private String[] SELECTOR_TYPE_DESCRIPTIONS = new String[]{Bundle.class_selector_descr(), Bundle.id_selector_descr()};
    private Attribute clz;
    private Attribute id;
    private String clzName;
    private String idName;
    private String originalClzName;
    private String originalIdName;
    private JComboBox atRuleCB;
    private JTextPane descriptionPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JLabel resultCodeLabel;
    private JComboBox selectorCB;
    private JList selectorTypeList;
    private JComboBox styleSheetCB;

    public ModifyElementRulesPanel(AbstractSourceElementAction.SourceElementHandle sourceHandle) {
        this.sourceHandle = sourceHandle;
        OpenTag openTag = sourceHandle.getOpenTag();
        this.clz = openTag.getAttribute("class");
        this.id = openTag.getAttribute("id");
        if (this.clz != null && this.clz.unquotedValue() != null) {
            this.originalClzName = this.clzName = ((Object)this.clz.unquotedValue()).toString();
        }
        if (this.id != null && this.id.unquotedValue() != null) {
            this.originalIdName = this.idName = ((Object)this.id.unquotedValue()).toString();
        }
        this.loadIndexData();
        this.initComponents();
        this.selectorTypeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ModifyElementRulesPanel.this.selectorTypeList.getSelectedIndex();
                ModifyElementRulesPanel.this.descriptionPane.setText(ModifyElementRulesPanel.this.SELECTOR_TYPE_DESCRIPTIONS[index]);
                ModifyElementRulesPanel.this.state = index;
                ModifyElementRulesPanel.this.stateChanged();
            }
        });
        this.styleSheetCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ModifyElementRulesPanel.this.updateSelectorComboBoxModel(false);
            }
        });
        this.selectorCB.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String value = ModifyElementRulesPanel.this.selectorCB.getEditor().getItem().toString();
                        if (value != null && value.trim().isEmpty()) {
                            value = null;
                        }
                        switch (ModifyElementRulesPanel.this.state) {
                            case 0: {
                                ModifyElementRulesPanel.this.clzName = value;
                                break;
                            }
                            case 1: {
                                ModifyElementRulesPanel.this.idName = value;
                            }
                        }
                        ModifyElementRulesPanel.this.updateResultCodeSample();
                    }
                });
            }
        });
        this.selectorTypeList.setSelectedIndex(0);
        this.updateResultCodeSample();
    }

    public boolean isPanelContentValid() {
        return this.isClassNameOK() && this.isIdNameOK();
    }

    public boolean isModified() {
        boolean classModified = this.originalClzName == null && this.clzName != null || this.originalClzName != null && !this.originalClzName.equals(this.clzName);
        boolean idModified = this.originalIdName == null && this.idName != null || this.originalIdName != null && !this.originalIdName.equals(this.idName);
        return classModified || idModified;
    }

    public Attribute getOriginalClassAttribute() {
        return this.clz;
    }

    public Attribute getOriginalIdAttribute() {
        return this.id;
    }

    public String getNewClassAttributeValue() {
        return this.clzName;
    }

    public String[] getNewClasses() {
        if (this.clzName == null) {
            return null;
        }
        return this.clzName.split("\\s");
    }

    public String getNewIdAttributeValue() {
        return this.idName;
    }

    public boolean classExistsInSelectedStyleSheet(String clzName) {
        if (this.getNewClassAttributeValue() == null) {
            return true;
        }
        Collection<String> classes = this.files2classes.get(this.getSelectedStyleSheet());
        return classes != null && classes.contains(clzName);
    }

    public boolean idExistsInSelectedStyleSheet() {
        if (this.getNewIdAttributeValue() == null) {
            return true;
        }
        Collection<String> ids = this.files2ids.get(this.getSelectedStyleSheet());
        return ids != null && ids.contains(this.getNewIdAttributeValue());
    }

    public FileObject getSelectedStyleSheet() {
        return (FileObject)this.styleSheetCB.getSelectedItem();
    }

    private boolean isClassNameOK() {
        String[] tokens;
        if (this.clzName == null) {
            return true;
        }
        for (String token : tokens = this.clzName.split("\\s")) {
            if (CssTokenId.IDENT.matchesInput((CharSequence)token)) continue;
            return false;
        }
        return true;
    }

    private boolean isIdNameOK() {
        return this.idName == null || CssTokenId.IDENT.matchesInput((CharSequence)this.idName);
    }

    private void updateResultCodeSample() {
        FileObject file = (FileObject)this.styleSheetCB.getSelectedItem();
        Collection<String> classesInFile = this.files2classes.get(file);
        Collection<String> idsInFile = this.files2ids.get(file);
        boolean classExistInSS = classesInFile != null && classesInFile.contains(this.clzName);
        boolean idExistInSS = idsInFile != null && idsInFile.contains(this.idName);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("&lt;");
        sb.append(this.sourceHandle.getOpenTag().name());
        this.appendCode(sb, "id", this.originalIdName, this.idName, idExistInSS);
        this.appendCode(sb, "class", this.originalClzName, this.clzName, classExistInSS);
        sb.append("&gt;");
        if (!this.isClassNameOK()) {
            sb.append("<br><div><font color=\"bb5555\">");
            sb.append(Bundle.class_selector_error(this.clzName));
            sb.append("</font>");
        }
        if (!this.isIdNameOK()) {
            sb.append("<br><div><font color=\"bb5555\">");
            sb.append(Bundle.id_selector_error(this.idName));
            sb.append("</font>");
        }
        sb.append("</html>");
        this.resultCodeLabel.setText(sb.toString());
    }

    private void appendCode(StringBuilder sb, String type, String originalValue, String value, boolean elementExistsInSS) {
        if (originalValue != null && value != null && !originalValue.equals(value)) {
            this.append(sb, type, value, "b", elementExistsInSS);
        } else if (originalValue == null && value != null) {
            this.append(sb, type, value, "b", elementExistsInSS);
        } else if (originalValue != null && value == null) {
            this.append(sb, type, originalValue, "s", true);
        } else if (value != null) {
            this.append(sb, type, originalValue, null, true);
        }
    }

    private void append(StringBuilder sb, String type, String value, String surroundingTag, boolean elementExistsInSS) {
        if (!elementExistsInSS) {
            sb.append("<font color=\"55bb55\">");
        }
        if (surroundingTag != null) {
            sb.append('<');
            sb.append(surroundingTag);
            sb.append('>');
        }
        sb.append(' ');
        sb.append(type);
        sb.append("=");
        sb.append("\"");
        sb.append(value);
        sb.append("\"");
        if (surroundingTag != null) {
            sb.append("</");
            sb.append(surroundingTag);
            sb.append('>');
        }
        if (!elementExistsInSS) {
            sb.append("</font>");
        }
    }

    private void stateChanged() {
        this.updateSelectorComboBoxModel(true);
    }

    private void updateSelectorComboBoxModel(boolean doB) {
        switch (this.state) {
            case 0: {
                Collection<FileObject> infiles;
                this.selectorCB.setModel(this.createClassesModel());
                this.selectorCB.setSelectedItem(this.clzName);
                if (!doB || this.clzName == null || (infiles = this.classes2files.get(this.clzName)) == null) break;
                ArrayList<FileObject> inlinkedfiles = new ArrayList<FileObject>(infiles);
                inlinkedfiles.retainAll(this.linkedStyleSheets);
                if (inlinkedfiles.size() <= 0) break;
                FileObject ss = (FileObject)inlinkedfiles.iterator().next();
                this.styleSheetCB.setSelectedItem(ss);
                break;
            }
            case 1: {
                Collection<FileObject> infiles;
                this.selectorCB.setModel(this.createIdsModel());
                this.selectorCB.setSelectedItem(this.idName);
                if (!doB || this.idName == null || (infiles = this.ids2files.get(this.idName)) == null) break;
                ArrayList<FileObject> inlinkedfiles = new ArrayList<FileObject>(infiles);
                inlinkedfiles.retainAll(this.linkedStyleSheets);
                if (inlinkedfiles.size() <= 0) break;
                FileObject ss = (FileObject)inlinkedfiles.iterator().next();
                this.styleSheetCB.setSelectedItem(ss);
            }
        }
    }

    private void loadIndexData() {
        try {
            FileObject file = this.sourceHandle.getFile();
            Project project = FileOwnerQuery.getOwner((FileObject)file);
            if (project == null) {
                return;
            }
            CssIndex index = CssIndex.create((Project)project);
            DependenciesGraph deps = index.getDependencies(file);
            Collection refered = deps.getAllReferedFiles();
            this.linkedStyleSheets = new ArrayList<FileObject>();
            for (FileObject ref : refered) {
                if (!"text/css".equals(ref.getMIMEType())) continue;
                this.linkedStyleSheets.add(ref);
            }
            this.files2classes = index.findAllClassDeclarations();
            this.files2ids = index.findAllIdDeclarations();
            this.classes2files = ModifyElementRulesPanel.createReversedMap(this.files2classes);
            this.ids2files = ModifyElementRulesPanel.createReversedMap(this.files2ids);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static Map<String, Collection<FileObject>> createReversedMap(Map<FileObject, Collection<String>> file2elements) {
        HashMap<String, Collection<FileObject>> map = new HashMap<String, Collection<FileObject>>();
        for (FileObject file : file2elements.keySet()) {
            for (String element : file2elements.get(file)) {
                HashSet<FileObject> files = (HashSet<FileObject>)map.get(element);
                if (files == null) {
                    files = new HashSet<FileObject>();
                }
                files.add(file);
                map.put(element, files);
            }
        }
        return map;
    }

    private ComboBoxModel createClassesModel() {
        Collection<String> foundInFile;
        ArrayList<String> classes = new ArrayList<String>();
        classes.add(null);
        FileObject selectedStyleSheet = (FileObject)this.styleSheetCB.getSelectedItem();
        if (selectedStyleSheet != null && (foundInFile = this.files2classes.get(selectedStyleSheet)) != null) {
            classes.addAll(foundInFile);
        }
        return new DefaultComboBoxModel<Object>(classes.toArray());
    }

    private ComboBoxModel createIdsModel() {
        Collection<String> foundInFile;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(null);
        FileObject selectedStyleSheet = (FileObject)this.styleSheetCB.getSelectedItem();
        if (selectedStyleSheet != null && (foundInFile = this.files2ids.get(selectedStyleSheet)) != null) {
            ids.addAll(foundInFile);
        }
        return new DefaultComboBoxModel<Object>(ids.toArray());
    }

    private ComboBoxModel createStylesheetsModel() {
        return new DefaultComboBoxModel<Object>(this.linkedStyleSheets.toArray());
    }

    private ListCellRenderer createStyleSheetsRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText("<html>" + Bundle.none_item());
                } else {
                    FileObject file = (FileObject)value;
                    FileObject webRoot = ProjectWebRootQuery.getWebRoot((FileObject)file);
                    String file2string = webRoot != null ? FileUtil.getRelativePath((FileObject)webRoot, (FileObject)file) : FileUtil.getFileDisplayName((FileObject)file);
                    this.setText(file2string);
                }
                return c;
            }
        };
    }

    private ListCellRenderer createSelectorCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                boolean bold = false;
                String strval = (String)value;
                if (strval != null && strval.trim().isEmpty()) {
                    return c;
                }
                switch (ModifyElementRulesPanel.this.state) {
                    case 0: {
                        if ((strval != null || ModifyElementRulesPanel.this.clzName != null) && (strval == null || !strval.equals(ModifyElementRulesPanel.this.clzName))) break;
                        bold = true;
                        break;
                    }
                    case 1: {
                        if ((strval != null || ModifyElementRulesPanel.this.idName != null) && (strval == null || !strval.equals(ModifyElementRulesPanel.this.idName))) break;
                        bold = true;
                    }
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                if (bold) {
                    sb.append("<b>");
                }
                sb.append(strval == null ? Bundle.none_item() : strval);
                if (bold) {
                    sb.append("</b>");
                }
                sb.append("</html>");
                this.setText(sb.toString());
                return c;
            }
        };
    }

    private ComboBoxModel createSelectorModel() {
        HtmlModel model = HtmlModelFactory.getModel((HtmlVersion)HtmlVersion.HTML5);
        ArrayList<String> tagNames = new ArrayList<String>();
        tagNames.add(null);
        for (HtmlTag tag : model.getAllTags()) {
            tagNames.add(tag.getName());
        }
        return new DefaultComboBoxModel<Object>(tagNames.toArray());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.selectorTypeList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionPane = new JTextPane();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.styleSheetCB = new JComboBox();
        this.atRuleCB = new JComboBox();
        this.jLabel4 = new JLabel();
        this.selectorCB = new JComboBox();
        this.jLabel5 = new JLabel();
        this.resultCodeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ModifyElementRulesPanel.class, (String)"ModifyElementRulesPanel.jLabel1.text"));
        this.jSplitPane1.setDividerLocation(120);
        this.jSplitPane1.setDividerSize(4);
        this.selectorTypeList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Class", "ID"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.selectorTypeList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.selectorTypeList);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setEnabled(false);
        this.jScrollPane2.setViewportView(this.descriptionPane);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ModifyElementRulesPanel.class, (String)"ModifyElementRulesPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ModifyElementRulesPanel.class, (String)"ModifyElementRulesPanel.jLabel3.text"));
        this.styleSheetCB.setModel(this.createStylesheetsModel());
        this.styleSheetCB.setRenderer(this.createStyleSheetsRenderer());
        this.atRuleCB.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ModifyElementRulesPanel.class, (String)"ModifyElementRulesPanel.jLabel4.text"));
        this.selectorCB.setEditable(true);
        this.selectorCB.setModel(this.createSelectorModel());
        this.selectorCB.setRenderer(this.createSelectorCellRenderer());
        this.selectorCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModifyElementRulesPanel.this.selectorCBActionPerformed(evt);
            }
        });
        this.jLabel5.setLabelFor(this.resultCodeLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ModifyElementRulesPanel.class, (String)"ModifyElementRulesPanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.resultCodeLabel, (String)NbBundle.getMessage(ModifyElementRulesPanel.class, (String)"ModifyElementRulesPanel.resultCodeLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSplitPane1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel4)).add(0, 0, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.resultCodeLabel).add(0, 0, Short.MAX_VALUE)).add((Component)this.selectorCB, 0, -1, Short.MAX_VALUE).add((Component)this.styleSheetCB, 0, 408, Short.MAX_VALUE).add((Component)this.atRuleCB, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSplitPane1, -2, 87, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.selectorCB, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.styleSheetCB, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.atRuleCB, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.resultCodeLabel).add((Component)this.jLabel5)).addContainerGap(40, Short.MAX_VALUE)));
    }

    private void selectorCBActionPerformed(ActionEvent evt) {
        String value = (String)this.selectorCB.getSelectedItem();
        if (value != null && value.trim().isEmpty()) {
            value = null;
        }
        switch (this.state) {
            case 0: {
                this.clzName = value;
                break;
            }
            case 1: {
                this.idName = value;
            }
        }
        this.updateResultCodeSample();
    }
}

