/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.AddStylesheetLinkHintFix;
import org.netbeans.modules.html.editor.hints.css.CreateRuleInStylesheet;
import org.netbeans.modules.html.editor.hints.css.CssClassesVisitor;
import org.openide.filesystems.FileObject;

public class MissingCssElement
extends Hint {
    public MissingCssElement(Rule rule, String msg, HtmlRuleContext context, OffsetRange range, CssClassesVisitor.HintContext hintContext) {
        super(rule, msg, context.getFile(), range, MissingCssElement.createFixes(context, hintContext), 10);
    }

    private static List<HintFix> createFixes(HtmlRuleContext context, CssClassesVisitor.HintContext hintContext) {
        ArrayList<HintFix> fixes = new ArrayList<HintFix>();
        FileObject sourceFile = context.getFile();
        if (hintContext.getClasses2files().get(hintContext.getClassName()) != null) {
            for (FileObject file : hintContext.getClasses2files().get(hintContext.getClassName())) {
                fixes.add(new AddStylesheetLinkHintFix(sourceFile, file));
            }
        } else if (!hintContext.getAllStylesheets().isEmpty()) {
            for (FileObject stylesheet : hintContext.getAllStylesheets()) {
                fixes.add(new CreateRuleInStylesheet(sourceFile, stylesheet, hintContext.getClassName(), !hintContext.getReferredFiles().contains(stylesheet), false));
            }
        } else {
            fixes.add(new CreateRuleInStylesheet(sourceFile, null, hintContext.getClassName(), true, true));
        }
        return fixes;
    }
}

