/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.io.IOException;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelUtils;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.html.editor.HtmlSourceUtils;
import org.netbeans.modules.html.editor.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.css.Bundle;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class CreateRuleInStylesheet
implements HintFix {
    private static String NEW_STYLESHEET_NAME = "style.css";
    private FileObject externalStylesheet;
    private final FileObject sourceFile;
    private final String ruleName;
    private final String path;
    private boolean importStyleSheet;
    private boolean createStyleSheet;

    public CreateRuleInStylesheet(FileObject sourceFile, FileObject externalStylesheet, String ruleName, boolean importStylesheet, boolean createStyleSheet) {
        this.sourceFile = sourceFile;
        this.externalStylesheet = externalStylesheet;
        this.ruleName = ruleName;
        this.importStyleSheet = importStylesheet;
        this.createStyleSheet = createStyleSheet;
        this.path = externalStylesheet != null ? WebUtils.getRelativePath((FileObject)sourceFile, (FileObject)externalStylesheet) : null;
    }

    private String getSelectorText() {
        return '.' + this.ruleName;
    }

    public String getDescription() {
        if (this.createStyleSheet) {
            return Bundle.description_create_rule_and_import_new_stylesheet(this.getSelectorText(), NEW_STYLESHEET_NAME);
        }
        if (this.importStyleSheet) {
            return Bundle.description_create_rule_and_import_stylesheet(this.getSelectorText(), this.path);
        }
        return Bundle.description_create_rule_in_stylesheet(this.getSelectorText(), this.path);
    }

    public void implement() throws Exception {
        if (this.createStyleSheet) {
            FileObject folder = this.sourceFile.getParent();
            this.externalStylesheet = FileUtil.createData((FileObject)folder, (String)NEW_STYLESHEET_NAME);
        }
        if (this.importStyleSheet) {
            Source source = Source.create((FileObject)this.sourceFile);
            Document doc = source.getDocument(false);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult();
                    if (!(result instanceof HtmlParserResult)) {
                        return;
                    }
                    ModificationResult modification = new ModificationResult();
                    if (HtmlSourceUtils.importStyleSheet(modification, (HtmlParserResult)result, CreateRuleInStylesheet.this.externalStylesheet)) {
                        modification.commit();
                    }
                }
            });
        }
        final Model model = Utils.createCssSourceModel(Source.create((FileObject)this.externalStylesheet));
        model.runWriteTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                try {
                    ModelUtils utils = new ModelUtils(model);
                    Rule rule = utils.createRule(Collections.singleton(CreateRuleInStylesheet.this.getSelectorText()), Collections.emptyList());
                    utils.getBody().addRule(rule);
                    model.applyChanges();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }
}

