/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.util.Collections;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.openide.util.NbBundle;

public class RemoveSurroundingTag
extends Hint {
    private static final Rule RULE = new RemoveSurroundingTagRule();
    private static final String DISPLAYNAME = NbBundle.getMessage(RemoveSurroundingTag.class, (String)"MSG_RemoveSurroundingTag");

    public RemoveSurroundingTag(RuleContext context, OffsetRange range) {
        super(RULE, DISPLAYNAME, context.parserResult.getSnapshot().getSource().getFileObject(), range, Collections.singletonList(new SurroundWithTagHintFix(context)), 10);
    }

    private static Element[] findPairNodesAtSelection(RuleContext context) {
        if (context.selectionStart == -1 || context.selectionEnd == -1) {
            return null;
        }
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        Element open = result.findByPhysicalRange(context.selectionStart, true);
        if (open == null || open.type() != ElementType.OPEN_TAG) {
            return null;
        }
        Element close = result.findByPhysicalRange(context.selectionEnd, false);
        if (close == null || close.type() != ElementType.CLOSE_TAG) {
            return null;
        }
        OpenTag openTag = (OpenTag)open;
        if (openTag.matchingCloseTag() != close) {
            return null;
        }
        return new Element[]{open, close};
    }

    private static class RemoveSurroundingTagRule
    implements Rule {
        private RemoveSurroundingTagRule() {
        }

        public boolean appliesTo(RuleContext context) {
            return RemoveSurroundingTag.findPairNodesAtSelection(context) != null;
        }

        public String getDisplayName() {
            return DISPLAYNAME;
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return HintSeverity.INFO;
        }
    }

    private static class SurroundWithTagHintFix
    implements HintFix {
        RuleContext context;

        public SurroundWithTagHintFix(RuleContext context) {
            this.context = context;
        }

        public String getDescription() {
            return DISPLAYNAME;
        }

        public void implement() throws Exception {
            this.context.doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        Element[] surroundingPair = RemoveSurroundingTag.findPairNodesAtSelection(SurroundWithTagHintFix.this.context);
                        if (surroundingPair == null) {
                            return;
                        }
                        int otfrom = surroundingPair[0].from();
                        int otto = surroundingPair[0].to();
                        int otlen = otto - otfrom;
                        int ctfrom = surroundingPair[1].from();
                        int ctto = surroundingPair[1].to();
                        SurroundWithTagHintFix.this.context.doc.remove(otfrom, otlen);
                        SurroundWithTagHintFix.this.context.doc.remove(ctfrom - otlen, ctto - ctfrom);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }
}

