/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.html.editor.hints.EmbeddingUtil;
import org.netbeans.modules.html.editor.hints.HtmlRule;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.NbBundle;

public abstract class HtmlValidatorRule
extends HtmlRule {
    @Override
    public boolean isSpecialHtmlValidatorRule() {
        return true;
    }

    @Override
    protected void run(HtmlRuleContext context, List<Hint> result) {
        Snapshot snapshot = context.getSnapshot();
        int snapshotLen = snapshot.getText().length();
        List<? extends Error> diagnostics = context.getLeftDiagnostics();
        ListIterator<? extends Error> itr = diagnostics.listIterator();
        while (itr.hasNext()) {
            Error e = itr.next();
            if (!this.appliesTo(context, e)) continue;
            itr.remove();
            OffsetRange errorOffsetRange = EmbeddingUtil.getErrorOffsetRange(e, snapshot);
            int from = e.getStartPosition();
            boolean valid = from >= 0 && from < snapshotLen;
            boolean isFirstHintForPosition = valid ? context.isFirstHintForPosition(from) : true;
            Hint h = new Hint((Rule)this, this.getModifiedErrorMessage(e.getDescription()), e.getFile(), errorOffsetRange, isFirstHintForPosition ? context.getDefaultFixes() : Collections.emptyList(), 20);
            if (!this.isEnabled) continue;
            result.add(h);
        }
    }

    private String getModifiedErrorMessage(String msg) {
        int colonIndex = msg.indexOf(58);
        if (colonIndex > 30) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(msg.substring(colonIndex + 1).trim());
        sb.append('\n');
        sb.append(NbBundle.getMessage(HtmlValidatorRule.class, (String)"MSG_RuleCategory", (Object)this.getDisplayName()));
        return sb.toString();
    }

    protected abstract boolean appliesTo(HtmlRuleContext var1, Error var2);
}

