/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.completion;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.completion.HtmlCompletionQuery;
import org.netbeans.modules.html.editor.javadoc.HelpManager;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.HelpResolver;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HtmlCompletionProvider
implements CompletionProvider {
    private static final Logger LOG = Logger.getLogger(HtmlCompletionProvider.class.getName());
    private final AtomicBoolean AUTO_QUERY = new AtomicBoolean();
    private static boolean assertsEnabled = false;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        this.AUTO_QUERY.set(true);
        Document doc = component.getDocument();
        int dotPos = component.getCaret().getDot();
        return HtmlPreferences.autoPopupCompletionWindow() && HtmlCompletionProvider.checkOpenCompletion(doc, dotPos, typedText) ? 3 : 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        AsyncCompletionTask task = null;
        boolean triggeredByAutocompletion = this.AUTO_QUERY.getAndSet(false);
        if ((queryType & 1 & 9) != 0) {
            task = new AsyncCompletionTask((AsyncCompletionQuery)new Query(triggeredByAutocompletion), component);
        } else if (queryType == 2) {
            task = new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null, triggeredByAutocompletion), component);
        }
        return task;
    }

    private static void checkHideCompletion(final BaseDocument doc, final int caretOffset) {
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                tokenSequence.move(caretOffset == 0 ? 0 : caretOffset - 1);
                if (!tokenSequence.moveNext()) {
                    return;
                }
                Token tokenItem = tokenSequence.token();
                if (tokenItem.id() == HTMLTokenId.TEXT && !((Object)tokenItem.text()).toString().startsWith("<") && !((Object)tokenItem.text()).toString().startsWith("&")) {
                    HtmlCompletionProvider.hideCompletion();
                }
            }
        });
    }

    static boolean checkOpenCompletion(Document document, final int dotPos, String typedText) {
        final BaseDocument doc = (BaseDocument)document;
        switch (typedText.charAt(typedText.length() - 1)) {
            case '/': {
                if (dotPos < 2) break;
                try {
                    String txtBeforeSpace = doc.getText(dotPos - 2, 2);
                    if (txtBeforeSpace.equals("</")) {
                        return true;
                    }
                }
                catch (BadLocationException e) {}
                break;
            }
            case ' ': {
                final AtomicBoolean value = new AtomicBoolean();
                doc.render(new Runnable(){

                    @Override
                    public void run() {
                        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence((Document)doc, dotPos);
                        if (ts == null) {
                            value.set(false);
                            return;
                        }
                        int diff = ts.move(dotPos);
                        if (diff == 0) {
                            if (ts.movePrevious() && ts.token().id() == HTMLTokenId.WS && ts.movePrevious()) {
                                value.set(ts.token().id() == HTMLTokenId.TAG_OPEN || ts.token().id() == HTMLTokenId.VALUE || ts.token().id() == HTMLTokenId.VALUE_CSS || ts.token().id() == HTMLTokenId.VALUE_JAVASCRIPT);
                            }
                        } else if (diff > 0 && ts.moveNext() && ts.token().id() == HTMLTokenId.WS && ts.movePrevious()) {
                            value.set(ts.token().id() == HTMLTokenId.TAG_OPEN || ts.token().id() == HTMLTokenId.VALUE || ts.token().id() == HTMLTokenId.VALUE_CSS || ts.token().id() == HTMLTokenId.VALUE_JAVASCRIPT);
                        }
                    }
                });
                return value.get();
            }
            case '&': 
            case '<': {
                return true;
            }
            case '>': {
                if (!HtmlPreferences.autoPopupEndTagAutoCompletion()) break;
                final boolean[] ret = new boolean[1];
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence((Document)doc, dotPos);
                        if (ts == null) {
                            ret[0] = false;
                        } else {
                            ts.move(dotPos - 1);
                            if ((ts.moveNext() || ts.movePrevious()) && ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && !CharSequenceUtilities.equals((CharSequence)"/>", (Object)ts.token().text())) {
                                ret[0] = true;
                            }
                        }
                    }
                });
                return ret[0];
            }
        }
        return false;
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    private static CompletionDocumentation createCompletionDocumentation(HtmlCompletionItem item) {
        HelpItem helpItem = item.getHelpItem();
        if (helpItem != null) {
            return new HtmlTagDocumetationItem(item);
        }
        return new DocItem(item);
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    private static class DocItem
    implements CompletionDocumentation {
        HtmlCompletionItem item;

        public DocItem(HtmlCompletionItem ri) {
            this.item = ri;
        }

        public String getText() {
            return this.item.getHelp();
        }

        public URL getURL() {
            return this.item.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String link) {
            URL itemUrl = HelpManager.getDefault().getHelpURL(this.item.getHelpId());
            return itemUrl != null ? new LegacyLinkDocItem(HelpManager.getDefault().getRelativeURL(itemUrl, link)) : new NoDocItem();
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class HtmlTagDocumetationItem
    implements CompletionDocumentation {
        private final HtmlCompletionItem item;
        private final String documentationText;

        public HtmlTagDocumetationItem(HtmlCompletionItem ri) {
            this.item = ri;
            this.documentationText = this.loadDocText();
        }

        private HelpItem getHelpItem() {
            return this.item.getHelpItem();
        }

        private String loadDocText() {
            StringBuilder sb = new StringBuilder();
            String header = this.getHelpItem().getHelpHeader();
            if (header != null) {
                sb.append(header);
            }
            String helpContent = this.getHelpItem().getHelpContent() != null ? this.getHelpItem().getHelpContent() : this.getHelpItem().getHelpResolver().getHelpContent(this.getURL());
            sb.append(helpContent);
            return sb.toString();
        }

        public String getText() {
            return this.documentationText;
        }

        public URL getURL() {
            return this.getHelpItem().getHelpURL();
        }

        public CompletionDocumentation resolveLink(String link) {
            URL itemUrl = this.getHelpItem().getHelpResolver().resolveLink(this.getURL(), link);
            return itemUrl != null ? new LinkDocItem(this.getHelpItem().getHelpResolver(), itemUrl) : new NoDocItem();
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class NoDocItem
    implements CompletionDocumentation {
        private NoDocItem() {
        }

        public String getText() {
            return NbBundle.getMessage(HtmlCompletionProvider.class, (String)"MSG_No_Doc_For_Target");
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class LinkDocItem
    implements CompletionDocumentation {
        private URL url;
        private HelpResolver resolver;

        public LinkDocItem(HelpResolver resolver, URL url) {
            this.url = url;
            this.resolver = resolver;
        }

        public String getText() {
            return this.resolver.getHelpContent(this.getURL());
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String link) {
            return new LinkDocItem(this.resolver, this.resolver.resolveLink(this.getURL(), link));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class LegacyLinkDocItem
    implements CompletionDocumentation {
        private URL url;

        public LegacyLinkDocItem(URL url) {
            this.url = url;
        }

        public String getText() {
            return null;
        }

        public URL getURL() {
            return this.url;
        }

        public CompletionDocumentation resolveLink(String link) {
            return new LegacyLinkDocItem(HelpManager.getDefault().getRelativeURL(this.url, link));
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        protected final boolean triggeredByAutocompletion;

        public AbstractQuery(boolean triggeredByAutocompletion) {
            this.triggeredByAutocompletion = triggeredByAutocompletion;
        }

        protected void preQueryUpdate(JTextComponent component) {
            HtmlCompletionProvider.checkHideCompletion((BaseDocument)component.getDocument(), component.getCaretPosition());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                this.doQuery(resultSet, doc, caretOffset);
            }
            finally {
                resultSet.finish();
            }
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    public static class DocQuery
    extends AbstractQuery {
        private CompletionItem item;

        public DocQuery(HtmlCompletionItem item, boolean triggeredByAutocompletion) {
            super(triggeredByAutocompletion);
            this.item = item;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            HtmlCompletionItem htmlItem;
            if (this.item == null) {
                try {
                    HtmlCompletionQuery.CompletionResult result = new HtmlCompletionQuery(doc, caretOffset, false).query();
                    if (result == null) {
                        return;
                    }
                    try {
                        int rowEnd = Utilities.getRowEnd((BaseDocument)((BaseDocument)doc), (int)caretOffset);
                        String documentText = doc.getText(result.getAnchor(), rowEnd - result.getAnchor());
                        for (CompletionItem completionItem : result.getItems()) {
                            if (!LexerUtils.startsWith((CharSequence)documentText, (CharSequence)completionItem.getInsertPrefix(), (boolean)true, (boolean)false)) continue;
                            if (this.item == null) {
                                this.item = completionItem;
                                if (assertsEnabled) continue;
                                break;
                            }
                            LOG.log(Level.WARNING, "More than one CompletionItem found with InsertPrefix {0}, item.insertPrefix={1}", new Object[]{completionItem.getInsertPrefix(), this.item.getInsertPrefix()});
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((htmlItem = (HtmlCompletionItem)this.item) != null && htmlItem.hasHelp()) {
                resultSet.setDocumentation(HtmlCompletionProvider.createCompletionDocumentation(htmlItem));
            }
        }
    }

    private static class Query
    extends AbstractQuery {
        private int anchor;
        private volatile Collection<? extends CompletionItem> items = Collections.emptyList();
        private JTextComponent component;

        public Query(boolean triggeredByAutocompletion) {
            super(triggeredByAutocompletion);
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            try {
                HtmlCompletionQuery.CompletionResult result = new HtmlCompletionQuery(doc, caretOffset, this.triggeredByAutocompletion).query();
                if (result != null) {
                    this.items = result.getItems();
                    this.anchor = result.getAnchor();
                } else {
                    this.items = Collections.emptyList();
                    this.anchor = 0;
                }
                resultSet.addAllItems(this.items);
                resultSet.setAnchorOffset(this.anchor);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        protected boolean canFilter(JTextComponent component) {
            try {
                Document doc = component.getDocument();
                int offset = component.getCaretPosition();
                if (offset < this.anchor) {
                    return false;
                }
                String prefix = doc.getText(this.anchor, offset - this.anchor);
                for (CompletionItem completionItem : this.items) {
                    if (!(completionItem instanceof HtmlCompletionItem)) continue;
                    String itemText = ((HtmlCompletionItem)completionItem).getItemText();
                    if (itemText != null) {
                        if (!Query.startsWithIgnoreCase(itemText, prefix)) continue;
                        return true;
                    }
                    LOG.log(Level.WARNING, "CompletionItem {0} returned null from getItemText()!", completionItem);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void filter(CompletionResultSet resultSet) {
            try {
                Document doc = this.component.getDocument();
                int offset = this.component.getCaretPosition();
                String prefix = doc.getText(this.anchor, offset - this.anchor);
                for (CompletionItem completionItem : this.items) {
                    if (!(completionItem instanceof HtmlCompletionItem) || !Query.startsWithIgnoreCase(((HtmlCompletionItem)completionItem).getItemText(), prefix)) continue;
                    resultSet.addItem(completionItem);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                resultSet.setAnchorOffset(this.anchor);
                resultSet.finish();
            }
        }

        private static boolean startsWithIgnoreCase(String text, String prefix) {
            return text.toLowerCase(Locale.ENGLISH).startsWith(prefix.toLowerCase(Locale.ENGLISH));
        }
    }
}

