/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.index;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.common.api.DependenciesGraph;
import org.netbeans.modules.web.common.api.FileReference;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public class HtmlIndex {
    private static final Logger LOGGER = Logger.getLogger(HtmlIndex.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final Map<Project, HtmlIndex> INDEXES = new WeakHashMap<Project, HtmlIndex>();
    private final QuerySupport querySupport;
    private ChangeSupport changeSupport;

    public static HtmlIndex get(Project project) throws IOException {
        return HtmlIndex.get(project, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HtmlIndex get(Project project, boolean createIfNeccesary) throws IOException {
        if (project == null) {
            throw new NullPointerException();
        }
        Map<Project, HtmlIndex> map = INDEXES;
        synchronized (map) {
            HtmlIndex index = INDEXES.get(project);
            if (index == null && createIfNeccesary) {
                index = new HtmlIndex(project);
                INDEXES.put(project, index);
            }
            return index;
        }
    }

    private HtmlIndex(Project project) throws IOException {
        Collection sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
        this.querySupport = QuerySupport.forRoots((String)"html", (int)2, (FileObject[])sourceRoots.toArray(new FileObject[0]));
        this.changeSupport = new ChangeSupport((Object)this);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void notifyChange() {
        this.changeSupport.fireChange();
    }

    public Collection<FileObject> find(String keyName, String value) {
        try {
            String searchExpression = ".*(" + value + ")[,;].*";
            LinkedList<FileObject> matchedFiles = new LinkedList<FileObject>();
            Collection results = this.querySupport.query(keyName, searchExpression, QuerySupport.Kind.REGEXP, new String[]{keyName});
            for (IndexResult indexResult : this.filterDeletedFiles(results)) {
                matchedFiles.add(indexResult.getFile());
            }
            return matchedFiles;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    public AllDependenciesMaps getAllDependencies() throws IOException {
        Collection<? extends IndexResult> results = this.filterDeletedFiles(this.querySupport.query("imports", "", QuerySupport.Kind.PREFIX, new String[]{"imports"}));
        HashMap<FileObject, Collection<FileReference>> source2dests = new HashMap<FileObject, Collection<FileReference>>();
        HashMap<FileObject, Collection<FileReference>> dest2sources = new HashMap<FileObject, Collection<FileReference>>();
        for (IndexResult indexResult : results) {
            String importsValue = indexResult.getValue("imports");
            FileObject file = indexResult.getFile();
            Collection<String> imports = this.decodeListValue(importsValue);
            HashSet<FileReference> imported = new HashSet<FileReference>();
            for (String importedFileName : imports) {
                FileReference resolvedReference = WebUtils.resolveToReference((FileObject)file, (String)importedFileName);
                if (resolvedReference == null) continue;
                imported.add(resolvedReference);
                HashSet<FileReference> sources = (HashSet<FileReference>)dest2sources.get(resolvedReference.target());
                if (sources == null) {
                    sources = new HashSet<FileReference>();
                    dest2sources.put(resolvedReference.target(), sources);
                }
                sources.add(resolvedReference);
            }
            source2dests.put(file, imported);
        }
        return new AllDependenciesMaps(source2dests, dest2sources);
    }

    public List<URL> getAllRemoteDependencies() throws IOException {
        Collection<? extends IndexResult> results = this.filterDeletedFiles(this.querySupport.query("imports", "", QuerySupport.Kind.PREFIX, new String[]{"imports"}));
        HashSet<String> paths = new HashSet<String>();
        for (IndexResult indexResult : results) {
            String importsValue = indexResult.getValue("imports");
            paths.addAll(this.decodeListValue(importsValue));
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String p : paths) {
            if (p.startsWith("//")) {
                p = "http:" + p;
            }
            if (!p.startsWith("http")) continue;
            try {
                urls.add(new URL(p));
            }
            catch (MalformedURLException ex) {}
        }
        return urls;
    }

    public DependenciesGraph getDependencies(FileObject cssFile) {
        try {
            DependenciesGraph deps = new DependenciesGraph(cssFile);
            AllDependenciesMaps alldeps = this.getAllDependencies();
            this.resolveDependencies(deps.getSourceNode(), alldeps.getSource2dest(), alldeps.getDest2source());
            return deps;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private void resolveDependencies(DependenciesGraph.Node base, Map<FileObject, Collection<FileReference>> source2dests, Map<FileObject, Collection<FileReference>> dest2sources) {
        Collection<FileReference> sources;
        FileObject baseFile = base.getFile();
        Collection<FileReference> destinations = source2dests.get(baseFile);
        if (destinations != null) {
            for (FileReference destinationReference : destinations) {
                FileObject destination = destinationReference.target();
                DependenciesGraph.Node node = base.getDependencyGraph().getNode(destination);
                if (!base.addReferedNode(node)) continue;
                this.resolveDependencies(node, source2dests, dest2sources);
            }
        }
        if ((sources = dest2sources.get(baseFile)) != null) {
            for (FileReference sourceReference : sources) {
                FileObject source = sourceReference.source();
                DependenciesGraph.Node node = base.getDependencyGraph().getNode(source);
                if (!base.addReferingNode(node)) continue;
                this.resolveDependencies(node, source2dests, dest2sources);
            }
        }
    }

    private Collection<String> decodeListValue(String value) {
        assert (value.charAt(value.length() - 1) == ';');
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value.substring(0, value.length() - 1), ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private Collection<? extends IndexResult> filterDeletedFiles(Collection<? extends IndexResult> queryResult) {
        ArrayList<IndexResult> filtered = new ArrayList<IndexResult>();
        for (IndexResult indexResult : queryResult) {
            if (indexResult.getFile() == null) continue;
            filtered.add(indexResult);
        }
        return filtered;
    }

    public static class AllDependenciesMaps {
        Map<FileObject, Collection<FileReference>> source2dest;
        Map<FileObject, Collection<FileReference>> dest2source;

        public AllDependenciesMaps(Map<FileObject, Collection<FileReference>> source2dest, Map<FileObject, Collection<FileReference>> dest2source) {
            this.source2dest = source2dest;
            this.dest2source = dest2source;
        }

        public Map<FileObject, Collection<FileReference>> getDest2source() {
            return this.dest2source;
        }

        public Map<FileObject, Collection<FileReference>> getSource2dest() {
            return this.source2dest;
        }
    }
}

