/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.actions;

import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.css.model.api.Body;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.Selector;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.html.editor.Utils;
import org.netbeans.modules.html.editor.api.actions.AbstractSourceElementAction;
import org.netbeans.modules.html.editor.api.actions.Bundle;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.ui.ModifyElementRulesPanel;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ModifyElementRulesAction
extends AbstractSourceElementAction {
    private int pos;
    private int diff;

    public ModifyElementRulesAction(FileObject file, String elementPath) {
        super(file, elementPath);
        this.putValue("Name", Bundle.action_name_modify_rules());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            final AbstractSourceElementAction.SourceElementHandle handle = this.createSourceElementHandle();
            if (!handle.isResolved()) {
                return;
            }
            final ModifyElementRulesPanel panel = new ModifyElementRulesPanel(handle);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.action_name_modify_rules(), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource().equals(DialogDescriptor.OK_OPTION)) {
                        if (!panel.isModified()) {
                            return;
                        }
                        if (panel.isPanelContentValid()) {
                            ModifyElementRulesAction.this.applyChanges(panel, handle);
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }
            });
            Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setVisible(true);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void applyChanges(final ModifyElementRulesPanel panel, final AbstractSourceElementAction.SourceElementHandle handle) {
        final BaseDocument doc = (BaseDocument)Utils.getDocument(this.file);
        final AtomicBoolean success = new AtomicBoolean();
        this.pos = Integer.MAX_VALUE;
        this.diff = -1;
        doc.runAtomicAsUser(new Runnable(){

            @Override
            public void run() {
                try {
                    ModifyElementRulesAction.this.updateAttribute(handle, (Document)doc, panel.getOriginalClassAttribute(), panel.getNewClassAttributeValue(), "class");
                    ModifyElementRulesAction.this.updateAttribute(handle, (Document)doc, panel.getOriginalIdAttribute(), panel.getNewIdAttributeValue(), "id");
                    success.set(true);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        if (success.get()) {
            try {
                Utils.saveDocumentIfNotOpened((Document)doc);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.applyChangesToStyleSheets(panel, handle);
        }
    }

    private void applyChangesToStyleSheets(final ModifyElementRulesPanel panel, AbstractSourceElementAction.SourceElementHandle handle) {
        try {
            if (panel.getSelectedStyleSheet() == null) {
                return;
            }
            final Model model = Utils.createCssSourceModel(Source.create((FileObject)panel.getSelectedStyleSheet()));
            final ElementFactory factory = model.getElementFactory();
            model.runWriteTask(new Model.ModelTask(){

                public void run(StyleSheet styleSheet) {
                    try {
                        String justOne;
                        String[] classes;
                        Body body = styleSheet.getBody();
                        if (body == null) {
                            body = factory.createBody();
                            styleSheet.setBody(body);
                        }
                        if ((classes = panel.getNewClasses()) != null && classes.length == 1 && !panel.classExistsInSelectedStyleSheet(justOne = classes[0])) {
                            Rule rule = ModifyElementRulesAction.this.createRule(factory, "." + justOne);
                            styleSheet.getBody().addRule(rule);
                        }
                        if (!panel.idExistsInSelectedStyleSheet()) {
                            Rule rule = ModifyElementRulesAction.this.createRule(factory, "#" + panel.getNewIdAttributeValue());
                            styleSheet.getBody().addRule(rule);
                        }
                        model.applyChanges();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Rule createRule(ElementFactory factory, String selector) {
        Selector s = factory.createSelector((CharSequence)selector);
        SelectorsGroup sg = factory.createSelectorsGroup(new Selector[]{s});
        Declarations ds = factory.createDeclarations();
        return factory.createRule(sg, ds);
    }

    private void updateAttribute(AbstractSourceElementAction.SourceElementHandle handle, Document doc, Attribute a, String value, String name) throws BadLocationException {
        OpenTag ot = handle.getOpenTag();
        Snapshot snap = handle.getSnapshot();
        if (a == null && value == null) {
            return;
        }
        if (a == null && value != null) {
            int insertPos = snap.getOriginalOffset(ot.from() + 1 + ot.name().length());
            StringBuilder sb = new StringBuilder();
            sb.append(' ');
            sb.append(name);
            sb.append('=');
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
            doc.insertString(insertPos, sb.toString(), null);
            this.pos = insertPos;
            this.diff = sb.length();
        } else if (a != null && value == null) {
            int removeFrom = a.from() - 1;
            int removeTo = a.to();
            int rfdoc = snap.getOriginalOffset(removeFrom);
            int rtdoc = snap.getOriginalOffset(removeTo);
            if (rfdoc >= this.pos) {
                rfdoc += this.diff;
                rtdoc += this.diff;
            }
            doc.remove(rfdoc, rtdoc - rfdoc);
            this.pos = removeFrom;
            this.diff = rfdoc - rtdoc;
        } else {
            int removeFrom = a.from();
            int removeTo = a.to();
            int rfdoc = snap.getOriginalOffset(removeFrom);
            int rtdoc = snap.getOriginalOffset(removeTo);
            if (rfdoc >= this.pos) {
                rfdoc += this.diff;
                rtdoc += this.diff;
            }
            doc.remove(rfdoc, rtdoc - rfdoc);
            int insertPos = rfdoc;
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('=');
            sb.append('\"');
            sb.append(value);
            sb.append('\"');
            doc.insertString(insertPos, sb.toString(), null);
            this.pos = insertPos;
            this.diff = rfdoc - rtdoc + sb.length();
        }
    }
}

