/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.text.Document;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class Utils {
    public static void saveDocumentIfNotOpened(Document document) throws IOException {
        SaveCookie save;
        Object o = document.getProperty("stream");
        if (o == null || !(o instanceof DataObject)) {
            return;
        }
        DataObject dobj = (DataObject)o;
        EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
        if (ec != null && ec.getOpenedPanes() == null && (save = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class)) != null) {
            save.save();
        }
    }

    public static Document getDocument(FileObject file) {
        try {
            DataObject d = DataObject.find((FileObject)file);
            EditorCookie ec = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            return ec.openDocument();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Model createCssSourceModel(Source source) throws ParseException {
        final AtomicReference model_ref = new AtomicReference();
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/css");
                if (ri != null) {
                    CssParserResult result = (CssParserResult)ri.getParserResult();
                    model_ref.set(Model.getModel((CssParserResult)result));
                }
            }
        });
        return (Model)model_ref.get();
    }
}

