/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ErrorFilter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.gsf.ErrorBadgingRule;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.HtmlHintsProvider;
import org.netbeans.modules.html.editor.lib.api.SyntaxAnalyzerResult;
import org.netbeans.modules.web.common.api.WebPageMetadata;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class HtmlErrorFilter
implements ErrorFilter {
    public static final String DISABLE_ERROR_CHECKS_KEY = "disable_error_checking";
    private static final ErrorFilter INSTANCE = new HtmlErrorFilter();
    private HintsProvider htmlHintsProvider = new HtmlHintsProvider();
    private HintsProvider.HintsManager htmlHintsManager = HintsProvider.HintsManager.getManagerForMimeType((String)"text/html");

    public List<? extends Error> filter(ParserResult parserResult) {
        if (!(parserResult instanceof HtmlParserResult)) {
            return null;
        }
        RuleContext context = this.htmlHintsProvider.createRuleContext();
        context.parserResult = parserResult;
        context.manager = this.htmlHintsManager;
        context.doc = (BaseDocument)parserResult.getSnapshot().getSource().getDocument(false);
        ArrayList hints = new ArrayList();
        this.htmlHintsProvider.computeErrors(this.htmlHintsManager, context, hints, new ArrayList());
        ArrayList<BadgingDefaultError> filtered = new ArrayList<BadgingDefaultError>(hints.size());
        block5: for (Hint h : hints) {
            Severity severity;
            Rule rule = h.getRule();
            if (!rule.showInTasklist()) continue;
            HintSeverity hs = rule.getDefaultSeverity();
            switch (hs) {
                case ERROR: {
                    severity = Severity.ERROR;
                    break;
                }
                case WARNING: {
                    severity = Severity.WARNING;
                    break;
                }
                case INFO: {
                    severity = Severity.INFO;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            BadgingDefaultError e = new BadgingDefaultError("error", h.getDescription(), h.getDescription(), h.getFile(), h.getRange().getStart(), h.getRange().getEnd(), severity, rule instanceof ErrorBadgingRule);
            filtered.add(e);
        }
        return filtered;
    }

    public static boolean isErrorCheckingEnabled(SyntaxAnalyzerResult result) {
        return !HtmlErrorFilter.isErrorCheckingDisabledForFile(result) && HtmlErrorFilter.isErrorCheckingEnabledForMimetype(result);
    }

    public static boolean isErrorCheckingDisabledForFile(SyntaxAnalyzerResult result) {
        FileObject fo = result.getSource().getSourceFileObject();
        return fo != null && fo.getAttribute(DISABLE_ERROR_CHECKS_KEY) != null;
    }

    public static boolean isErrorCheckingEnabledForMimetype(SyntaxAnalyzerResult result) {
        return HtmlPreferences.isHtmlErrorCheckingEnabledForMimetype(HtmlErrorFilter.getWebPageMimeType(result));
    }

    public static String getWebPageMimeType(SyntaxAnalyzerResult result) {
        String mimeType;
        InstanceContent ic = new InstanceContent();
        ic.add((Object)result);
        WebPageMetadata wpmeta = WebPageMetadata.getMetadata((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        if (wpmeta != null && (mimeType = (String)wpmeta.value("mimeType")) != null) {
            return mimeType;
        }
        FileObject fo = result.getSource().getSourceFileObject();
        if (fo != null) {
            return fo.getMIMEType();
        }
        return result.getSource().getSnapshot().getMimeType();
    }

    private class BadgingDefaultError
    extends DefaultError
    implements Error.Badging {
        private boolean badging;

        public BadgingDefaultError(String key, String displayName, String description, FileObject file, int start, int end, Severity severity, boolean badging) {
            super(key, displayName, description, file, start, end, severity);
            this.badging = badging;
        }

        public boolean showExplorerBadge() {
            return this.badging;
        }
    }

    public static class Factory
    implements ErrorFilter.Factory {
        public ErrorFilter createErrorFilter(String featureName) {
            return "tasklist".equals(featureName) ? INSTANCE : null;
        }
    }
}

