/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.xhtml.XhtmlElTokenId;
import org.netbeans.modules.web.indent.api.LexUtilities;
import org.openide.util.Exceptions;

public class HtmlAutoCompletion {
    static boolean adjust_quote_type_after_eq = true;
    static char default_quote_char_after_eq = (char)34;
    private static DocumentInsertIgnore insertIgnore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean beforeCharInserted(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        try {
            if (insertIgnore != null && insertIgnore.getOffset() == dotPos && insertIgnore.getChar() == ch) {
                if (insertIgnore.getMoveCaretTo() != -1) {
                    caret.setDot(insertIgnore.moveCaretTo);
                    Completion.get().hideAll();
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            insertIgnore = null;
        }
        if ((ch == '\"' || ch == '\'') && HtmlPreferences.autocompleteQuotes()) {
            return HtmlAutoCompletion.handleQuotationMark(doc, dotPos, caret, ch);
        }
        return false;
    }

    public static boolean charBackspaced(final BaseDocument doc, final int dotPos, Caret caret, char ch) throws BadLocationException {
        TokenSequence ts;
        if ((ch == '\'' || ch == '\"') && (ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language())) != null) {
            char first;
            Token token;
            int diff = ts.move(dotPos);
            if (diff == 0) {
                if (!ts.movePrevious()) {
                    return false;
                }
            } else if (diff > 0) {
                if (!ts.moveNext()) {
                    return false;
                }
            } else {
                return false;
            }
            if ((token = ts.token()).id() == HTMLTokenId.OPERATOR && ts.moveNext() && ((token = ts.token()).id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.VALUE_CSS || token.id() == HTMLTokenId.VALUE_JAVASCRIPT) && token.length() > 0 && (first = token.text().charAt(0)) == ch) {
                final AtomicBoolean result_ref = new AtomicBoolean();
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            doc.remove(dotPos, 1);
                            result_ref.set(true);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
                return result_ref.get();
            }
        }
        return false;
    }

    public static void charInserted(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        if (ch == '=') {
            if (HtmlPreferences.autocompleteQuotesAfterEqualSign()) {
                HtmlAutoCompletion.completeQuotes(doc, dotPos, caret);
            }
        } else if (ch == '\'' || ch == '\"') {
            if (HtmlPreferences.autocompleteQuotesAfterEqualSign()) {
                HtmlAutoCompletion.transformQuotesType(doc, dotPos, caret, ch);
            }
        } else if (ch == '{') {
            HtmlAutoCompletion.handleEL(doc, dotPos, caret);
        } else if (ch == '/') {
            HtmlAutoCompletion.handleEmptyTagCloseSymbol(doc, dotPos, caret);
        } else if (ch == '>') {
            HtmlAutoCompletion.handleTagClosingSymbol(doc, dotPos, ch);
        }
    }

    private static void handleTagClosingSymbol(final BaseDocument doc, int dotPos, char lastChar) throws BadLocationException {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        for (LanguagePath languagePath : tokenHierarchy.languagePaths()) {
            if (languagePath.innerLanguage() != HTMLTokenId.language()) continue;
            TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language());
            if (ts == null) {
                return;
            }
            ts.move(dotPos);
            boolean found = false;
            while (ts.movePrevious()) {
                if (ts.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                    found = true;
                    break;
                }
                if (ts.token().id() == HTMLTokenId.ARGUMENT || ts.token().id() == HTMLTokenId.OPERATOR || HtmlAutoCompletion.isHtmlValueToken(ts.token()) || ts.token().id() == HTMLTokenId.WS || ts.token().id() == HTMLTokenId.TAG_CLOSE || ts.token().id() == HTMLTokenId.TAG_OPEN) continue;
            }
            if (!found) {
                return;
            }
            try {
                int lineStart = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)ts.offset());
                if (lineStart != ts.offset()) {
                    return;
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            final Position from = doc.createPosition(Utilities.getRowStart((BaseDocument)doc, (int)dotPos));
            final Position to = doc.createPosition(Utilities.getRowEnd((BaseDocument)doc, (int)dotPos));
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    final Indent indent = Indent.get((Document)doc);
                    indent.lock();
                    try {
                        doc.runAtomic(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    indent.reindent(from.getOffset(), to.getOffset());
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    finally {
                        indent.unlock();
                    }
                }
            });
            return;
        }
    }

    private static void handleEmptyTagCloseSymbol(BaseDocument doc, int dotPos, Caret caret) throws BadLocationException {
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language());
        if (ts == null) {
            return;
        }
        ts.move(dotPos);
        if (!ts.moveNext()) {
            return;
        }
        Token token = ts.token();
        if (token.id() == HTMLTokenId.ERROR && ts.movePrevious() && (ts.token().id() == HTMLTokenId.TAG_OPEN || ts.token().id() == HTMLTokenId.WS || HtmlAutoCompletion.isHtmlValueToken(ts.token()))) {
            doc.insertString(dotPos + 1, ">", null);
            insertIgnore = new DocumentInsertIgnore(dotPos + 2, '>', -1);
        }
    }

    private static boolean handleQuotationMark(BaseDocument doc, int dotPos, Caret caret, char qchar) throws BadLocationException {
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language());
        if (ts == null) {
            return false;
        }
        int diff = ts.move(dotPos);
        if (diff == 0 ? !ts.movePrevious() : !ts.moveNext()) {
            return false;
        }
        Token token = ts.token();
        try {
            if (HtmlAutoCompletion.isHtmlValueToken(token)) {
                if (diff > 0 && token.text().charAt(diff) == qchar) {
                    caret.setDot(dotPos + 1);
                    return true;
                }
            } else if (token.id() == HTMLTokenId.OPERATOR) {
                Token next;
                if (ts.moveNext() && HtmlAutoCompletion.isHtmlValueToken(next = ts.token())) {
                    return false;
                }
                StringBuilder insert = new StringBuilder().append(qchar).append(qchar);
                doc.insertString(dotPos, insert.toString(), null);
                caret.setDot(dotPos + 1);
                return true;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    private static boolean isHtmlValueToken(Token token) {
        TokenId id = token.id();
        return id == HTMLTokenId.VALUE || id == HTMLTokenId.VALUE_CSS || id == HTMLTokenId.VALUE_JAVASCRIPT;
    }

    private static void completeQuotes(BaseDocument doc, int dotPos, Caret caret) {
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language());
        if (ts == null) {
            return;
        }
        ts.move(dotPos);
        if (!ts.moveNext()) {
            return;
        }
        Token token = ts.token();
        int dotPosAfterTypedChar = dotPos + 1;
        if (token != null && token.id() == HTMLTokenId.OPERATOR) {
            try {
                String insert = "" + default_quote_char_after_eq + default_quote_char_after_eq;
                doc.insertString(dotPosAfterTypedChar, insert, null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            caret.setDot(dotPosAfterTypedChar + 1);
        }
    }

    private static void transformQuotesType(BaseDocument doc, int dotPos, Caret caret, char expected) {
        String pattern;
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)doc, (int)dotPos, (Language)HTMLTokenId.language());
        if (ts == null) {
            return;
        }
        ts.move(dotPos);
        if (!ts.moveNext()) {
            return;
        }
        Token token = ts.token();
        int dotPosBeforeTypedChar = dotPos - 1;
        String text = ((Object)token.text()).toString();
        String string = pattern = expected == '\'' ? "\"'\"" : "'\"'";
        if (text.contentEquals(pattern)) {
            try {
                doc.remove(dotPosBeforeTypedChar, 1);
                doc.insertString(dotPosBeforeTypedChar, "" + expected, null);
                doc.remove(dotPosBeforeTypedChar + 2, 1);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            caret.setDot(dotPosBeforeTypedChar + 1);
        }
        if (adjust_quote_type_after_eq) {
            default_quote_char_after_eq = expected;
        }
    }

    private static void handleEL(BaseDocument doc, int dotPos, Caret caret) {
        char charBefore;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(XhtmlElTokenId.language());
        if (ts == null) {
            return;
        }
        int diff = ts.move(dotPos);
        if (diff == 0) {
            return;
        }
        if (!ts.moveNext()) {
            return;
        }
        Token token = ts.token();
        int dotPosAfterTypedChar = dotPos + 1;
        if (token.id() == XhtmlElTokenId.EL && ((charBefore = token.text().charAt(diff - 1)) == '$' || charBefore == '#')) {
            try {
                doc.insertString(dotPosAfterTypedChar, "}", null);
                caret.setDot(dotPosAfterTypedChar);
                Completion.get().showCompletion();
                insertIgnore = new DocumentInsertIgnore(dotPosAfterTypedChar, '}', dotPosAfterTypedChar + 1);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class DocumentInsertIgnore {
        private int offset;
        private char ch;
        private int moveCaretTo;

        public DocumentInsertIgnore(int offset, char ch, int moveCaretTo) {
            this.offset = offset;
            this.ch = ch;
            this.moveCaretTo = moveCaretTo;
        }

        public char getChar() {
            return this.ch;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getMoveCaretTo() {
            return this.moveCaretTo;
        }
    }
}

